/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.web.xml.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import eu.europeana.entity.definitions.model.Organization;
import eu.europeana.entity.utils.EntityUtils;
import eu.europeana.entity.web.xml.model.RdfResource;

@JacksonXmlRootElement(localName="vcard:Address")
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"vcard:street-address", "vcard:postal-code", "vcard:post-office-box", "vcard:locality", "vcard:region", "vcard:country-name", "vcard:hasGeo"})
public class XmlAddressImpl {
    @JsonIgnore
    Organization organization;

    public XmlAddressImpl(Organization organization) {
        this.organization = organization;
    }

    @JacksonXmlProperty(isAttribute=true, localName="rdf:about")
    public String getAbout() {
        return this.organization.getHasAddress();
    }

    @JacksonXmlProperty(localName="vcard:street-address")
    public String getStreetAddress() {
        if (this.organization.getStreetAddress() == null || this.organization.getStreetAddress().isEmpty()) {
            return null;
        }
        return this.organization.getStreetAddress();
    }

    @JacksonXmlProperty(localName="vcard:postal-code")
    public String getPostalCode() {
        if (this.organization.getPostalCode() == null || this.organization.getPostalCode().isEmpty()) {
            return null;
        }
        return this.organization.getPostalCode();
    }

    @JacksonXmlProperty(localName="vcard:post-office-box")
    public String getPostBox() {
        if (this.organization.getPostBox() == null || this.organization.getPostBox().isEmpty()) {
            return null;
        }
        return this.organization.getPostBox();
    }

    @JacksonXmlProperty(localName="vcard:locality")
    public String getLocality() {
        if (this.organization.getLocality() == null || this.organization.getLocality().isEmpty()) {
            return null;
        }
        return this.organization.getLocality();
    }

    @JacksonXmlProperty(localName="vcard:region")
    public String getRegion() {
        if (this.organization.getRegion() == null || this.organization.getRegion().isEmpty()) {
            return null;
        }
        return this.organization.getRegion();
    }

    @JacksonXmlProperty(localName="vcard:country-name")
    public String getCountryName() {
        if (this.organization.getCountryName() == null || this.organization.getCountryName().isEmpty()) {
            return null;
        }
        return this.organization.getCountryName();
    }

    @JacksonXmlProperty(localName="vcard:hasGeo")
    public RdfResource getHasGeo() {
        if (this.organization.getHasGeo() == null || this.organization.getHasGeo().isEmpty()) {
            return null;
        }
        return new RdfResource(EntityUtils.toGeoUri((String)this.organization.getHasGeo()));
    }
}

