/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.web.jsonld;

import eu.europeana.api.commons.definitions.search.result.ResultsPage;
import eu.europeana.api.commons.utils.ResultsPageSerializer;
import eu.europeana.entity.definitions.exceptions.UnsupportedEntityTypeException;
import eu.europeana.entity.definitions.model.Entity;
import eu.europeana.entity.utils.jsonld.EntityJsonComparator;
import eu.europeana.entity.utils.jsonld.EuropeanaEntityLd;
import eu.europeana.entity.web.exception.FunctionalRuntimeException;
import java.util.Comparator;
import java.util.Map;
import org.apache.stanbol.commons.jsonld.JsonLdProperty;
import org.apache.stanbol.commons.jsonld.JsonLdPropertyValue;
import org.apache.stanbol.commons.jsonld.JsonLdResource;

public class EntityResultsPageSerializer<T extends Entity>
extends ResultsPageSerializer<T> {
    String entityIdBaseUrl;

    public EntityResultsPageSerializer(ResultsPage<T> resPage, String context, String type, String entityIdBaseUrl) {
        super(resPage, context, type);
        this.entityIdBaseUrl = entityIdBaseUrl;
        this.setPropOrderComparator((Comparator)new EntityJsonComparator());
    }

    protected void serializeItems(JsonLdResource jsonLdResource, String profile) {
        this.registerContainerProperty("items");
        if (this.getResultsPage().getItems() == null || this.getResultsPage().getItems().isEmpty()) {
            return;
        }
        JsonLdProperty itemsProp = new JsonLdProperty("items");
        for (Entity entity : this.getResultsPage().getItems()) {
            this.serializeItem(itemsProp, entity);
        }
        jsonLdResource.putProperty(itemsProp);
    }

    private void serializeItem(JsonLdProperty itemsProp, Entity entity) {
        EuropeanaEntityLd entityLd;
        try {
            entityLd = new EuropeanaEntityLd(entity, this.entityIdBaseUrl);
        }
        catch (UnsupportedEntityTypeException e) {
            throw new FunctionalRuntimeException("Cannot serialize entity of type: " + entity.getType(), (Throwable)e);
        }
        JsonLdPropertyValue propertyValue = new JsonLdPropertyValue();
        Map propertyMap = propertyValue.getPropertyMap();
        Map entityProps = entityLd.getLdResource().getPropertyMap();
        entityProps.remove("@context");
        propertyMap.putAll(entityProps);
        itemsProp.addValue(propertyValue);
    }

    public boolean isContainerProperty(String property) {
        return !"isPartOf".equals(property) && super.isContainerProperty(property);
    }
}

