/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.web.controller;

import eu.europeana.api.common.config.swagger.SwaggerSelect;
import eu.europeana.api.commons.definitions.statistics.entity.EntityMetric;
import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.entity.stats.exception.UsageStatsException;
import eu.europeana.entity.web.controller.BaseRest;
import eu.europeana.entity.web.controller.exception.EntityApiRuntimeException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@Api(tags={"Usage Statistics API"})
@SwaggerSelect
public class UsageStatsController
extends BaseRest {
    @ApiOperation(value="Generate Stats", nickname="generateStats", response=Void.class)
    @GetMapping(value={"/entity/stats"}, produces={"application/json"})
    public ResponseEntity<String> generateUsageStats(@RequestParam(value="wskey", required=false) String wskey, HttpServletRequest request) throws EuropeanaApiException, HttpException {
        if (this.isAuthEnabled(this.webConfig.getApiKeyServiceUrl())) {
            this.verifyReadAccess(request);
        }
        return this.getEntitiesStats();
    }

    private ResponseEntity<String> getEntitiesStats() throws UsageStatsException, EntityApiRuntimeException {
        EntityMetric metric = new EntityMetric();
        metric.setType("OverallTotal");
        this.getUsageStatsService().getStatsForLang(metric);
        metric.setTimestamp(new Date());
        return new ResponseEntity((Object)this.serializeMetricView(metric), HttpStatus.OK);
    }
}

