/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.web.xml.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import eu.europeana.entity.definitions.model.Agent;
import eu.europeana.entity.definitions.model.Entity;
import eu.europeana.entity.web.xml.model.RdfResource;
import eu.europeana.entity.web.xml.model.RdfXmlUtils;
import eu.europeana.entity.web.xml.model.XmlBaseEntityImpl;
import eu.europeana.entity.web.xml.model.XmlMultilingualString;
import java.util.List;

@JacksonXmlRootElement(localName="edm:Agent")
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"foaf:depiction", "skos:prefLabel", "skos:altLabel", "skos:hiddenLabel", "foaf:name", "edm:begin", "rdaGr2:dateOfBirth", "rdaGr2:dateOfEstablishment", "edm:end", "rdaGr2:dateOfDeath", "rdaGr2:dateOfTermination", "dc:date", "rdaGr2:placeOfBirth", "rdaGr2:placeOfDeath", "rdaGr2:gender", "rdaGr2:professionOrOccupation", "rdaGr2:biographicalInformation", "skos:note", "dcterms:hasPart", "dcterms:isPartOf", "edm:hasMet", "edm:isRelatedTo", "dc:identifier", "owl:sameAs", "ore:isAggregatedBy"})
public class XmlAgentImpl
extends XmlBaseEntityImpl {
    public XmlAgentImpl(Agent agent) {
        super((Entity)agent);
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="skos:hiddenLabel")
    public List<XmlMultilingualString> getHiddenLabel() {
        return RdfXmlUtils.convertToXmlMultilingualString(this.entity.getHiddenLabel());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="skos:note")
    public List<XmlMultilingualString> getNote() {
        return RdfXmlUtils.convertToXmlMultilingualString(this.entity.getNote());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="dc:identifier")
    public String[] getIdentifier() {
        return this.entity.getIdentifier();
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="dcterms:hasPart")
    public List<RdfResource> getHasPart() {
        return RdfXmlUtils.convertToRdfResource(this.getAgent().getHasPart());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="dcterms:isPartOf")
    public List<RdfResource> getIsPartOf() {
        return RdfXmlUtils.convertToRdfResource(this.getAgent().getIsPartOf());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="edm:begin")
    public String[] getBegin() {
        return this.getAgent().getBegin();
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="edm:end")
    public String[] getEnd() {
        return this.getAgent().getEnd();
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="edm:hasMet")
    public List<RdfResource> getHasMet() {
        return RdfXmlUtils.convertToRdfResource(this.getAgent().getHasMet());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="edm:isRelatedTo")
    public List<RdfResource> getIsRelatedTo() {
        return RdfXmlUtils.convertToRdfResource(this.getAgent().getIsRelatedTo());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="foaf:name")
    public List<XmlMultilingualString> getName() {
        return RdfXmlUtils.convertMapToXmlMultilingualString(this.getAgent().getName());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="rdaGr2:biographicalInformation")
    public List<XmlMultilingualString> getBiographicalInformation() {
        return RdfXmlUtils.convertToXmlMultilingualString(this.getAgent().getBiographicalInformation());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="rdaGr2:dateOfBirth")
    public String[] getDateOfBirth() {
        return this.getAgent().getDateOfBirth();
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="rdaGr2:dateOfDeath")
    public String[] getDateOfDeath() {
        return this.getAgent().getDateOfDeath();
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="rdaGr2:dateOfEstablishment")
    public String getDateOfEstablishment() {
        return this.getAgent().getDateOfEstablishment();
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="rdaGr2:dateOfTermination")
    public String getDateOfTermination() {
        return this.getAgent().getDateOfTermination();
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="rdaGr2:gender")
    public String getGender() {
        return this.getAgent().getGender();
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="rdaGr2:placeOfBirth")
    public List<Object> getPlaceOfBirth() {
        return RdfXmlUtils.convertToXmlMultilingualStringOrRdfResource(this.getAgent().getPlaceOfBirth());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="rdaGr2:placeOfDeath")
    public List<Object> getPlaceOfDeath() {
        return RdfXmlUtils.convertToXmlMultilingualStringOrRdfResource(this.getAgent().getPlaceOfDeath());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="rdaGr2:professionOrOccupation")
    public List<Object> getProfessionOrOccupation() {
        return RdfXmlUtils.convertToXmlMultilingualStringOrRdfResource(this.getAgent().getProfessionOrOccupation());
    }

    @Override
    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="owl:sameAs")
    public List<RdfResource> getSameAs() {
        return RdfXmlUtils.convertToRdfResource(this.getAgent().getSameAs());
    }

    @JsonIgnore
    private Agent getAgent() {
        return (Agent)this.entity;
    }
}

