/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.app;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SocksProxyConfig {
    private static final String SOCKS_ENABLED = "socks.enabled";
    private static final String SOCKS_HOST = "socks.host";
    private static final String SOCKS_PORT = "socks.port";
    private static final String SOCKS_USER = "socks.user";
    private static final String SOCKS_PASS = "socks.password";
    private static final Logger LOG = LogManager.getLogger(SocksProxyConfig.class);
    private final Properties props = new Properties();

    public SocksProxyConfig(String ... propertiesFileNames) {
        for (String fileName : propertiesFileNames) {
            this.addProperties(fileName);
        }
    }

    private void addProperties(String propertiesFileName) {
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertiesFileName);){
            if (in == null) {
                LOG.warn("Properties file {} does not exist!", (Object)propertiesFileName);
            } else {
                this.props.load(in);
            }
        }
        catch (IOException e) {
            LOG.error("Error reading properties file {}!", (Object)propertiesFileName, (Object)e);
        }
    }

    public boolean isSocksEnabled() {
        return Boolean.parseBoolean(this.props.getProperty(SOCKS_ENABLED, "false"));
    }

    public String getHost() {
        return this.props.getProperty(SOCKS_HOST);
    }

    public String getPort() {
        return this.props.getProperty(SOCKS_PORT);
    }

    public String getUser() {
        return this.props.getProperty(SOCKS_USER);
    }

    public String getPassword() {
        return this.props.getProperty(SOCKS_PASS);
    }
}

