/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.web.xml.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import eu.europeana.entity.definitions.model.Entity;
import eu.europeana.entity.definitions.model.impl.BaseEntity;
import eu.europeana.entity.web.xml.model.EdmWebResource;
import eu.europeana.entity.web.xml.model.RdfResource;
import eu.europeana.entity.web.xml.model.RdfXmlUtils;
import eu.europeana.entity.web.xml.model.XmlAggregationImpl;
import eu.europeana.entity.web.xml.model.XmlIsAggregatedByImpl;
import eu.europeana.entity.web.xml.model.XmlMultilingualString;
import eu.europeana.entity.web.xml.model.XmlWebResourceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class XmlBaseEntityImpl {
    @JsonIgnore
    Entity entity;
    @JsonIgnore
    String aggregationId;
    @JsonIgnore
    List<Object> referencedWebResources;

    public List<Object> getReferencedWebResources() {
        return this.referencedWebResources;
    }

    public XmlBaseEntityImpl(Entity entity) {
        this.entity = entity;
        this.aggregationId = entity.getEntityId() + "#aggregation";
        this.referencedWebResources = new ArrayList();
    }

    @JacksonXmlProperty(isAttribute=true, localName="rdf:about")
    public String getAbout() {
        return this.entity.getEntityId();
    }

    @JacksonXmlProperty(localName="ore:isAggregatedBy")
    public XmlIsAggregatedByImpl getIsAggregatedBy() {
        if (this.entity.getCreated() == null && this.entity.getModified() == null) {
            return null;
        }
        return new XmlIsAggregatedByImpl(this.aggregationId);
    }

    public XmlAggregationImpl createXmlAggregation() {
        if (this.entity.getCreated() == null && this.entity.getModified() == null) {
            return null;
        }
        return new XmlAggregationImpl(this.entity);
    }

    @JacksonXmlProperty(localName="foaf:depiction")
    public EdmWebResource getDepiction() {
        if (this.entity.getDepiction() == null) {
            return null;
        }
        return new EdmWebResource(this.entity.getDepiction());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="skos:prefLabel")
    public List<XmlMultilingualString> getPrefLabel() {
        return RdfXmlUtils.toXmlMultilingualString((Map)this.entity.getPrefLabel());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="skos:altLabel")
    public List<XmlMultilingualString> getAltLabel() {
        return RdfXmlUtils.convertToXmlMultilingualString((Map)this.entity.getAltLabel());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="owl:sameAs")
    public List<RdfResource> getSameAs() {
        return RdfXmlUtils.convertToRdfResource((String[])this.entity.getSameAs());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="edm:isShownBy")
    public RdfResource getIsShownBy() {
        if (((BaseEntity)this.entity).getIsShownById() != null) {
            this.referencedWebResources.add(new XmlWebResourceImpl(((BaseEntity)this.entity).getIsShownById(), ((BaseEntity)this.entity).getIsShownBySource(), ((BaseEntity)this.entity).getIsShownByThumbnail()));
            return new RdfResource(((BaseEntity)this.entity).getIsShownById());
        }
        return null;
    }
}

