/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.web.service;

import eu.europeana.api.commons.definitions.vocabulary.Role;
import eu.europeana.api.commons.service.authorization.AuthorizationService;
import eu.europeana.api.commons.service.authorization.BaseAuthorizationService;
import eu.europeana.entity.web.config.EntityWebConfig;
import eu.europeana.entity.web.model.vocabulary.UserRoles;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.stereotype.Component;

@Component(value="entityAuthorizationService")
public class EntityAuthorizationService
extends BaseAuthorizationService
implements AuthorizationService {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    @Resource(name="entityWebConfig")
    private EntityWebConfig entityWebConfig;
    @Resource(name="entityClientDetailsService")
    private ClientDetailsService clientDetailsService;

    protected ClientDetailsService getClientDetailsService() {
        return this.clientDetailsService;
    }

    protected String getSignatureKey() {
        return this.entityWebConfig.getJwtSignatureKey();
    }

    protected String getApiName() {
        return this.entityWebConfig.getAuthorizationApiName();
    }

    protected Role getRoleByName(String name) {
        return UserRoles.getRoleByName((String)name);
    }
}

