/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.web.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import eu.europeana.api.common.config.swagger.SwaggerSelect;
import eu.europeana.api.commons.definitions.search.Query;
import eu.europeana.api.commons.definitions.search.ResultSet;
import eu.europeana.api.commons.definitions.search.result.ResultsPage;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.entity.definitions.exceptions.UnsupportedEntityTypeException;
import eu.europeana.entity.definitions.model.search.SearchProfiles;
import eu.europeana.entity.definitions.model.vocabulary.SuggestAlgorithmTypes;
import eu.europeana.entity.solr.exception.EntityRetrievalException;
import eu.europeana.entity.solr.exception.InvalidSearchQueryException;
import eu.europeana.entity.solr.service.impl.EntityQueryBuilder;
import eu.europeana.entity.utils.EntityUtils;
import eu.europeana.entity.web.config.EntityWebConfig;
import eu.europeana.entity.web.controller.BaseRest;
import eu.europeana.entity.web.exception.InternalServerException;
import eu.europeana.entity.web.exception.ParamValidationException;
import eu.europeana.entity.web.jsonld.SuggestionSetSerializer;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@Api(tags={"Discovery API"})
@SwaggerSelect
public class SearchController
extends BaseRest {
    @Resource(name="entityWebConfig")
    private EntityWebConfig entityWebConfig;

    @ApiOperation(value="Suggest entities for the given text query. Suported values for type: Agent, Place, Concept, Timespan, All. Supported values for scope: europeana. Supported values for algorithm: monolingual (default), suggestByLabel", nickname="getSuggestion", response=Void.class)
    @RequestMapping(value={"/entity/suggest", "/entity/suggest.jsonld"}, method={RequestMethod.GET}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    public ResponseEntity<String> getSuggestion(@RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="text") String text, @RequestParam(value="language", defaultValue="en") String language, @RequestParam(value="scope", required=false) String scope, @RequestParam(value="type", defaultValue="All") String type, @RequestParam(value="rows", defaultValue="10") int rows, @RequestParam(value="algorithm", required=false, defaultValue="monolingual") String algorithm, HttpServletRequest request) throws HttpException {
        try {
            this.verifyReadAccess(request);
            SuggestAlgorithmTypes suggestType = this.validateAlgorithmParam(algorithm);
            String validatedText = this.preProcessQuery(text);
            EntityQueryBuilder queryBuilder = new EntityQueryBuilder();
            List entityTypes = this.getEntityService().getEntityTypesFromString(type);
            entityTypes = this.getEntityService().validateEntityTypes(entityTypes, true);
            this.validateScopeParam(scope);
            String[] requestedLanguages = queryBuilder.toArray(language);
            ResultSet results = this.getEntityService().suggest(validatedText, requestedLanguages, entityTypes, scope, null, rows, suggestType);
            SuggestionSetSerializer serializer = new SuggestionSetSerializer(results, this.entityWebConfig.getEntityDataEndpoint());
            String jsonLd = serializer.serialize();
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Allow", (Object)"GET");
            ResponseEntity response = new ResponseEntity((Object)jsonLd, (MultiValueMap)headers, HttpStatus.OK);
            return response;
        }
        catch (HttpException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
        catch (Exception e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    @ApiOperation(value="Search entities for the given text query. By default the search will return all entity fields. The facets profile and the facet param are available for including facets in the response. fl and lang params are used to reduce the amount of data included in the response", nickname="search", response=Void.class)
    @RequestMapping(value={"/entity/search", "/entity/search.jsonld"}, method={RequestMethod.GET}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    public ResponseEntity<String> search(@RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="query") String queryString, @RequestParam(value="qf", required=false) String[] qf, @RequestParam(value="fl", required=false) String fl, @RequestParam(value="facet", required=false) String facet, @RequestParam(value="lang", required=false) String outLanguage, @RequestParam(value="type", required=false, defaultValue="All") String type, @RequestParam(value="scope", required=false) String scope, @RequestParam(value="sort", required=false) String sort, @RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="pageSize", required=false, defaultValue="10") int pageSize, @RequestParam(value="profile", required=false) String profile, HttpServletRequest request) throws HttpException {
        try {
            this.verifyReadAccess(request);
            if (StringUtils.isBlank((CharSequence)queryString)) {
                throw new ParamValidationException("error.empty_param_mandatory", "query", queryString);
            }
            scope = this.validateScopeParam(scope);
            EntityQueryBuilder queryBuilder = new EntityQueryBuilder();
            List entityTypes = this.getEntityService().getEntityTypesFromString(type);
            entityTypes = this.getEntityService().validateEntityTypes(entityTypes, false);
            String[] preferredLanguages = null;
            if (outLanguage != null && !outLanguage.contains("all")) {
                preferredLanguages = queryBuilder.toArray(outLanguage);
            }
            SearchProfiles searchProfile = null;
            if (profile != null) {
                if (!SearchProfiles.contains((String)profile)) {
                    throw new ParamValidationException("profile", profile);
                }
                searchProfile = SearchProfiles.valueOf((String)profile.toLowerCase());
            }
            String[] retFields = queryBuilder.toArray(fl);
            String[] facets = queryBuilder.toArray(facet);
            String[] sortCriteria = queryBuilder.toArray(sort);
            Query searchQuery = queryBuilder.buildSearchQuery(queryString, qf, facets, sortCriteria, page, pageSize, searchProfile, retFields);
            ResultSet results = this.getEntityService().search(searchQuery, preferredLanguages, entityTypes, scope);
            ResultsPage resPage = this.getEntityService().buildResultsPage(searchQuery, results, request.getQueryString());
            String jsonLd = this.serializeResultsPage(resPage, searchProfile, this.entityWebConfig.getEntityDataEndpoint());
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Allow", (Object)"GET");
            ResponseEntity response = new ResponseEntity((Object)jsonLd, (MultiValueMap)headers, HttpStatus.OK);
            return response;
        }
        catch (UnsupportedEntityTypeException e) {
            throw new ParamValidationException("error.invalid_param_value", "type", type);
        }
        catch (InvalidSearchQueryException e) {
            throw new ParamValidationException("error.invalid_param_value", "query", e.getMessage());
        }
        catch (EntityRetrievalException e) {
            throw new InternalServerException(e.getMessage(), (Throwable)e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException((Throwable)e);
        }
        catch (RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    @ApiOperation(value="Performs a text based lookup for entities to inform enrichment services on Metis. Suported values for type: Agent, Place, Concept, Timespan, All. Supported values for scope: europeana", nickname="enrichEntity", response=Void.class)
    @RequestMapping(value={"/entity/enrich"}, method={RequestMethod.GET}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    public ResponseEntity<String> enrichEntity(@RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="text") String text, @RequestParam(value="lang", required=false) String lang, @RequestParam(value="type", required=false) String type, @RequestParam(value="rows", defaultValue="10") int rows, HttpServletRequest request) throws HttpException {
        try {
            this.verifyReadAccess(request);
            if (StringUtils.isBlank((CharSequence)text)) {
                throw new ParamValidationException("error.empty_param_mandatory", "query", text);
            }
            String validatedText = EntityUtils.escapeBackslashAndQuotes((String)text, (String)"\\", (String)"\"");
            this.validateLanguage(lang);
            List entityTypes = this.getEntityService().getEntityTypesFromString(type);
            EntityQueryBuilder queryBuilder = new EntityQueryBuilder();
            Query searchQuery = queryBuilder.buildSearchQueryForEnrichment(validatedText, lang, entityTypes, rows);
            ResultSet results = this.getEntityService().search(searchQuery, null, null, null);
            ResultsPage resPage = this.getEntityService().buildResultsPage(searchQuery, results, request.getQueryString());
            String jsonLd = this.serializeResultsPage(resPage, null, this.entityWebConfig.getEntityDataEndpoint());
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Allow", (Object)"GET");
            ResponseEntity response = new ResponseEntity((Object)jsonLd, (MultiValueMap)headers, HttpStatus.OK);
            return response;
        }
        catch (UnsupportedEntityTypeException e) {
            throw new ParamValidationException("error.entity_unsupported_type", "entity", e.getMessage());
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException((Throwable)e);
        }
        catch (RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
    }
}

