/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.web.xml.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import eu.europeana.entity.definitions.model.Entity;
import eu.europeana.entity.web.xml.model.RdfResource;
import eu.europeana.entity.web.xml.model.RdfTypedElement;

@JacksonXmlRootElement(localName="ore:Aggregation")
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"dcterms:created", "dcterms:modified", "ore:aggregates"})
public class XmlAggregationImpl {
    @JsonIgnore
    Entity entity;
    @JsonIgnore
    String id;
    @JsonIgnore
    private final String AGGREGATION_TAG = "#aggregation";

    public XmlAggregationImpl(Entity entity) {
        this.entity = entity;
        this.id = entity.getEntityId() + "#aggregation";
    }

    @JacksonXmlProperty(isAttribute=true, localName="rdf:about")
    public String getAbout() {
        return this.id;
    }

    @JacksonXmlProperty(localName="dcterms:created")
    public RdfTypedElement getCreated() {
        if (this.entity.getCreated() == null) {
            return null;
        }
        return new RdfTypedElement(this.entity.getCreated());
    }

    @JacksonXmlProperty(localName="dcterms:modified")
    public RdfTypedElement getModified() {
        if (this.entity.getModified() == null) {
            return null;
        }
        return new RdfTypedElement(this.entity.getModified());
    }

    @JacksonXmlProperty(localName="ore:aggregates")
    public RdfResource getAggregates() {
        return new RdfResource(this.entity.getEntityId());
    }
}

