/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.web.xml.model;

import eu.europeana.entity.web.xml.model.RdfResource;
import eu.europeana.entity.web.xml.model.XmlMultilingualString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;

public class RdfXmlUtils {
    public static List<RdfResource> convertToRdfResource(String[] elements) {
        if (elements == null) {
            return null;
        }
        ArrayList<RdfResource> res = new ArrayList<RdfResource>();
        for (int index = 0; index < elements.length; ++index) {
            res.add(new RdfResource(elements[index]));
        }
        return res;
    }

    public static XmlMultilingualString createMultilingualString(String language, String entryValue) {
        return new XmlMultilingualString(StringEscapeUtils.escapeXml11((String)entryValue), language);
    }

    public static List<XmlMultilingualString> convertToXmlMultilingualString(Map<String, List<String>> values) {
        if (values == null) {
            return null;
        }
        ArrayList<XmlMultilingualString> res = new ArrayList<XmlMultilingualString>();
        for (String language : values.keySet()) {
            List<String> entryValues = values.get(language);
            for (String entryValue : entryValues) {
                res.add(RdfXmlUtils.createMultilingualString(language, entryValue));
            }
        }
        return res;
    }

    public static List<XmlMultilingualString> toXmlMultilingualString(Map<String, String> values) {
        if (values == null) {
            return null;
        }
        ArrayList<XmlMultilingualString> res = new ArrayList<XmlMultilingualString>();
        for (String language : values.keySet()) {
            res.add(RdfXmlUtils.createMultilingualString(language, values.get(language)));
        }
        return res;
    }

    public static List<Object> convertToXmlMultilingualStringOrRdfResource(Map<String, List<String>> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Object> res = new ArrayList<Object>();
        for (String language : values.keySet()) {
            List<String> entryValues = values.get(language);
            for (String entryValue : entryValues) {
                if (RdfXmlUtils.isUri(entryValue)) {
                    res.add(new RdfResource(entryValue));
                    continue;
                }
                res.add(RdfXmlUtils.createMultilingualString(language, entryValue));
            }
        }
        return res;
    }

    private static boolean isUri(String entryValue) {
        return entryValue.startsWith("http:") || entryValue.startsWith("https:");
    }

    public static List<XmlMultilingualString> convertMapToXmlMultilingualString(Map<String, String> values) {
        if (values == null) {
            return null;
        }
        ArrayList<XmlMultilingualString> res = new ArrayList<XmlMultilingualString>();
        for (String language : values.keySet()) {
            res.add(RdfXmlUtils.createMultilingualString(language, values.get(language)));
        }
        return res;
    }
}

