/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.web.service.impl;

import eu.europeana.api.commons.definitions.search.Query;
import eu.europeana.api.commons.definitions.search.ResultSet;
import eu.europeana.api.commons.definitions.search.result.ResultsPage;
import eu.europeana.api.commons.definitions.search.result.impl.ResultsPageImpl;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.entity.definitions.exceptions.UnsupportedEntityTypeException;
import eu.europeana.entity.definitions.model.Entity;
import eu.europeana.entity.definitions.model.vocabulary.EntityTypes;
import eu.europeana.entity.definitions.model.vocabulary.SuggestAlgorithmTypes;
import eu.europeana.entity.solr.exception.EntityRetrievalException;
import eu.europeana.entity.solr.exception.EntitySuggestionException;
import eu.europeana.entity.solr.service.SolrEntityService;
import eu.europeana.entity.web.config.EntityWebConfig;
import eu.europeana.entity.web.exception.InternalServerException;
import eu.europeana.entity.web.exception.ParamValidationException;
import eu.europeana.entity.web.model.view.EntityPreview;
import eu.europeana.entity.web.service.EntityService;
import eu.europeana.entity.web.service.impl.BaseEntityServiceImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service(value="entityService")
public class EntityServiceImpl
extends BaseEntityServiceImpl
implements EntityService {
    @Resource(name="entitySolrService")
    SolrEntityService solrEntityService;
    @Resource(name="entityWebConfig")
    private EntityWebConfig entityWebConfig;

    @Override
    public Entity retrieveByUrl(String type, String identifier) throws HttpException {
        Entity result;
        String entityUri = this.buildStoredEntityId(type, identifier);
        try {
            result = this.solrEntityService.searchByUrl(type, entityUri);
        }
        catch (EntityRetrievalException e) {
            throw new HttpException(e.getMessage(), "error.entity_server_cannot_retrieve_uri", new String[]{entityUri}, HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        catch (UnsupportedEntityTypeException e) {
            throw new HttpException(null, "error.entity_unsupported_type", new String[]{"entity", type}, HttpStatus.NOT_FOUND, null);
        }
        if (result == null) {
            throw new HttpException(null, "error.not_found", new String[]{"entity", entityUri}, HttpStatus.NOT_FOUND, null);
        }
        return result;
    }

    private String buildStoredEntityId(String type, String identifier) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.entityWebConfig.getEntityIdBaseUrl());
        if (!this.entityWebConfig.getEntityIdBaseUrl().endsWith("/")) {
            stringBuilder.append("/");
        }
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            stringBuilder.append(type.toLowerCase()).append("/");
        }
        if (StringUtils.isNotEmpty((CharSequence)identifier)) {
            stringBuilder.append(identifier);
        }
        String entityUri = stringBuilder.toString();
        return entityUri;
    }

    @Override
    public ResultSet<? extends EntityPreview> suggest(String text, String[] language, List<EntityTypes> entityTypes, String scope, String namespace, int rows, SuggestAlgorithmTypes algorithm) throws InternalServerException, ParamValidationException {
        ResultSet res;
        try {
            switch (algorithm) {
                case suggestByLabel: {
                    res = this.solrEntityService.suggestByLabel(text, language, entityTypes, scope, rows);
                    break;
                }
                case monolingual: {
                    res = this.solrEntityService.suggestByLanguage(text, language, entityTypes, scope, rows);
                    break;
                }
                default: {
                    throw new ParamValidationException("algorithm", "" + algorithm);
                }
            }
        }
        catch (EntitySuggestionException e) {
            throw new InternalServerException(e);
        }
        return res;
    }

    @Override
    public List<String> resolveByUri(String uri) {
        List result = this.solrEntityService.searchByCoref(uri);
        return result;
    }

    @Override
    public ResultSet<? extends Entity> search(Query query, String[] outLanguage, List<EntityTypes> entityTypes, String scope) throws HttpException {
        return this.solrEntityService.search(query, outLanguage, entityTypes, scope);
    }

    @Override
    public List<EntityTypes> validateEntityTypes(List<EntityTypes> entityTypes, boolean suggest) throws ParamValidationException {
        if (!suggest) {
            if (this.isEmptyOrAll(entityTypes)) {
                return null;
            }
        } else if (this.isEmptyOrAll(entityTypes)) {
            if (entityTypes == null) {
                entityTypes = new ArrayList<EntityTypes>();
            }
            entityTypes.clear();
            entityTypes.add(EntityTypes.Concept);
            entityTypes.add(EntityTypes.Agent);
            entityTypes.add(EntityTypes.Place);
            entityTypes.add(EntityTypes.Organization);
            entityTypes.add(EntityTypes.TimeSpan);
        }
        return entityTypes;
    }

    private boolean isEmptyOrAll(List<EntityTypes> entityTypes) {
        return entityTypes == null || entityTypes.isEmpty() || entityTypes.contains(EntityTypes.All);
    }

    @Override
    public <T extends Entity> ResultsPage<T> buildResultsPage(Query searchQuery, ResultSet<T> results, String reqParams) {
        boolean isLastPage;
        ResultsPageImpl resPage = new ResultsPageImpl();
        resPage.setItems(results.getResults());
        resPage.setFacetFields(results.getFacetFields());
        resPage.setTotalInPage((long)results.getResults().size());
        resPage.setTotalInCollection(results.getResultSize());
        StringBuffer requestUrl = new StringBuffer(this.entityWebConfig.getEntityApiEndpoint() + "/search");
        String collectionUrl = this.buildCollectionUrl(searchQuery, requestUrl, reqParams);
        resPage.setCollectionUri(collectionUrl);
        int currentPage = searchQuery.getPageNr();
        String currentPageUrl = this.buildPageUrl(collectionUrl, currentPage, searchQuery.getPageSize());
        resPage.setCurrentPageUri(currentPageUrl);
        if (currentPage > 0) {
            String prevPage = this.buildPageUrl(collectionUrl, currentPage - 1, searchQuery.getPageSize());
            resPage.setPrevPageUri(prevPage);
        }
        boolean bl = isLastPage = resPage.getTotalInCollection() <= (long)((currentPage + 1) * searchQuery.getPageSize());
        if (!isLastPage) {
            String nextPage = this.buildPageUrl(collectionUrl, currentPage + 1, searchQuery.getPageSize());
            resPage.setNextPageUri(nextPage);
        }
        return resPage;
    }

    private String buildPageUrl(String collectionUrl, int page, int pageSize) {
        StringBuilder builder = new StringBuilder(collectionUrl);
        builder.append("&").append("page").append("=").append(page);
        builder.append("&").append("pageSize").append("=").append(pageSize);
        return builder.toString();
    }

    private String buildCollectionUrl(Query searchQuery, StringBuffer requestUrl, String queryString) {
        queryString = this.removeParam("page", (String)queryString);
        queryString = this.removeParam("pageSize", (String)queryString);
        queryString = this.removeParam("profile", (String)queryString);
        if (StringUtils.isNotBlank((CharSequence)searchQuery.getSearchProfile())) {
            queryString = (String)queryString + "&profile=" + searchQuery.getSearchProfile();
        }
        return requestUrl.append("?").append((String)queryString).toString();
    }

    protected String removeParam(String queryParam, String queryParams) {
        Object tmp;
        int startPos = queryParams.indexOf(queryParam + "=");
        int startEndPos = queryParams.indexOf("&", startPos + 1);
        if (startPos >= 0) {
            if (startPos > 0) {
                --startPos;
            }
            tmp = queryParams.substring(0, startPos);
            if (startEndPos > 0) {
                tmp = (String)tmp + queryParams.substring(startEndPos);
            }
        } else {
            tmp = queryParams;
        }
        return tmp;
    }

    @Override
    public List<String> searchEntityIds(Query searchQuery, String scope, List<EntityTypes> entityTypes) throws HttpException {
        ArrayList<String> matchingEntityIds = new ArrayList<String>();
        ResultSet<? extends Entity> results = this.search(searchQuery, null, entityTypes, scope);
        for (Entity searchRes : results.getResults()) {
            matchingEntityIds.add(searchRes.getEntityId());
        }
        return matchingEntityIds;
    }

    @Override
    public List<EntityTypes> getEntityTypesFromString(String commaSepEntityTypes) throws UnsupportedEntityTypeException {
        if (StringUtils.isBlank((CharSequence)commaSepEntityTypes)) {
            return null;
        }
        String[] splittedEntityTypes = commaSepEntityTypes.split(",");
        ArrayList<EntityTypes> entityTypes = new ArrayList<EntityTypes>();
        EntityTypes entityType = null;
        String typeAsString = null;
        for (int i = 0; i < splittedEntityTypes.length; ++i) {
            typeAsString = splittedEntityTypes[i].trim();
            entityType = EntityTypes.getByInternalType((String)typeAsString);
            entityTypes.add(entityType);
        }
        return entityTypes;
    }
}

