/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.web.jsonld;

import eu.europeana.api.commons.definitions.search.ResultSet;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.entity.definitions.exceptions.UnsupportedEntityTypeException;
import eu.europeana.entity.definitions.model.ResourcePreview;
import eu.europeana.entity.definitions.model.vocabulary.EntityTypes;
import eu.europeana.entity.utils.EntityUtils;
import eu.europeana.entity.utils.jsonld.EntityJsonComparator;
import eu.europeana.entity.web.model.view.AgentPreview;
import eu.europeana.entity.web.model.view.EntityPreview;
import eu.europeana.entity.web.model.view.OrganizationPreview;
import eu.europeana.entity.web.model.view.PlacePreview;
import eu.europeana.entity.web.model.view.TimeSpanPreview;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.stanbol.commons.jsonld.JsonLd;
import org.apache.stanbol.commons.jsonld.JsonLdProperty;
import org.apache.stanbol.commons.jsonld.JsonLdPropertyValue;
import org.apache.stanbol.commons.jsonld.JsonLdResource;
import org.springframework.http.HttpStatus;

public class SuggestionSetSerializer
extends JsonLd {
    ResultSet<? extends EntityPreview> entitySet;
    String entityIdBaseUrl;

    public SuggestionSetSerializer() {
        this.setPropOrderComparator((Comparator)new EntityJsonComparator());
    }

    public ResultSet<? extends EntityPreview> getEntitySet() {
        return this.entitySet;
    }

    public void setConceptSet(ResultSet<? extends EntityPreview> entitySet) {
        this.entitySet = entitySet;
    }

    public SuggestionSetSerializer(ResultSet<? extends EntityPreview> entitySet, String entityIdBaseUrl) {
        this.entityIdBaseUrl = entityIdBaseUrl;
        this.setPropOrderComparator((Comparator)new EntityJsonComparator());
        this.registerContainerProperty("isPartOf");
        this.registerContainerProperty("items");
        this.setConceptSet(entitySet);
    }

    public String serialize() throws HttpException {
        this.setUseTypeCoercion(false);
        this.setUseCuries(true);
        this.setUsedNamespaces(this.namespacePrefixMap);
        JsonLdResource jsonLdResource = new JsonLdResource();
        jsonLdResource.setSubject("");
        JsonLdProperty contextProperty = new JsonLdProperty("@context");
        contextProperty.getValues().add(new JsonLdPropertyValue((Object)"https://www.w3.org/ns/ldp.jsonld"));
        contextProperty.getValues().add(new JsonLdPropertyValue((Object)"http://www.europeana.eu/schemas/context/entity.jsonld"));
        jsonLdResource.putProperty(contextProperty);
        jsonLdResource.putProperty("type", (Object)"ResultPage");
        jsonLdResource.putProperty("total", (Object)this.getEntitySet().getResultSize());
        this.serializeItems(jsonLdResource);
        this.put(jsonLdResource);
        return this.toString(4);
    }

    protected void serializeItems(JsonLdResource jsonLdResource) throws HttpException {
        if (this.getEntitySet().isEmpty()) {
            return;
        }
        JsonLdProperty containsProperty = new JsonLdProperty("items");
        for (EntityPreview entityPreview : this.getEntitySet().getResults()) {
            JsonLdPropertyValue propertyValue = this.buildEntityPreviewPropertyValue(entityPreview);
            containsProperty.addValue(propertyValue);
        }
        jsonLdResource.putProperty(containsProperty);
    }

    private JsonLdProperty createIsShownByResource(EntityPreview entity, String field) {
        JsonLdProperty isShownByProperty = new JsonLdProperty(field);
        JsonLdPropertyValue isShownByValue = new JsonLdPropertyValue();
        if (!StringUtils.isEmpty((CharSequence)entity.getIsShownById())) {
            isShownByValue.putProperty(new JsonLdProperty("id", (Object)entity.getIsShownById()));
            isShownByValue.putProperty(new JsonLdProperty("type", (Object)"WebResource"));
        }
        if (!StringUtils.isEmpty((CharSequence)entity.getIsShownBySource())) {
            isShownByValue.putProperty(new JsonLdProperty("source", (Object)entity.getIsShownBySource()));
        }
        if (!StringUtils.isEmpty((CharSequence)entity.getIsShownByThumbnail())) {
            isShownByValue.putProperty(new JsonLdProperty("thumbnail", (Object)entity.getIsShownByThumbnail()));
        }
        isShownByProperty.addValue(isShownByValue);
        return isShownByProperty;
    }

    private JsonLdPropertyValue buildEntityPreviewPropertyValue(EntityPreview entityPreview) throws HttpException {
        JsonLdPropertyValue entityPreviewPropValue = new JsonLdPropertyValue();
        String entityIdAdjusted = EntityUtils.replaceBaseUrlInId((String)entityPreview.getEntityId(), (String)this.entityIdBaseUrl);
        entityPreviewPropValue.putProperty(new JsonLdProperty("id", (Object)entityIdAdjusted));
        JsonLdProperty prefLabelProp = this.buildMapOfStringsProperty("prefLabel", entityPreview.getPreferredLabel(), "");
        if (prefLabelProp != null) {
            entityPreviewPropValue.putProperty(prefLabelProp);
        }
        if (entityPreview.getAltLabel() != null && !entityPreview.getAltLabel().isEmpty()) {
            JsonLdProperty altLabelProp = this.buildMapProperty("altLabel", entityPreview.getAltLabel(), "");
            entityPreviewPropValue.putProperty(altLabelProp);
        }
        if (entityPreview.getHiddenLabel() != null && !entityPreview.getHiddenLabel().isEmpty()) {
            JsonLdProperty hiddenLabelProp = this.buildMapProperty("hiddenLabel", entityPreview.getHiddenLabel(), "");
            entityPreviewPropValue.putProperty(hiddenLabelProp);
        }
        if (entityPreview.getDepiction() != null) {
            entityPreviewPropValue.putProperty(new JsonLdProperty("depiction", (Object)entityPreview.getDepiction()));
        }
        if (!StringUtils.isEmpty((CharSequence)entityPreview.getIsShownById())) {
            entityPreviewPropValue.putProperty(this.createIsShownByResource(entityPreview, "isShownBy"));
        }
        String type = entityPreview.getType();
        EntityTypes entityType = null;
        try {
            entityType = EntityTypes.getByInternalType((String)type);
        }
        catch (UnsupportedEntityTypeException e) {
            throw new HttpException(null, "error.entity_unsupported_type", new String[]{"entity", type}, HttpStatus.NOT_FOUND, null);
        }
        if (entityType != null) {
            entityPreviewPropValue.putProperty(new JsonLdProperty("type", (Object)entityType.getInternalType()));
            switch (entityType) {
                case Organization: {
                    this.putOrganizationSpecificProperties((OrganizationPreview)entityPreview, entityPreviewPropValue);
                    break;
                }
                case Concept: {
                    break;
                }
                case Agent: {
                    this.putAgentSpecificProperties((AgentPreview)entityPreview, entityPreviewPropValue);
                    break;
                }
                case Place: {
                    this.putPlaceSpecificProperties((PlacePreview)entityPreview, entityPreviewPropValue);
                    break;
                }
                case TimeSpan: {
                    this.putTimeSpanSpecificProperties((TimeSpanPreview)entityPreview, entityPreviewPropValue);
                    break;
                }
            }
        }
        return entityPreviewPropValue;
    }

    private void putTimeSpanSpecificProperties(TimeSpanPreview entityPreview, JsonLdPropertyValue entityPreviewPropValue) {
        if (entityPreview.getBegin() != null) {
            entityPreviewPropValue.putProperty(new JsonLdProperty("begin", (Object)entityPreview.getBegin()));
        }
        if (entityPreview.getEnd() != null) {
            entityPreviewPropValue.putProperty(new JsonLdProperty("end", (Object)entityPreview.getEnd()));
        }
    }

    private void putPlaceSpecificProperties(PlacePreview entityPreview, JsonLdPropertyValue entityPreviewPropValue) {
        List partOfList = entityPreview.getIsPartOf();
        if (partOfList != null && !partOfList.isEmpty()) {
            JsonLdProperty isPartOfProp = new JsonLdProperty("isPartOf");
            for (ResourcePreview resourcePreview : partOfList) {
                JsonLdPropertyValue propValue = new JsonLdPropertyValue();
                propValue.getValues().put("id", resourcePreview.getHttpUri());
                JsonLdProperty prefLabelProp = this.buildMapOfStringsProperty("prefLabel", resourcePreview.getPrefLabel(), "");
                propValue.getPropertyMap().put("prefLabel", prefLabelProp);
                isPartOfProp.addValue(propValue);
            }
            entityPreviewPropValue.putProperty(isPartOfProp);
        }
    }

    private void putAgentSpecificProperties(AgentPreview entityPreview, JsonLdPropertyValue entityPreviewPropValue) {
        if (entityPreview.getDateOfBirth() != null) {
            entityPreviewPropValue.putProperty(new JsonLdProperty("dateOfBirth", (Object)entityPreview.getDateOfBirth()));
        }
        if (entityPreview.getDateOfDeath() != null) {
            entityPreviewPropValue.putProperty(new JsonLdProperty("dateOfDeath", (Object)entityPreview.getDateOfDeath()));
        }
        if (entityPreview.getProfessionOrOccuation() != null && !entityPreview.getProfessionOrOccuation().isEmpty()) {
            entityPreviewPropValue.putProperty(this.buildMapProperty("professionOrOccupation", entityPreview.getProfessionOrOccuation(), ""));
        }
    }

    private void putOrganizationSpecificProperties(OrganizationPreview entityPreview, JsonLdPropertyValue entityPreviewPropValue) {
        if (entityPreview.getAcronym() != null && !entityPreview.getAcronym().isEmpty()) {
            entityPreviewPropValue.putProperty(this.buildMapProperty("acronym", entityPreview.getAcronym(), null));
        }
        if (entityPreview.getCountry() != null) {
            entityPreviewPropValue.putProperty(new JsonLdProperty("country", (Object)entityPreview.getCountry()));
        }
        if (entityPreview.getOrganizationDomain() != null) {
            entityPreviewPropValue.putProperty(new JsonLdProperty("organizationDomain", (Object)entityPreview.getOrganizationDomain()));
        }
    }
}

