/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.web.jsonld;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.europeana.entity.web.controller.exception.EntityApiRuntimeException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.springframework.stereotype.Component;

@Component(value="entityJsonLdSerialiser")
public class JsonLdSerializer {
    ObjectMapper mapper = new ObjectMapper();
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public JsonLdSerializer() {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT, Locale.ENGLISH);
        this.mapper.setDateFormat((DateFormat)df);
    }

    public String serializeToJson(Object object) throws EntityApiRuntimeException {
        try {
            return this.mapper.writer().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new EntityApiRuntimeException("Unexpected exception occurred when serializing!", e);
        }
    }
}

