/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.web.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import eu.europeana.api.commons.definitions.search.result.ResultsPage;
import eu.europeana.api.commons.definitions.statistics.entity.EntityMetric;
import eu.europeana.api.commons.definitions.vocabulary.ContextTypes;
import eu.europeana.api.commons.service.authorization.AuthorizationService;
import eu.europeana.api.commons.web.controller.BaseRestController;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.entity.definitions.exceptions.InvalidProfileException;
import eu.europeana.entity.definitions.exceptions.UnsupportedEntityTypeException;
import eu.europeana.entity.definitions.exceptions.UnsupportedFormatTypeException;
import eu.europeana.entity.definitions.formats.FormatTypes;
import eu.europeana.entity.definitions.model.Entity;
import eu.europeana.entity.definitions.model.search.SearchProfiles;
import eu.europeana.entity.definitions.model.vocabulary.LdProfiles;
import eu.europeana.entity.definitions.model.vocabulary.SuggestAlgorithmTypes;
import eu.europeana.entity.stats.service.UsageStatsService;
import eu.europeana.entity.utils.jsonld.EuropeanaEntityLd;
import eu.europeana.entity.web.config.BuildInfo;
import eu.europeana.entity.web.config.EntityWebConfig;
import eu.europeana.entity.web.controller.exception.EntityApiRuntimeException;
import eu.europeana.entity.web.exception.ParamValidationException;
import eu.europeana.entity.web.jsonld.EntityResultsPageSerializer;
import eu.europeana.entity.web.jsonld.EntitySchemaOrgSerializer;
import eu.europeana.entity.web.jsonld.JsonLdSerializer;
import eu.europeana.entity.web.service.EntityAuthorizationService;
import eu.europeana.entity.web.service.EntityService;
import eu.europeana.entity.web.xml.EntityXmlSerializer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;

public abstract class BaseRest
extends BaseRestController {
    @Resource(name="entityAuthorizationService")
    EntityAuthorizationService entityAuthorizationService;
    @Resource(name="entityService")
    private EntityService entityService;
    @Resource(name="entityWebConfig")
    EntityWebConfig webConfig;
    @Resource(name="entityBuildInfo")
    BuildInfo buildInfo;
    @Resource(name="entityXmlSerializer")
    EntityXmlSerializer entityXmlSerializer;
    @Resource(name="entityJsonLdSerialiser")
    JsonLdSerializer jsonLdSerializer;
    @Resource(name="usageConfig")
    private UsageStatsService usageStatsService;
    Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private static final Set ISO_LANGUAGES = Set.of(Locale.getISOLanguages());
    Pattern pattern = null;

    public BaseRest() {
        String regexPattern = "\\p{Punct}";
        this.pattern = Pattern.compile(regexPattern);
    }

    protected EntityService getEntityService() {
        return this.entityService;
    }

    public void setEntityService(EntityService entityService) {
        this.entityService = entityService;
    }

    public void setUsageStatsService(UsageStatsService usageStatsService) {
        this.usageStatsService = usageStatsService;
    }

    public UsageStatsService getUsageStatsService() {
        return this.usageStatsService;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getApiVersion() {
        return this.buildInfo.getAppVersion();
    }

    protected EntityWebConfig getConfig() {
        return this.webConfig;
    }

    protected String serializeMetricView(EntityMetric metricData) throws EntityApiRuntimeException {
        return this.jsonLdSerializer.serializeToJson(metricData);
    }

    protected String validateScopeParam(String scope) throws ParamValidationException {
        if (StringUtils.isBlank((CharSequence)scope)) {
            return null;
        }
        if (!"europeana".equalsIgnoreCase(scope)) {
            throw new ParamValidationException("error.invalid_param_value", "scope", scope);
        }
        return "europeana";
    }

    protected FormatTypes getFormatType(String extension) throws ParamValidationException {
        if (extension == null) {
            return FormatTypes.jsonld;
        }
        try {
            return FormatTypes.getByExtention((String)extension);
        }
        catch (UnsupportedFormatTypeException e) {
            throw new ParamValidationException("error.invalid_param_value", "format", extension, HttpStatus.NOT_FOUND, null);
        }
    }

    protected String preProcessQuery(String text) throws ParamValidationException {
        if (text == null) {
            return null;
        }
        String query = this.removeSolrFieldNames(text);
        if (query.contains(" AND ")) {
            query = query.replaceAll(" AND ", " ");
        }
        if (query.contains(" OR ")) {
            query = query.replaceAll(" OR ", " ");
        }
        query = this.removePunctuations(query);
        return query;
    }

    public String removePunctuations(String query) {
        Matcher matcher = this.pattern.matcher(query);
        if (matcher.find()) {
            query = matcher.replaceAll(" ");
        }
        return query;
    }

    public String escapeQuotesAndBackslash(String text) {
        if (text.contains("\\")) {
            text = StringUtils.replace((String)text, (String)"\\", (String)"\\\\");
        }
        if (text.contains("\"")) {
            text = StringUtils.replace((String)text, (String)"\"", (String)"\\\"");
        }
        return text;
    }

    private String removeSolrFieldNames(String text) {
        if (!text.contains(":")) {
            return text;
        }
        String query = text;
        while (query.contains(":")) {
            String solrField = this.extractSolrFieldName(query);
            query = StringUtils.replaceOnce((String)query, (String)solrField, (String)" ");
        }
        return query;
    }

    protected String extractSolrFieldName(String query) {
        int end = query.indexOf(":");
        String fieldName = query.substring(0, end + 1);
        int start_space = StringUtils.lastIndexOf((CharSequence)fieldName, (CharSequence)" ");
        int start_bracket = StringUtils.lastIndexOf((CharSequence)fieldName, (CharSequence)"(");
        int start = Math.max(start_space, start_bracket);
        start = Math.max(0, start);
        fieldName = fieldName.substring(start);
        return fieldName;
    }

    protected void validateLanguage(String language) throws ParamValidationException {
        if (StringUtils.isEmpty((CharSequence)language)) {
            return;
        }
        if (StringUtils.contains((CharSequence)language, (CharSequence)",")) {
            throw new ParamValidationException("error.multiple_lang_value", "lang", language);
        }
        if (!StringUtils.equals((CharSequence)language, (CharSequence)"all") && !ISO_LANGUAGES.contains(language)) {
            throw new ParamValidationException("error.invalid_param_value", "lang", language);
        }
    }

    protected SuggestAlgorithmTypes validateAlgorithmParam(String algorithm) throws ParamValidationException {
        try {
            return SuggestAlgorithmTypes.getByName((String)algorithm);
        }
        catch (Exception e) {
            throw new ParamValidationException("error.invalid_param_value", "algorithm", algorithm);
        }
    }

    public LdProfiles getProfile(String paramProfile, HttpServletRequest request) throws HttpException {
        LdProfiles profile = null;
        String preferHeader = request.getHeader("Prefer");
        if (preferHeader != null) {
            profile = this.getProfile(preferHeader);
            this.getLogger().debug("Profile identified by prefer header: " + profile.name());
        } else {
            if (paramProfile == null) {
                return LdProfiles.MINIMAL;
            }
            try {
                profile = LdProfiles.getByName((String)paramProfile);
            }
            catch (InvalidProfileException e) {
                throw new ParamValidationException("error.invalid_param_value", "error.invalid_param_value", new String[]{"profile", paramProfile}, HttpStatus.BAD_REQUEST, (Throwable)e);
            }
        }
        return profile;
    }

    protected String serializeResultsPage(ResultsPage<? extends Entity> resPage, SearchProfiles profile, String entityIdBaseUrl) throws JsonProcessingException {
        EntityResultsPageSerializer<? extends Entity> serializer = new EntityResultsPageSerializer<Entity>(resPage, ContextTypes.ENTITY.getJsonValue(), "ResultPage", entityIdBaseUrl);
        String profileVal = profile == null ? null : profile.name();
        return serializer.serialize(profileVal);
    }

    LdProfiles getProfile(String preferHeader) throws HttpException {
        LdProfiles ldProfile = null;
        String ldPreferHeaderStr = null;
        String INCLUDE = "include";
        if (StringUtils.isNotEmpty((CharSequence)preferHeader)) {
            this.getLogger().debug("'Prefer' header value: " + preferHeader);
            try {
                Map<String, String> preferHeaderMap = this.parsePreferHeader(preferHeader);
                ldPreferHeaderStr = preferHeaderMap.get(INCLUDE).replace("\"", "");
                ldProfile = LdProfiles.getByHeaderValue((String)ldPreferHeaderStr.trim());
            }
            catch (InvalidProfileException e) {
                throw new HttpException("error.entity_invalid_header_value", "error.entity_invalid_header_value", new String[]{"Prefer", preferHeader}, HttpStatus.BAD_REQUEST, null);
            }
            catch (Throwable th) {
                throw new HttpException("error.entity_invalid_header_format", "error.entity_invalid_header_format", new String[]{"Prefer", preferHeader}, HttpStatus.BAD_REQUEST, null);
            }
        }
        return ldProfile;
    }

    public Map<String, String> parsePreferHeader(String preferHeader) {
        String[] headerParts = null;
        String[] contentParts = null;
        int KEY_POS = 0;
        int VALUE_POS = 1;
        HashMap<String, String> resMap = new HashMap<String, String>();
        for (String headerPart : headerParts = preferHeader.split(";")) {
            contentParts = headerPart.split("=");
            resMap.put(contentParts[KEY_POS], contentParts[VALUE_POS]);
        }
        return resMap;
    }

    protected String serialize(Entity entity, FormatTypes format) throws UnsupportedEntityTypeException, HttpException {
        String responseBody = null;
        if (FormatTypes.jsonld.equals((Object)format)) {
            EuropeanaEntityLd entityLd = new EuropeanaEntityLd(entity, this.webConfig.getEntityDataEndpoint());
            return entityLd.toString(4);
        }
        if (FormatTypes.schema.equals((Object)format)) {
            responseBody = new EntitySchemaOrgSerializer().serializeEntity(entity);
        } else if (FormatTypes.xml.equals((Object)format)) {
            responseBody = this.entityXmlSerializer.serializeXml(entity, this.webConfig.getEntityDataEndpoint());
        }
        return responseBody;
    }

    protected AuthorizationService getAuthorizationService() {
        return this.entityAuthorizationService;
    }
}

