/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.web.config;

import eu.europeana.entity.app.SocksProxyConfig;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class EntitySocksProxyActivator {
    private static final Logger LOG = LogManager.getLogger(EntitySocksProxyActivator.class);

    private EntitySocksProxyActivator() {
    }

    public static boolean activate(SocksProxyConfig config) {
        if (!EntitySocksProxyActivator.isValidConfiguration(config)) {
            return false;
        }
        System.setProperty("socksProxyHost", config.getHost());
        System.setProperty("socksProxyPort", config.getPort());
        String user = config.getUser();
        if (StringUtils.isNotBlank((CharSequence)user)) {
            String pass = config.getPassword();
            System.setProperty("java.net.socks.username", user);
            System.setProperty("java.net.socks.password", pass);
            Authenticator.setDefault(new SockProxyAuthenticator(user, pass));
        }
        return true;
    }

    private static boolean isValidConfiguration(SocksProxyConfig config) {
        boolean result = false;
        if (!config.isSocksEnabled()) {
            LOG.info("Socks proxy disabled");
        } else if (StringUtils.isEmpty((CharSequence)config.getHost())) {
            LOG.info("No socks proxy configured");
        } else {
            LOG.info("Setting up socks proxy at {}", (Object)config.getHost());
            result = true;
        }
        return result;
    }

    private static class SockProxyAuthenticator
    extends Authenticator {
        private final String user;
        private final char[] password;

        SockProxyAuthenticator(String user, String password) {
            this.user = user;
            this.password = password.toCharArray();
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password);
        }
    }
}

