/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.web.config;

import eu.europeana.api.commons.config.i18n.I18nService;
import eu.europeana.api.commons.config.i18n.I18nServiceImpl;
import eu.europeana.api.commons.oauth2.service.impl.EuropeanaClientDetailsService;
import eu.europeana.entity.config.AppConfigConstants;
import eu.europeana.entity.web.config.EntityWebConfig;
import javax.annotation.Resource;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

@Configuration
public class EntityAppConfig
extends AppConfigConstants {
    @Resource(name="entityWebConfig")
    private EntityWebConfig entityWebConfig;

    @Bean(name={"entityClientDetailsService"})
    public EuropeanaClientDetailsService getClientDetailsService() {
        EuropeanaClientDetailsService clientDetailsService = new EuropeanaClientDetailsService();
        clientDetailsService.setApiKeyServiceUrl(this.entityWebConfig.getApiKeyServiceUrl());
        return clientDetailsService;
    }

    @Bean(name={"i18nService"})
    public I18nService getI18nService() {
        I18nServiceImpl i18Service = new I18nServiceImpl();
        MessageSource source = this.getMessageSource();
        i18Service.setMessageSource(source);
        return i18Service;
    }

    @Bean(name={"messageSource"})
    public MessageSource getMessageSource() {
        ReloadableResourceBundleMessageSource source = new ReloadableResourceBundleMessageSource();
        source.setBasename("classpath:messages");
        source.setDefaultEncoding("utf-8");
        return source;
    }
}

