/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.web.xml.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import eu.europeana.entity.definitions.model.Entity;
import eu.europeana.entity.definitions.model.Place;
import eu.europeana.entity.web.xml.model.RdfResource;
import eu.europeana.entity.web.xml.model.RdfXmlUtils;
import eu.europeana.entity.web.xml.model.XmlBaseEntityImpl;
import eu.europeana.entity.web.xml.model.XmlMultilingualString;
import java.util.List;
import java.util.Map;

@JacksonXmlRootElement(localName="edm:Place")
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"foaf:depiction", "skos:prefLabel", "skos:altLabel", "skos:hiddenLabel", "wgs84_pos:lat", "wgs84_pos:long", "wgs84_pos:alt", "skos:note", "dcterms:hasPart", "dcterms:isPartOf", "edm:isNextInSequence", "owl:sameAs", "ore:isAggregatedBy"})
public class XmlPlaceImpl
extends XmlBaseEntityImpl {
    public XmlPlaceImpl(Place place) {
        super((Entity)place);
    }

    @JacksonXmlProperty(localName="wgs84_pos:lat")
    public Float getLatitude() {
        return this.getPlace().getLatitude();
    }

    @JacksonXmlProperty(localName="wgs84_pos:long")
    public Float getLongitude() {
        return this.getPlace().getLongitude();
    }

    @JacksonXmlProperty(localName="wgs84_pos:alt")
    public Float getAltitude() {
        return this.getPlace().getAltitude();
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="skos:hiddenLabel")
    public List<XmlMultilingualString> getHiddenLabel() {
        return RdfXmlUtils.convertToXmlMultilingualString((Map)this.getPlace().getHiddenLabel());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="skos:note")
    public List<XmlMultilingualString> getNote() {
        return RdfXmlUtils.convertToXmlMultilingualString((Map)this.getPlace().getNote());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="dcterms:hasPart")
    public List<RdfResource> getHasPart() {
        return RdfXmlUtils.convertToRdfResource((String[])this.getPlace().getHasPart());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="dcterms:isPartOf")
    public List<RdfResource> getIsPartOf() {
        return RdfXmlUtils.convertToRdfResource((String[])this.getPlace().getIsPartOf());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="edm:isNextInSequence")
    public List<RdfResource> getIsNextInSequence() {
        return RdfXmlUtils.convertToRdfResource((String[])this.getPlace().getIsNextInSequence());
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="owl:sameAs")
    public List<RdfResource> getSameAs() {
        return RdfXmlUtils.convertToRdfResource((String[])this.getPlace().getSameAs());
    }

    @JsonIgnore
    private Place getPlace() {
        return (Place)this.entity;
    }
}

