/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.web.controller;

import eu.europeana.api.common.config.swagger.SwaggerSelect;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api.commons.web.model.ErrorApiResponse;
import eu.europeana.entity.definitions.formats.FormatTypes;
import eu.europeana.entity.definitions.model.Entity;
import eu.europeana.entity.definitions.model.RankedEntity;
import eu.europeana.entity.utils.EntityUtils;
import eu.europeana.entity.web.config.EntityWebConfig;
import eu.europeana.entity.web.controller.BaseRest;
import eu.europeana.entity.web.exception.InternalServerException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@SwaggerSelect
@Api(tags={"Entity retrieval"}, description=" ")
public class ResolveController
extends BaseRest {
    @Resource(name="entityWebConfig")
    private EntityWebConfig entityWebConfig;
    private static final String ACCEPT = "Accept=";
    private static final String ACCEPT_HEADER_JSONLD = "Accept=application/ld+json";
    private static final String ACCEPT_HEADER_JSON = "Accept=application/json";
    private static final String ACCEPT_HEADER_APPLICATION_RDF_XML = "Accept=application/rdf+xml";
    private static final String ACCEPT_HEADER_RDF_XML = "Accept=rdf/xml";
    private static final String ACCEPT_HEADER_APPLICATION_XML = "Accept=application/xml";

    @ApiOperation(value="Retrieve a known entity", nickname="getEntity", response=Void.class)
    @RequestMapping(value={"/entity/{type}/{identifier}.jsonld", "/entity/{type}/base/{identifier}.jsonld", "/entity/{type}/{identifier}.json", "/entity/{type}/base/{identifier}.json"}, method={RequestMethod.GET}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<String> getJsonLdEntity(@RequestParam(value="wskey", required=false) String wskey, @PathVariable(value="type") String type, @PathVariable(value="identifier") String identifier, HttpServletRequest request) throws HttpException {
        return this.createResponse(type, identifier, FormatTypes.jsonld, null, request);
    }

    @ApiOperation(value="Retrieve a known entity", nickname="getEntity", response=Void.class)
    @RequestMapping(value={"/entity/{type}/{identifier}.schema.jsonld", "/entity/{type}/base/{identifier}.schema.jsonld"}, method={RequestMethod.GET}, produces={"application/ld+json", "application/json"})
    public ResponseEntity<String> getSchemaJsonLdEntity(@RequestParam(value="wskey", required=false) String wskey, @PathVariable(value="type") String type, @PathVariable(value="identifier") String identifier, HttpServletRequest request) throws HttpException {
        return this.createResponse(type, identifier, FormatTypes.schema, null, request);
    }

    @ApiOperation(value="Retrieve a known entity", nickname="getEntity", response=Void.class)
    @RequestMapping(value={"/entity/{type}/{identifier}.xml", "/entity/{type}/base/{identifier}.xml"}, method={RequestMethod.GET}, produces={"application/rdf+xml", "rdf/xml", "application/xml"})
    public ResponseEntity<String> getXmlEntity(@RequestParam(value="wskey", required=false) String wskey, @PathVariable(value="type") String type, @PathVariable(value="identifier") String identifier, HttpServletRequest request) throws HttpException {
        return this.createResponse(type, identifier, FormatTypes.xml, "application/rdf+xml", request);
    }

    @ApiOperation(value="Retrieve a known entity", nickname="getEntity", response=Void.class)
    @RequestMapping(value={"/entity/{type}/{identifier}", "/entity/{type}/base/{identifier}"}, method={RequestMethod.GET}, headers={"Accept=application/ld+json", "Accept=application/json"}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    public ResponseEntity<String> getEntity(@RequestParam(value="wskey", required=false) String wskey, @PathVariable(value="type") String type, @PathVariable(value="identifier") String identifier, HttpServletRequest request) throws HttpException {
        return this.createResponse(type, identifier, FormatTypes.jsonld, null, request);
    }

    @ApiOperation(value="Retrieve a known entity", nickname="getEntity", response=Void.class)
    @RequestMapping(value={"/entity/{type}/{identifier}", "/entity/{type}/base/{identifier}"}, method={RequestMethod.GET}, headers={"Accept=application/rdf+xml", "Accept=rdf/xml", "Accept=application/xml"}, produces={"application/rdf+xml", "rdf/xml", "application/xml"})
    public ResponseEntity<String> getXmlHeaderEntity(@RequestParam(value="wskey", required=false) String wskey, @PathVariable(value="type") String type, @PathVariable(value="identifier") String identifier, HttpServletRequest request) throws HttpException {
        return this.createResponse(type, identifier, FormatTypes.xml, null, request);
    }

    private ResponseEntity<String> createResponse(String type, String identifier, FormatTypes outFormat, String contentType, HttpServletRequest request) throws HttpException {
        try {
            this.verifyReadAccess(request);
            Entity entity = this.getEntityService().retrieveByUrl(type, identifier);
            String jsonLd = this.serialize(entity, outFormat);
            Date timestamp = ((RankedEntity)entity).getTimestamp();
            Date etagDate = timestamp != null ? timestamp : new Date();
            String etag = this.generateETag(etagDate, outFormat.name(), this.getApiVersion());
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"ETag", (Object)etag);
            headers.add((Object)"Allow", (Object)"GET");
            if (!outFormat.equals((Object)FormatTypes.schema)) {
                headers.add((Object)"Vary", (Object)"Accept");
                headers.add((Object)"Link", (Object)"<http://www.w3.org/ns/ldp#Resource>; rel=\"type\"");
            }
            if (contentType != null && !contentType.isEmpty()) {
                headers.add((Object)"Content-Type", (Object)contentType);
            }
            ResponseEntity response = new ResponseEntity((Object)jsonLd, (MultiValueMap)headers, HttpStatus.OK);
            return response;
        }
        catch (RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    @ApiOperation(value="Performs a lookup for the entity in all 4 datasets", nickname="resolveEntity", response=Void.class)
    @RequestMapping(value={"/entity/resolve"}, method={RequestMethod.GET}, produces={"application/ld+json;charset=utf-8", "application/json;charset=utf-8"})
    public ResponseEntity<String> resolveEntity(@RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="uri") String uri, HttpServletRequest request) throws HttpException {
        try {
            this.verifyReadAccess(request);
            LinkedMultiValueMap headers = new LinkedMultiValueMap(5);
            headers.add((Object)"Allow", (Object)"GET");
            String validatedUri = EntityUtils.convertToValidUri((String)uri);
            if (validatedUri == null) {
                ErrorApiResponse errorResponse = new ErrorApiResponse(wskey, request.getRequestURI(), "Invalid uri parameter.");
                String body = this.jsonLdSerializer.serializeToJson((Object)errorResponse);
                return new ResponseEntity((Object)body, (MultiValueMap)headers, HttpStatus.BAD_REQUEST);
            }
            List entityUris = this.getEntityService().resolveByUri(validatedUri);
            if (entityUris.isEmpty()) {
                ErrorApiResponse errorResponse = new ErrorApiResponse(wskey, request.getRequestURI(), "No entity found for sameAs/exactMatch URI : " + validatedUri);
                String body = this.jsonLdSerializer.serializeToJson((Object)errorResponse);
                return new ResponseEntity((Object)body, (MultiValueMap)headers, HttpStatus.NOT_FOUND);
            }
            String preferedEntity = EntityUtils.replaceBaseUrlInId((String)((String)entityUris.get(0)), (String)this.entityWebConfig.getEntityDataEndpoint());
            headers.add((Object)"Location", (Object)preferedEntity);
            if (entityUris.size() == 1) {
                return new ResponseEntity((MultiValueMap)headers, HttpStatus.MOVED_PERMANENTLY);
            }
            List updatedUris = EntityUtils.updateBaseUrlInIds((List)entityUris, (String)this.entityWebConfig.getEntityDataEndpoint());
            String body = this.jsonLdSerializer.serializeToJson((Object)updatedUris);
            return new ResponseEntity((Object)body, (MultiValueMap)headers, HttpStatus.MULTIPLE_CHOICES);
        }
        catch (RuntimeException e) {
            throw new InternalServerException((Throwable)e);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerException((Throwable)e);
        }
    }
}

