/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.web.config;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    List<MediaType> supportedMediaTypes = new ArrayList();
    Map<String, MediaType> mediaTypesMaping = new HashMap();

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/v2/api-docs").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET"}).exposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Headers"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/v2/api-docs/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET"}).exposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Headers"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/entity/resolve").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET"}).exposedHeaders(new String[]{"Location", "Allow", "Access-Control-Allow-Headers"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/entity/suggest").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET"}).exposedHeaders(new String[]{"Allow", "Access-Control-Allow-Headers"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/entity/search").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET"}).exposedHeaders(new String[]{"Allow", "Access-Control-Allow-Headers"}).allowCredentials(false).maxAge(600L);
        registry.addMapping("/entity/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET"}).allowedHeaders(new String[]{"If-Match"}).exposedHeaders(new String[]{"Allow", "Vary", "Link", "ETag", "Access-Control-Allow-Headers"}).allowCredentials(false).maxAge(600L);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorPathExtension(true);
        configurer.defaultContentType(new MediaType[]{MediaType.valueOf((String)"application/ld+json")});
        configurer.mediaTypes(this.getMediaTypesMapping());
    }

    private Map<String, MediaType> getMediaTypesMapping() {
        if (this.mediaTypesMaping.isEmpty()) {
            for (MediaType mediaType : this.supportedMediaTypes) {
                if ("rdf".equals(mediaType.getType())) {
                    this.mediaTypesMaping.put("rdf/xml", mediaType);
                    this.mediaTypesMaping.put("rdf", mediaType);
                    continue;
                }
                this.mediaTypesMaping.put(mediaType.getSubtype(), mediaType);
            }
        }
        return this.mediaTypesMaping;
    }

    @Bean
    public HttpMessageConverter<String> getStringHttpMessageConverter() {
        StringHttpMessageConverter stringConverter = new StringHttpMessageConverter(StandardCharsets.UTF_8);
        stringConverter.setWriteAcceptCharset(false);
        stringConverter.setSupportedMediaTypes(this.getSupportedMediaTypes());
        return stringConverter;
    }

    private List<MediaType> getSupportedMediaTypes() {
        if (this.supportedMediaTypes.isEmpty()) {
            this.supportedMediaTypes.add(new MediaType("application", "ld+json"));
            this.supportedMediaTypes.add(MediaType.APPLICATION_JSON);
            this.supportedMediaTypes.add(new MediaType("application", "rdf+xml"));
            this.supportedMediaTypes.add(new MediaType("rdf", "xml"));
            this.supportedMediaTypes.add(MediaType.APPLICATION_XML);
        }
        return this.supportedMediaTypes;
    }
}

