/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.utils.jsonld;

import eu.europeana.api.commons.definitions.utils.DateUtils;
import eu.europeana.entity.definitions.exceptions.UnsupportedEntityTypeException;
import eu.europeana.entity.definitions.model.Agent;
import eu.europeana.entity.definitions.model.Concept;
import eu.europeana.entity.definitions.model.Entity;
import eu.europeana.entity.definitions.model.Organization;
import eu.europeana.entity.definitions.model.Place;
import eu.europeana.entity.definitions.model.TimeSpan;
import eu.europeana.entity.definitions.model.impl.BaseEntity;
import eu.europeana.entity.definitions.model.vocabulary.EntityTypes;
import eu.europeana.entity.utils.EntityUtils;
import eu.europeana.entity.utils.jsonld.EntityJsonComparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.stanbol.commons.jsonld.JsonLd;
import org.apache.stanbol.commons.jsonld.JsonLdProperty;
import org.apache.stanbol.commons.jsonld.JsonLdPropertyValue;
import org.apache.stanbol.commons.jsonld.JsonLdResource;

public class EuropeanaEntityLd
extends JsonLd {
    JsonLdResource ldResource = new JsonLdResource();
    String entityIdBaseUrl;

    public EuropeanaEntityLd(Entity entity, String entityIdBaseUrl) throws UnsupportedEntityTypeException {
        this.entityIdBaseUrl = entityIdBaseUrl;
        this.setPropOrderComparator(new EntityJsonComparator());
        this.registerContainerProperty("biographicalInformation");
        this.registerContainerProperty("placeOfBirth");
        this.registerContainerProperty("placeOfDeath");
        this.setEntity(entity);
    }

    public JsonLdResource setEntity(Entity entity) throws UnsupportedEntityTypeException {
        this.setUseTypeCoercion(false);
        this.setUseCuries(true);
        this.setUsedNamespaces(this.namespacePrefixMap);
        this.ldResource.setSubject("");
        this.ldResource.putProperty("@context", (Object)"http://www.europeana.eu/schemas/context/entity.jsonld");
        this.ldResource.putProperty("id", (Object)EntityUtils.replaceBaseUrlInId(entity.getEntityId(), this.entityIdBaseUrl));
        this.ldResource.putProperty("type", (Object)entity.getType());
        this.putStringArrayProperty("identifier", entity.getIdentifier(), this.ldResource);
        this.putStringArrayProperty("sameAs", entity.getSameAs(), this.ldResource);
        this.putStringArrayProperty("isRelatedTo", entity.getIsRelatedTo(), this.ldResource);
        if (!StringUtils.isEmpty((CharSequence)entity.getDepiction())) {
            this.ldResource.putProperty(this.createWikimediaResource(entity.getDepiction(), "depiction"));
        }
        this.putMapOfStringProperty("prefLabel", ((BaseEntity)entity).getPrefLabel(), "", this.ldResource);
        this.putMapOfStringListProperty("altLabel", entity.getAltLabel(), "", this.ldResource);
        this.putMapOfStringListProperty("hiddenLabel", entity.getHiddenLabel(), "", this.ldResource);
        this.putMapOfStringListProperty("note", entity.getNote(), "", this.ldResource);
        this.putAggregationProperty(entity, this.ldResource);
        if (!StringUtils.isEmpty((CharSequence)((BaseEntity)entity).getIsShownById())) {
            this.ldResource.putProperty(this.createIsShownByResource((BaseEntity)entity, "isShownBy"));
        }
        this.putSpecificProperties(entity, this.ldResource);
        this.put(this.ldResource);
        return this.ldResource;
    }

    private JsonLdProperty createIsShownByResource(BaseEntity entity, String field) {
        JsonLdProperty isShownByProperty = new JsonLdProperty(field);
        JsonLdPropertyValue isShownByValue = new JsonLdPropertyValue();
        if (!StringUtils.isEmpty((CharSequence)entity.getIsShownById())) {
            isShownByValue.putProperty(new JsonLdProperty("id", (Object)entity.getIsShownById()));
            isShownByValue.putProperty(new JsonLdProperty("type", (Object)"WebResource"));
        }
        if (!StringUtils.isEmpty((CharSequence)entity.getIsShownBySource())) {
            isShownByValue.putProperty(new JsonLdProperty("source", (Object)entity.getIsShownBySource()));
        }
        if (!StringUtils.isEmpty((CharSequence)entity.getIsShownByThumbnail())) {
            isShownByValue.putProperty(new JsonLdProperty("thumbnail", (Object)entity.getIsShownByThumbnail()));
        }
        isShownByProperty.addValue(isShownByValue);
        return isShownByProperty;
    }

    private JsonLdProperty createWikimediaResource(String wikimediaCommonsId, String field) {
        JsonLdProperty depictionProperty = new JsonLdProperty(field);
        JsonLdPropertyValue depictionValue = new JsonLdPropertyValue();
        depictionValue.putProperty(new JsonLdProperty("id", (Object)wikimediaCommonsId));
        String sourceValue = EntityUtils.createWikimediaResourceString(wikimediaCommonsId);
        depictionValue.putProperty(new JsonLdProperty("source", (Object)sourceValue));
        depictionProperty.addValue(depictionValue);
        return depictionProperty;
    }

    private void putConceptSpecificProperties(Concept entity, JsonLdResource jsonLdResource) {
        this.putMapOfStringListProperty("notation", entity.getNotation(), "", jsonLdResource);
        this.putStringArrayProperty("related", entity.getRelated(), jsonLdResource);
        this.putStringArrayProperty("broader", entity.getBroader(), jsonLdResource);
        this.putStringArrayProperty("narrower", entity.getNarrower(), jsonLdResource);
        this.putStringArrayProperty("exactMatch", entity.getExactMatch(), jsonLdResource);
        this.putStringArrayProperty("closeMatch", entity.getCloseMatch(), jsonLdResource);
        this.putStringArrayProperty("broadMatch", entity.getBroadMatch(), jsonLdResource);
        this.putStringArrayProperty("narrowMatch", entity.getNarrowMatch(), jsonLdResource);
        this.putStringArrayProperty("relatedMatch", entity.getRelatedMatch(), jsonLdResource);
    }

    private void putSpecificProperties(Entity entity, JsonLdResource jsonLdResource) throws UnsupportedEntityTypeException {
        EntityTypes entityType = EntityTypes.getByInternalType((String)entity.getType());
        switch (entityType) {
            case Organization: {
                this.putOrganizationSpecificProperties((Organization)entity, jsonLdResource);
                break;
            }
            case Concept: {
                this.putConceptSpecificProperties((Concept)entity, jsonLdResource);
                break;
            }
            case Agent: {
                this.putAgentSpecificProperties((Agent)entity, jsonLdResource);
                break;
            }
            case Place: {
                this.putPlaceSpecificProperties((Place)entity, jsonLdResource);
                break;
            }
            case TimeSpan: {
                this.putTimeSpanSpecificProperties((TimeSpan)entity, jsonLdResource);
                break;
            }
        }
    }

    private void putTimeSpanSpecificProperties(TimeSpan entity, JsonLdResource jsonLdResource) {
        this.putBaseEntityProperties((BaseEntity)entity, jsonLdResource);
        this.putStringArrayProperty("isNextInSequence", entity.getIsNextInSequence(), jsonLdResource);
        this.putStringProperty("begin", entity.getBegin(), jsonLdResource);
        this.putStringProperty("end", entity.getEnd(), jsonLdResource);
    }

    private void putPlaceSpecificProperties(Place entity, JsonLdResource jsonLdResource) {
        this.putBaseEntityProperties((BaseEntity)entity, jsonLdResource);
        if (entity.getLatitude() != null) {
            this.putStringProperty("lat", "" + entity.getLatitude(), jsonLdResource);
        }
        if (entity.getLongitude() != null) {
            this.putStringProperty("long", "" + entity.getLongitude(), jsonLdResource);
        }
        if (entity.getAltitude() != null) {
            this.putStringProperty("alt", "" + entity.getAltitude(), jsonLdResource);
        }
        this.putStringArrayProperty("isNextInSequence", entity.getIsNextInSequence(), jsonLdResource);
    }

    private void putAgentSpecificProperties(Agent entity, JsonLdResource jsonLdResource) {
        this.putBaseEntityProperties((BaseEntity)entity, jsonLdResource);
        this.putMapOfStringProperty("name", entity.getName(), "", jsonLdResource);
        this.putMapOfReferencesProperty("biographicalInformation", entity.getBiographicalInformation(), "", jsonLdResource);
        this.putMapOfReferencesProperty("professionOrOccupation", entity.getProfessionOrOccupation(), "", jsonLdResource);
        this.putStringArrayProperty("dateOfDeath", entity.getDateOfDeath(), jsonLdResource);
        this.putStringArrayProperty("dateOfBirth", entity.getDateOfBirth(), jsonLdResource);
        if (!StringUtils.isEmpty((CharSequence)entity.getDateOfEstablishment())) {
            this.ldResource.putProperty("dateOfEstablishment", (Object)entity.getDateOfEstablishment());
        }
        if (!StringUtils.isEmpty((CharSequence)entity.getDateOfTermination())) {
            this.ldResource.putProperty("dateOfTermination", (Object)entity.getDateOfTermination());
        }
        this.putStringArrayProperty("begin", entity.getBegin(), jsonLdResource);
        this.putStringArrayProperty("end", entity.getEnd(), jsonLdResource);
        this.putMapOfReferencesProperty("placeOfBirth", entity.getPlaceOfBirth(), "", jsonLdResource);
        this.putMapOfReferencesProperty("placeOfDeath", entity.getPlaceOfDeath(), "", jsonLdResource);
    }

    private void putOrganizationSpecificProperties(Organization entity, JsonLdResource jsonLdResource) {
        this.putBaseEntityProperties((BaseEntity)entity, jsonLdResource);
        this.putMapOfStringProperty("description", entity.getDescription(), "", this.ldResource);
        this.putMapOfStringListProperty("acronym", entity.getAcronym(), "", this.ldResource);
        if (!StringUtils.isEmpty((CharSequence)entity.getLogo())) {
            this.ldResource.putProperty(this.createWikimediaResource(entity.getLogo(), "logo"));
        }
        if (!StringUtils.isEmpty((CharSequence)entity.getHomepage())) {
            this.ldResource.putProperty("homepage", (Object)entity.getHomepage());
        }
        if (entity.getPhone() != null) {
            this.putListProperty("phone", entity.getPhone(), jsonLdResource);
        }
        if (entity.getMbox() != null) {
            this.putListProperty("mbox", entity.getMbox(), jsonLdResource);
        }
        if (entity.getEuropeanaRole() != null) {
            List europeanaRole = (List)entity.getEuropeanaRole().get("en");
            this.putListProperty("europeanaRole", europeanaRole, this.ldResource);
        }
        if (entity.getOrganizationDomain() != null) {
            List europeanaDomain = (List)entity.getOrganizationDomain().get("en");
            this.putListProperty("organizationDomain", europeanaDomain, this.ldResource);
        }
        if (entity.getGeographicLevel() != null) {
            String geoLevel = (String)entity.getGeographicLevel().get("en");
            this.ldResource.putProperty("geographicLevel", (Object)geoLevel);
        }
        if (!StringUtils.isEmpty((CharSequence)entity.getCountry())) {
            this.ldResource.putProperty("country", (Object)entity.getCountry());
        }
        this.putAddressProperty(entity, this.ldResource);
    }

    private void putAddressProperty(Organization entity, JsonLdResource ldResource) {
        if (StringUtils.isEmpty((CharSequence)entity.getLocality()) && StringUtils.isEmpty((CharSequence)entity.getHasGeo())) {
            return;
        }
        JsonLdPropertyValue vcardAddress = new JsonLdPropertyValue();
        vcardAddress.putProperty(new JsonLdProperty("id", (Object)entity.getHasAddress()));
        vcardAddress.putProperty(new JsonLdProperty("type", (Object)"Address"));
        if (!StringUtils.isEmpty((CharSequence)entity.getStreetAddress())) {
            vcardAddress.putProperty(new JsonLdProperty("streetAddress", (Object)entity.getStreetAddress()));
        }
        if (!StringUtils.isEmpty((CharSequence)entity.getLocality())) {
            vcardAddress.putProperty(new JsonLdProperty("locality", (Object)entity.getLocality()));
        }
        if (!StringUtils.isEmpty((CharSequence)entity.getRegion())) {
            vcardAddress.putProperty(new JsonLdProperty("region", (Object)entity.getRegion()));
        }
        if (!StringUtils.isEmpty((CharSequence)entity.getPostalCode())) {
            vcardAddress.putProperty(new JsonLdProperty("postalCode", (Object)entity.getPostalCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)entity.getCountryName())) {
            vcardAddress.putProperty(new JsonLdProperty("countryName", (Object)entity.getCountryName()));
        }
        if (!StringUtils.isEmpty((CharSequence)entity.getPostBox())) {
            vcardAddress.putProperty(new JsonLdProperty("postOfficeBox", (Object)entity.getPostBox()));
        }
        if (!StringUtils.isEmpty((CharSequence)entity.getHasGeo())) {
            vcardAddress.putProperty(new JsonLdProperty("hasGeo", (Object)EntityUtils.toGeoUri(entity.getHasGeo())));
        }
        JsonLdProperty hasAddress = new JsonLdProperty("hasAddress");
        hasAddress.addValue(vcardAddress);
        ldResource.putProperty(hasAddress);
    }

    private void putAggregationProperty(Entity entity, JsonLdResource ldResource) {
        if (entity.getCreated() == null && entity.getModified() == null) {
            return;
        }
        JsonLdPropertyValue oreAggregation = new JsonLdPropertyValue();
        oreAggregation.putProperty(new JsonLdProperty("id", (Object)(entity.getEntityId() + "#" + "Aggregation".toLowerCase())));
        oreAggregation.putProperty(new JsonLdProperty("type", (Object)"Aggregation"));
        if (entity.getCreated() != null) {
            oreAggregation.putProperty(new JsonLdProperty("created", (Object)DateUtils.convertDateToStr((Date)entity.getCreated())));
        }
        if (entity.getModified() != null) {
            oreAggregation.putProperty(new JsonLdProperty("modified", (Object)DateUtils.convertDateToStr((Date)entity.getModified())));
        }
        oreAggregation.putProperty(new JsonLdProperty("aggregates", (Object)entity.getEntityId()));
        JsonLdProperty isAggregatedBy = new JsonLdProperty("isAggregatedBy");
        isAggregatedBy.addValue(oreAggregation);
        ldResource.putProperty(isAggregatedBy);
    }

    private void putBaseEntityProperties(BaseEntity entity, JsonLdResource jsonLdResource) {
        this.putStringArrayProperty("isPartOf", entity.getIsPartOf(), jsonLdResource);
        this.putStringArrayProperty("hasPart", entity.getHasPart(), jsonLdResource);
    }

    public JsonLdResource getLdResource() {
        return this.ldResource;
    }

    public boolean isContainerProperty(String property) {
        return !"isPartOf".equals(property) && super.isContainerProperty(property);
    }
}

