/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.utils.json;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class JsonUtils {
    private static final String SEPARATOR_CLOSE_CURLY = "}";
    private static final String SEPARATOR_OPEN_CURLY = "{";
    private static final String SEPARATOR_CLOSE_BRACKET = "]";
    private static final String SEPARATOR_OPEN_BRACKET = "[";
    private static final String SEPARATOR_QUOTE = "\"";
    private static final String SEPARATOR_SEMICOLON = ";";
    private static final String SEPARATOR_COLON = ":";

    @Deprecated
    public static String mapToString(Map<String, String> mp) {
        Object res = "";
        Iterator<Map.Entry<String, String>> it = mp.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> pairs = it.next();
            if (((String)res).length() > 0) {
                res = (String)res + ",";
            }
            res = (String)res + pairs.getKey() + SEPARATOR_SEMICOLON + pairs.getValue();
            it.remove();
        }
        if (((String)res).length() > 0) {
            res = SEPARATOR_OPEN_BRACKET + (String)res + SEPARATOR_CLOSE_BRACKET;
        }
        return res;
    }

    @Deprecated
    public static String mapToStringExt(Map<String, Integer> mp) {
        Object res = "";
        Iterator<Map.Entry<String, Integer>> it = mp.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Integer> pairs = it.next();
            if (((String)res).length() > 0) {
                res = (String)res + ",";
            }
            res = (String)res + pairs.getKey() + SEPARATOR_SEMICOLON + pairs.getValue();
            it.remove();
        }
        if (((String)res).length() > 0) {
            res = SEPARATOR_OPEN_BRACKET + (String)res + SEPARATOR_CLOSE_BRACKET;
        }
        return res;
    }

    public static String mapOfListsToString(Map<String, List<String>> map, String keyPrefix) {
        StringBuilder builder = new StringBuilder(SEPARATOR_OPEN_CURLY);
        int prefixLength = keyPrefix.length() + 1;
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String key = entry.getKey();
            if (keyPrefix != null) {
                key = key.substring(prefixLength);
            }
            builder.append(SEPARATOR_QUOTE).append(key).append(SEPARATOR_QUOTE).append(SEPARATOR_COLON);
            builder.append(JsonUtils.listToString(entry.getValue()));
        }
        builder.append(SEPARATOR_CLOSE_CURLY);
        return builder.toString();
    }

    private static String listToString(List<String> values) {
        if (values.size() == 1) {
            return SEPARATOR_QUOTE + values.get(0) + SEPARATOR_QUOTE;
        }
        StringBuilder builder = new StringBuilder(SEPARATOR_OPEN_BRACKET);
        for (String value : values) {
            builder.append(SEPARATOR_QUOTE).append(value).append(SEPARATOR_QUOTE);
            builder.append(SEPARATOR_SEMICOLON);
        }
        builder.deleteCharAt(builder.lastIndexOf(SEPARATOR_SEMICOLON));
        builder.append(SEPARATOR_CLOSE_BRACKET);
        return builder.toString();
    }

    public static String extractEntityListStringFromJsonString(String jsonString) {
        return JsonUtils.extractEntityListStringFromJsonString(jsonString, "\":(.*?)}}]");
    }

    public static String extractEntityListStringFromJsonString(String jsonString, String regex) {
        Pattern pattern;
        Matcher matcher;
        Object res = "";
        String ITEMS = "contains";
        if (StringUtils.isNotEmpty((CharSequence)jsonString) && (matcher = (pattern = Pattern.compile(ITEMS + regex)).matcher(jsonString)).find()) {
            res = matcher.group(1) + "}}]";
        }
        return res;
    }

    public static String[] splitEntityListStringToArray(String value) {
        return value.split("\\}\\},\\{");
    }
}

