/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.utils;

import eu.europeana.entity.utils.UriValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class EntityUtils {
    public static String createWikimediaResourceString(String wikimediaCommonsId) {
        assert (wikimediaCommonsId.contains("Special:FilePath/"));
        return wikimediaCommonsId.replace("Special:FilePath/", "File:");
    }

    public static String toGeoUri(String latLon) {
        return "geo:" + latLon;
    }

    public static String replaceBaseUrlInId(String id, String dataEndpoint) {
        if (dataEndpoint == null || id.startsWith(dataEndpoint)) {
            return id;
        }
        int slashCountForEndOfDomain = 3;
        int pathStartPos = StringUtils.ordinalIndexOf((CharSequence)id, (CharSequence)"/", (int)slashCountForEndOfDomain);
        if (dataEndpoint.endsWith("/")) {
            ++pathStartPos;
        }
        if (pathStartPos > 0) {
            return dataEndpoint + id.substring(pathStartPos);
        }
        return id;
    }

    public static List<String> updateBaseUrlInIds(List<String> entityUris, String dataEndPoint) {
        if (entityUris == null || entityUris.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> updatedUris = new ArrayList<String>(entityUris.size());
        for (String id : entityUris) {
            updatedUris.add(EntityUtils.replaceBaseUrlInId(id, dataEndPoint));
        }
        return updatedUris;
    }

    public static String convertToValidUri(String uri) {
        uri = uri.trim();
        uri = StringUtils.removeStart((String)uri, (String)"\"");
        uri = StringUtils.removeEnd((String)uri, (String)"\"");
        if (UriValidator.isUri(uri = EntityUtils.escapeQuotes(uri))) {
            return uri;
        }
        return null;
    }

    public static String escapeBackslashAndQuotes(String text, String backslash, String quotes) {
        text = EntityUtils.escapeBackslash(text);
        text = EntityUtils.escapeQuotes(text);
        return text;
    }

    public static String escapeBackslash(String text) {
        if (text.contains("\\")) {
            text = StringUtils.replace((String)text, (String)"\\", (String)"\\\\");
        }
        return text;
    }

    public static String escapeQuotes(String text) {
        if (text.contains("\"")) {
            text = StringUtils.replace((String)text, (String)"\"", (String)"\\\"");
        }
        return text;
    }

    public static String removeSolrFieldNames(String text) {
        if (!text.contains(":")) {
            return text;
        }
        String query = text;
        while (query.contains(":")) {
            String solrField = EntityUtils.extractSolrFieldName(query);
            query = StringUtils.replaceOnce((String)query, (String)solrField, (String)" ");
        }
        return query;
    }

    public static String extractSolrFieldName(String query) {
        int end = query.indexOf(":");
        String fieldName = query.substring(0, end + 1);
        int start_space = StringUtils.lastIndexOf((CharSequence)fieldName, (CharSequence)" ");
        int start_bracket = StringUtils.lastIndexOf((CharSequence)fieldName, (CharSequence)"(");
        int start = Math.max(start_space, start_bracket);
        start = Math.max(0, start);
        fieldName = fieldName.substring(start);
        return fieldName;
    }

    public static String removeSolrAndOr(String query) {
        if (query.contains(" AND ")) {
            query = query.replaceAll(" AND ", " ");
        }
        if (query.contains(" OR ")) {
            query = query.replaceAll(" OR ", " ");
        }
        return query;
    }

    public static String removePunctuations(String query, Pattern pattern) {
        Matcher matcher = pattern.matcher(query);
        if (matcher.find()) {
            query = matcher.replaceAll(" ");
        }
        return query;
    }
}

