/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest.exception;

import eu.europeana.enrichment.api.exceptions.UnknownException;
import eu.europeana.enrichment.api.external.web.EnrichmentError;
import java.io.IOException;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;

public class GenericExceptionMapper {
    private static Logger log = Logger.getLogger(GenericExceptionMapper.class.getName());

    public Response toResponse(JsonGenerationException exception) {
        return this.generateResponse((Exception)exception, exception.getClass().getSimpleName() + ": " + exception.getMessage());
    }

    public Response toResponse(JsonMappingException exception) {
        return this.generateResponse((Exception)((Object)exception), ((Object)((Object)exception)).getClass().getSimpleName() + ": " + exception.getMessage());
    }

    public Response toResponse(IOException exception) {
        return this.generateResponse((Exception)exception, exception.getClass().getSimpleName() + ": " + exception.getMessage());
    }

    public Response toResponse(UnknownException exception) {
        return this.generateResponse((Exception)exception, exception.getClass().getSimpleName() + ": " + exception.getMessage());
    }

    private Response generateResponse(Exception e, String txt) {
        log.severe(e.getMessage());
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new EnrichmentError(e.getClass().getName(), txt)).build();
    }
}

