/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.rest;

import eu.europeana.corelib.solr.entity.AgentImpl;
import eu.europeana.corelib.solr.entity.ConceptImpl;
import eu.europeana.corelib.solr.entity.PlaceImpl;
import eu.europeana.corelib.solr.entity.TimespanImpl;
import eu.europeana.enrichment.api.external.EntityWrapper;
import eu.europeana.enrichment.api.external.EntityWrapperList;
import eu.europeana.enrichment.api.external.InputValueList;
import eu.europeana.enrichment.api.external.ObjectIdSerializer;
import eu.europeana.enrichment.api.external.UriList;
import eu.europeana.enrichment.service.Enricher;
import eu.europeana.enrichment.service.EntityRemover;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringEscapeUtils;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.module.SimpleModule;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Path(value="/")
@Component
@Scope(value="request")
@Api(value="/")
public class EnrichmentResource {
    Logger log = Logger.getLogger(this.getClass().getName());
    private static Enricher enricher = new Enricher("");

    @POST
    @Path(value="delete")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/xml", "application/json"})
    public Response delete(@FormParam(value="urls") String input) throws JsonParseException, JsonMappingException, IOException, Exception {
        ObjectMapper mapper = new ObjectMapper();
        UriList values = (UriList)mapper.readValue(input, UriList.class);
        EntityRemover remover = new EntityRemover(enricher.getEnricher());
        remover.remove(values.getUris(), null);
        return Response.ok().build();
    }

    @POST
    @Path(value="getByUri")
    @Produces(value={"application/xml", "application/json"})
    @ApiOperation(value="Retrieve an entity by URI or its sameAs", response=EntityWrapper.class)
    public Response getByUri(@FormParam(value="uri") String uri, @FormParam(value="toXml") boolean toEdm) {
        EntityWrapper wrapper = enricher.getByUri(uri);
        if (wrapper != null) {
            ObjectMapper objIdMapper = new ObjectMapper();
            try {
                if (toEdm) {
                    EntityWrapper newWrapper = new EntityWrapper(wrapper.getClassName(), wrapper.getOriginalField(), wrapper.getUrl(), wrapper.getOriginalValue(), this.convertEntity(wrapper));
                    return Response.ok().entity((Object)objIdMapper.writeValueAsString((Object)newWrapper)).build();
                }
                SimpleModule sm = new SimpleModule("objId", Version.unknownVersion());
                sm.addSerializer((JsonSerializer)new ObjectIdSerializer());
                objIdMapper.registerModule((Module)sm);
                return Response.ok().entity((Object)objIdMapper.writeValueAsString((Object)wrapper)).build();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="enrich")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/xml", "application/json"})
    @ApiOperation(value="Enrich a series of field value pairs", response=EntityWrapperList.class)
    public Response enrich(@ApiParam(value="input") @FormParam(value="input") String input, @ApiParam(value="toXml") @FormParam(value="toXml") String toXML) throws JsonParseException, JsonMappingException, IOException, Exception {
        try {
            ObjectMapper mapper = new ObjectMapper();
            InputValueList values = (InputValueList)mapper.readValue(input, InputValueList.class);
            EntityWrapperList response = new EntityWrapperList();
            List wrapperList = enricher.tagExternal(values.getInputValueList());
            ObjectMapper objIdMapper = new ObjectMapper();
            if (!Boolean.parseBoolean(toXML)) {
                SimpleModule sm = new SimpleModule("objId", Version.unknownVersion());
                sm.addSerializer((JsonSerializer)new ObjectIdSerializer());
                objIdMapper.registerModule((Module)sm);
                response.setWrapperList(wrapperList);
            } else {
                response.setWrapperList(this.convertToXml(wrapperList));
            }
            this.log.info(objIdMapper.writeValueAsString((Object)response));
            return Response.ok().entity((Object)objIdMapper.writeValueAsString((Object)response)).build();
        }
        catch (JsonParseException e) {
            e.printStackTrace();
            this.log.severe(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
            this.log.severe(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.log.severe(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.severe(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    private List<EntityWrapper> convertToXml(List<EntityWrapper> wrapperList) throws JsonParseException, JsonMappingException, IOException {
        ArrayList<EntityWrapper> entityWrapperList = new ArrayList<EntityWrapper>();
        for (EntityWrapper wrapper : wrapperList) {
            entityWrapperList.add(new EntityWrapper(wrapper.getClassName(), wrapper.getOriginalField(), wrapper.getUrl(), wrapper.getOriginalValue(), this.convertEntity(wrapper)));
        }
        return entityWrapperList;
    }

    private String convertEntity(EntityWrapper wrapper) throws JsonParseException, JsonMappingException, IOException {
        if (wrapper.getClassName().equals(ConceptImpl.class.getName())) {
            return this.convertConcept(wrapper.getContextualEntity());
        }
        if (wrapper.getClassName().equals(AgentImpl.class.getName())) {
            return this.convertAgent(wrapper.getContextualEntity());
        }
        if (wrapper.getClassName().equals(PlaceImpl.class.getName())) {
            return this.convertPlace(wrapper.getContextualEntity());
        }
        return this.convertTimespan(wrapper.getContextualEntity());
    }

    private String convertTimespan(String contextualEntity) throws JsonParseException, JsonMappingException, IOException {
        TimespanImpl ts = (TimespanImpl)new ObjectMapper().readValue(contextualEntity, TimespanImpl.class);
        StringBuilder sb = new StringBuilder();
        sb.append("<edm:Timespan rdf:about=\"");
        sb.append(ts.getAbout());
        sb.append("\">\n");
        this.addMap(sb, ts.getPrefLabel(), "skos:prefLabel", "xml:lang", false);
        this.addMap(sb, ts.getAltLabel(), "skos:altLabel", "xml:lang", false);
        this.addMap(sb, ts.getBegin(), "edm:begin", "xml:lang", false);
        this.addMap(sb, ts.getEnd(), "edm:end", "xml:lang", false);
        this.addMap(sb, ts.getDctermsHasPart(), "dcterms:hasPart", "rdf:resource", true);
        this.addMap(sb, ts.getHiddenLabel(), "skos:hiddenLabel", "xml:lang", false);
        this.addMap(sb, ts.getIsPartOf(), "dcterms:isPartOf", "rdf:resource", true);
        this.addMap(sb, ts.getNote(), "skos:note", "xml:lang", false);
        this.addArray(sb, ts.getOwlSameAs(), "owl:sameAs", "rdf:resource");
        sb.append("</edm:Timespan>");
        this.log.info(StringEscapeUtils.escapeXml((String)sb.toString()));
        return StringEscapeUtils.escapeHtml3((String)sb.toString());
    }

    private void addArray(StringBuilder sb, String[] arrValues, String element, String attribute) {
        if (arrValues != null) {
            for (String str : arrValues) {
                sb.append("<");
                sb.append(element);
                sb.append(" ");
                sb.append(attribute);
                sb.append("\"=");
                sb.append(str);
                sb.append("\"/>\n");
            }
        }
    }

    private void addMap(StringBuilder sb, Map<String, List<String>> values, String elementName, String attributeName, boolean isResource) {
        if (values != null) {
            for (Map.Entry<String, List<String>> entry : values.entrySet()) {
                for (String str : entry.getValue()) {
                    sb.append("<");
                    sb.append(elementName);
                    sb.append(" ");
                    sb.append(attributeName);
                    sb.append("=\"");
                    if (!isResource) {
                        sb.append(entry.getKey());
                        sb.append("\">");
                        sb.append(str);
                        sb.append("</");
                        sb.append(elementName);
                        sb.append(">\n");
                        continue;
                    }
                    sb.append(str);
                    sb.append("\"/>\n");
                }
            }
        }
    }

    private String convertPlace(String contextualEntity) throws JsonParseException, JsonMappingException, IOException {
        PlaceImpl place = (PlaceImpl)new ObjectMapper().readValue(contextualEntity, PlaceImpl.class);
        StringBuilder sb = new StringBuilder();
        sb.append("<edm:Place rdf:about=\"");
        sb.append(place.getAbout());
        sb.append("\">\n");
        this.addMap(sb, place.getPrefLabel(), "skos:prefLabel", "xml:lang", false);
        this.addMap(sb, place.getAltLabel(), "skos:altLabel", "xml:lang", false);
        this.addMap(sb, place.getDcTermsHasPart(), "dcterms:hasPart", "rdf:resource", true);
        this.addMap(sb, place.getIsPartOf(), "dcterms:isPartOf", "rdf:resource", true);
        this.addMap(sb, place.getNote(), "skos:note", "xml:lang", false);
        this.addArray(sb, place.getOwlSameAs(), "owl:sameAs", "rdf:resource");
        if (place.getLatitude() != null && place.getLatitude().floatValue() != 0.0f && place.getLongitude() != null && place.getLongitude().floatValue() != 0.0f) {
            sb.append("<wgs84_pos:long>");
            sb.append(place.getLongitude());
            sb.append("</wgs84_pos:long>\n");
            sb.append("<wgs84_pos:lat>");
            sb.append(place.getLatitude());
            sb.append("</wgs84_pos:lat>\n");
        }
        if (place.getAltitude() != null && place.getAltitude().floatValue() != 0.0f) {
            sb.append("<wgs84_pos:alt>");
            sb.append(place.getAltitude());
            sb.append("</wgs84_pos:alt>\n");
        }
        sb.append("</edm:Place>\n");
        this.log.info(StringEscapeUtils.escapeXml((String)sb.toString()));
        return StringEscapeUtils.escapeHtml3((String)sb.toString());
    }

    private String convertAgent(String contextualEntity) throws JsonParseException, JsonMappingException, IOException {
        AgentImpl agent = (AgentImpl)new ObjectMapper().readValue(contextualEntity, AgentImpl.class);
        StringBuilder sb = new StringBuilder();
        sb.append("<edm:Agent rdf:about=\"");
        sb.append(agent.getAbout());
        sb.append("\">");
        this.addMap(sb, agent.getPrefLabel(), "skos:prefLabel", "xml:lang", false);
        this.addMap(sb, agent.getAltLabel(), "skos:altLabel", "xml:lang", false);
        this.addMap(sb, agent.getHiddenLabel(), "skos:hiddenLabel", "xml:lang", false);
        this.addMap(sb, agent.getFoafName(), "foaf:name", "xml:lang", false);
        this.addMap(sb, agent.getNote(), "skos:note", "xml:lang", false);
        this.addMap(sb, agent.getBegin(), "edm:begin", "xml:lang", false);
        this.addMap(sb, agent.getEnd(), "edm:end", "xml:lang", false);
        this.addMap(sb, agent.getDcIdentifier(), "dc:identifier", "xml:lang", false);
        this.addMap(sb, agent.getEdmHasMet(), "edm:hasMet", "xml:lang", false);
        this.addMap(sb, agent.getDcIdentifier(), "dc:identifier", "xml:lang", false);
        this.addMap(sb, agent.getRdaGr2BiographicalInformation(), "rdaGr2:biographicaInformation", "xml:lang", false);
        this.addMap(sb, agent.getRdaGr2DateOfBirth(), "rdaGr2:dateOfBirth", "xml:lang", false);
        this.addMap(sb, agent.getRdaGr2DateOfDeath(), "rdaGr2:dateOfDeath", "xml:lang", false);
        this.addMap(sb, agent.getRdaGr2DateOfEstablishment(), "rdaGr2:dateOfEstablishment", "xml:lang", false);
        this.addMap(sb, agent.getRdaGr2DateOfTermination(), "rdaGr2:dateOfTermination", "xml:lang", false);
        this.addMap(sb, agent.getRdaGr2Gender(), "rdaGr2:gender", "xml:lang", false);
        this.addMapResourceOrLiteral(sb, agent.getDcDate(), "dc:date");
        this.addMapResourceOrLiteral(sb, agent.getEdmIsRelatedTo(), "edm:isRelatedTo");
        this.addMapResourceOrLiteral(sb, agent.getRdaGr2ProfessionOrOccupation(), "rdaGr2:professionOrOccupation");
        this.addArray(sb, agent.getEdmWasPresentAt(), "edm:wasPresentAt", "rdf:resource");
        this.addArray(sb, agent.getOwlSameAs(), "owl:sameAs", "rdf:resource");
        sb.append("</edm:Agent>\n");
        this.log.info(StringEscapeUtils.escapeXml((String)sb.toString()));
        return StringEscapeUtils.escapeHtml3((String)sb.toString());
    }

    private void addMapResourceOrLiteral(StringBuilder sb, Map<String, List<String>> values, String element) {
        if (values != null) {
            for (Map.Entry<String, List<String>> entry : values.entrySet()) {
                for (String str : entry.getValue()) {
                    sb.append("<");
                    sb.append(element);
                    sb.append(" ");
                    if (this.isUri(str)) {
                        sb.append("rdf:resource=\"");
                        sb.append(str);
                        sb.append("\"/>\n");
                        continue;
                    }
                    sb.append("xml:lang=\"");
                    sb.append(entry.getKey());
                    sb.append("\">");
                    sb.append(str);
                    sb.append("</");
                    sb.append(element);
                    sb.append(">\n");
                }
            }
        }
    }

    private boolean isUri(String str) {
        return str.startsWith("http://");
    }

    private String convertConcept(String contextualEntity) throws JsonParseException, JsonMappingException, IOException {
        ConceptImpl concept = (ConceptImpl)new ObjectMapper().readValue(contextualEntity, ConceptImpl.class);
        StringBuilder sb = new StringBuilder();
        sb.append("<skos:Concept rdf:about=\"");
        sb.append(concept.getAbout());
        sb.append("\"/>\n");
        this.addMap(sb, concept.getPrefLabel(), "skos:prefLabel", "xml:lang", false);
        this.addMap(sb, concept.getAltLabel(), "skos:altLabel", "xml:lang", false);
        this.addMap(sb, concept.getHiddenLabel(), "skos:hiddenLabel", "xml:lang", false);
        this.addMap(sb, concept.getNotation(), "skos:notation", "xml:lang", false);
        this.addMap(sb, concept.getNote(), "skos:note", "xml:lang", false);
        this.addArray(sb, concept.getBroader(), "skos:broader", "rdf:resource");
        this.addArray(sb, concept.getBroadMatch(), "skos:broadMatch", "rdf:resource");
        this.addArray(sb, concept.getCloseMatch(), "skos:closeMatch", "rdf:resource");
        this.addArray(sb, concept.getExactMatch(), "skos:exactMatch", "rdf:resource");
        this.addArray(sb, concept.getInScheme(), "skos:inScheme", "rdf:resource");
        this.addArray(sb, concept.getNarrower(), "skos:narrower", "rdf:resource");
        this.addArray(sb, concept.getNarrowMatch(), "skos:narrowMatch", "rdf:resource");
        this.addArray(sb, concept.getRelated(), "skos:related", "rdf:resource");
        this.addArray(sb, concept.getRelatedMatch(), "skos:relatedMatch", "rdf:resource");
        sb.append("</skos:Concept>\n");
        this.log.info(StringEscapeUtils.escapeXml((String)sb.toString()));
        return StringEscapeUtils.escapeHtml3((String)sb.toString());
    }

    static {
        try {
            enricher.init("Europeana", new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

