/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.harvester.util;

import eu.europeana.corelib.solr.entity.AgentImpl;
import eu.europeana.corelib.solr.entity.ConceptImpl;
import java.io.IOException;
import java.util.List;
import org.apache.commons.validator.routines.UrlValidator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MongoDataSerializer {
    public Node serializeAgent(Document doc, AgentImpl agent) {
        Element agentElement = doc.createElement("edm:Agent");
        agentElement.setAttribute("rdf:about", agent.getAbout());
        if (agent.getPrefLabel() != null) {
            for (String attrVal : agent.getPrefLabel().keySet()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "skos:prefLabel", "xml:lang", attrVal, (List)agent.getPrefLabel().get(attrVal)));
            }
        }
        if (agent.getAltLabel() != null) {
            for (String attrVal : agent.getAltLabel().keySet()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "skos:altLabel", "xml:lang", attrVal, (List)agent.getAltLabel().get(attrVal)));
            }
        }
        if (agent.getHiddenLabel() != null) {
            for (String attrVal : agent.getHiddenLabel().keySet()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "skos:hiddenLabel", "xml:lang", attrVal, (List)agent.getHiddenLabel().get(attrVal)));
            }
        }
        if (agent.getFoafName() != null) {
            for (String attrVal : agent.getFoafName().keySet()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "foaf:name", "xml:lang", attrVal, (List)agent.getFoafName().get(attrVal)));
            }
        }
        if (agent.getNote() != null) {
            for (String attrVal : agent.getNote().keySet()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "skos:note", "xml:lang", attrVal, (List)agent.getNote().get(attrVal)));
            }
        }
        if (agent.getBegin() != null) {
            for (String attrVal : agent.getBegin().keySet()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "edm:begin", "xml:lang", attrVal, (List)agent.getBegin().get(attrVal)));
            }
        }
        if (agent.getEnd() != null) {
            for (String attrVal : agent.getEnd().keySet()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "edm:end", "xml:lang", attrVal, (List)agent.getEnd().get(attrVal)));
            }
        }
        if (agent.getDcIdentifier() != null) {
            for (String attrVal : agent.getDcIdentifier().keySet()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "dc:identifier", "xml:lang", attrVal, (List)agent.getDcIdentifier().get(attrVal)));
            }
        }
        if (agent.getEdmHasMet() != null) {
            for (String attrVal : agent.getEdmHasMet().keySet()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "edm:hasMet", "xml:lang", attrVal, (List)agent.getEdmHasMet().get(attrVal)));
            }
        }
        if (agent.getRdaGr2BiographicalInformation() != null) {
            for (String attrVal : agent.getRdaGr2BiographicalInformation().keySet()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "rdaGr2:biographicalInformation", "xml:lang", attrVal, (List)agent.getRdaGr2BiographicalInformation().get(attrVal)));
            }
        }
        if (agent.getRdaGr2DateOfBirth() != null) {
            for (String attrVal : agent.getRdaGr2DateOfBirth().keySet()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "rdaGr2:dateOfBirth", "xml:lang", attrVal, (List)agent.getRdaGr2DateOfBirth().get(attrVal)));
            }
        }
        if (agent.getRdaGr2DateOfDeath() != null) {
            for (String attrVal : agent.getRdaGr2DateOfDeath().keySet()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "rdaGr2:dateOfDeath", "xml:lang", attrVal, (List)agent.getRdaGr2DateOfDeath().get(attrVal)));
            }
        }
        if (agent.getRdaGr2DateOfEstablishment() != null) {
            for (String attrVal : agent.getRdaGr2DateOfEstablishment().keySet()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "rdaGr2:dateOfEstablishment", "xml:lang", attrVal, (List)agent.getRdaGr2DateOfEstablishment().get(attrVal)));
            }
        }
        if (agent.getRdaGr2DateOfTermination() != null) {
            for (String attrVal : agent.getRdaGr2DateOfTermination().keySet()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "rdaGr2:dateOfTermination", "xml:lang", attrVal, (List)agent.getRdaGr2DateOfTermination().get(attrVal)));
            }
        }
        if (agent.getRdaGr2Gender() != null) {
            for (String attrVal : agent.getRdaGr2Gender().keySet()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "rdaGr2:gender", "xml:lang", attrVal, (List)agent.getRdaGr2Gender().get(attrVal)));
            }
        }
        if (agent.getEdmWasPresentAt() != null) {
            for (String string : agent.getEdmWasPresentAt()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "edm:wasPresentAt", "rdf:resource", string, string));
            }
        }
        if (agent.getOwlSameAs() != null) {
            for (String string : agent.getOwlSameAs()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "owl:sameAs", "rdf:resource", string, string));
            }
        }
        if (agent.getEdmIsRelatedTo() != null) {
            for (String attrVal : agent.getEdmIsRelatedTo().keySet()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "edm:isRelatedTo", attrVal, (List)agent.getEdmIsRelatedTo().get(attrVal)));
            }
        }
        if (agent.getDcDate() != null) {
            for (String attrVal : agent.getDcDate().keySet()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "dc:date", attrVal, (List)agent.getDcDate().get(attrVal)));
            }
        }
        if (agent.getRdaGr2ProfessionOrOccupation() != null) {
            for (String attrVal : agent.getRdaGr2ProfessionOrOccupation().keySet()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "rdaGr2:professionOrOccupation", attrVal, (List)agent.getRdaGr2ProfessionOrOccupation().get(attrVal)));
            }
        }
        return agentElement;
    }

    public Node serializeAgentsAsStored(Document doc, AgentImpl agent) {
        Element agentElement = doc.createElement("edm:Agent");
        agentElement.setAttribute("rdf:about", agent.getAbout());
        if (agent.getPrefLabel() != null) {
            for (String attrVal : agent.getPrefLabel().keySet()) {
                for (String string : (List)agent.getPrefLabel().get(attrVal)) {
                    agentElement.appendChild(this.getElements(doc, "skos:prefLabel", "xml:lang", attrVal, string));
                }
            }
        }
        if (agent.getAltLabel() != null) {
            for (String attrVal : agent.getAltLabel().keySet()) {
                for (String string : (List)agent.getAltLabel().get(attrVal)) {
                    agentElement.appendChild(this.getElements(doc, "skos:altLabel", "xml:lang", attrVal, string));
                }
            }
        }
        if (agent.getHiddenLabel() != null) {
            for (String attrVal : agent.getHiddenLabel().keySet()) {
                for (String string : (List)agent.getHiddenLabel().get(attrVal)) {
                    agentElement.appendChild(this.getElements(doc, "skos:hiddenLabel", "xml:lang", attrVal, string));
                }
            }
        }
        if (agent.getFoafName() != null) {
            for (String attrVal : agent.getFoafName().keySet()) {
                for (String string : (List)agent.getFoafName().get(attrVal)) {
                    agentElement.appendChild(this.getElements(doc, "foaf:name", "xml:lang", attrVal, string));
                }
            }
        }
        if (agent.getNote() != null) {
            for (String attrVal : agent.getNote().keySet()) {
                for (String string : (List)agent.getNote().get(attrVal)) {
                    agentElement.appendChild(this.getElements(doc, "skos:note", "xml:lang", attrVal, string));
                }
            }
        }
        if (agent.getBegin() != null) {
            for (String attrVal : agent.getBegin().keySet()) {
                for (String string : (List)agent.getBegin().get(attrVal)) {
                    agentElement.appendChild(this.getElements(doc, "edm:begin", "xml:lang", attrVal, string));
                }
            }
        }
        if (agent.getEnd() != null) {
            for (String attrVal : agent.getEnd().keySet()) {
                for (String string : (List)agent.getEnd().get(attrVal)) {
                    agentElement.appendChild(this.getElements(doc, "edm:end", "xml:lang", attrVal, string));
                }
            }
        }
        if (agent.getDcIdentifier() != null) {
            for (String attrVal : agent.getDcIdentifier().keySet()) {
                for (String string : (List)agent.getDcIdentifier().get(attrVal)) {
                    agentElement.appendChild(this.getElements(doc, "dc:identifier", "xml:lang", attrVal, string));
                }
            }
        }
        if (agent.getEdmHasMet() != null) {
            for (String attrVal : agent.getEdmHasMet().keySet()) {
                for (String string : (List)agent.getEdmHasMet().get(attrVal)) {
                    agentElement.appendChild(this.getElements(doc, "edm:hasMet", "xml:lang", attrVal, string));
                }
            }
        }
        if (agent.getRdaGr2BiographicalInformation() != null) {
            for (String attrVal : agent.getRdaGr2BiographicalInformation().keySet()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "rdaGr2:biographicalInformation", attrVal, (List)agent.getRdaGr2BiographicalInformation().get(attrVal)));
            }
            if (agent.getRdaGr2PlaceOfBirth() != null) {
                for (String attrVal : agent.getRdaGr2PlaceOfBirth().keySet()) {
                    for (String string : (List)agent.getRdaGr2PlaceOfBirth().get(attrVal)) {
                        agentElement.appendChild(this.getElements(doc, "rdaGr2:placeOfBirth", "xml:lang", attrVal, string));
                    }
                }
            }
            if (agent.getRdaGr2PlaceOfDeath() != null) {
                for (String attrVal : agent.getRdaGr2PlaceOfDeath().keySet()) {
                    for (String string : (List)agent.getRdaGr2PlaceOfDeath().get(attrVal)) {
                        agentElement.appendChild(this.getElements(doc, "rdaGr2:placeOfDeath", "xml:lang", attrVal, string));
                    }
                }
            }
        }
        if (agent.getRdaGr2DateOfBirth() != null) {
            for (String attrVal : agent.getRdaGr2DateOfBirth().keySet()) {
                for (String string : (List)agent.getRdaGr2DateOfBirth().get(attrVal)) {
                    agentElement.appendChild(this.getElements(doc, "rdaGr2:dateOfBirth", "xml:lang", attrVal, string));
                }
            }
        }
        if (agent.getRdaGr2DateOfDeath() != null) {
            for (String attrVal : agent.getRdaGr2DateOfDeath().keySet()) {
                for (String string : (List)agent.getRdaGr2DateOfDeath().get(attrVal)) {
                    agentElement.appendChild(this.getElements(doc, "rdaGr2:dateOfDeath", "xml:lang", attrVal, string));
                }
            }
        }
        if (agent.getRdaGr2DateOfEstablishment() != null) {
            for (String attrVal : agent.getRdaGr2DateOfEstablishment().keySet()) {
                for (String string : (List)agent.getRdaGr2DateOfEstablishment().get(attrVal)) {
                    agentElement.appendChild(this.getElements(doc, "rdaGr2:dateOfEstablishment", "xml:lang", attrVal, string));
                }
            }
        }
        if (agent.getRdaGr2DateOfTermination() != null) {
            for (String attrVal : agent.getRdaGr2DateOfTermination().keySet()) {
                for (String string : (List)agent.getRdaGr2DateOfTermination().get(attrVal)) {
                    agentElement.appendChild(this.getElements(doc, "rdaGr2:dateOfTermination", "xml:lang", attrVal, string));
                }
            }
        }
        if (agent.getRdaGr2Gender() != null) {
            for (String attrVal : agent.getRdaGr2Gender().keySet()) {
                for (String string : (List)agent.getRdaGr2Gender().get(attrVal)) {
                    agentElement.appendChild(this.getElements(doc, "rdaGr2:gender", "xml:lang", attrVal, string));
                }
            }
        }
        if (agent.getEdmWasPresentAt() != null) {
            for (String string : agent.getEdmWasPresentAt()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "edm:wasPresentAt", "rdf:resource", string, string));
            }
        }
        if (agent.getOwlSameAs() != null) {
            for (String string : agent.getOwlSameAs()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "owl:sameAs", "rdf:resource", string, string));
            }
        }
        if (agent.getEdmIsRelatedTo() != null) {
            for (String attrVal : agent.getEdmIsRelatedTo().keySet()) {
                for (String string : (List)agent.getEdmIsRelatedTo().get(attrVal)) {
                    agentElement.appendChild(this.getElement(doc, agentElement, "edm:isRelatedTo", attrVal, string));
                }
            }
        }
        if (agent.getDcDate() != null) {
            for (String attrVal : agent.getDcDate().keySet()) {
                agentElement.appendChild(this.getElements(doc, agentElement, "dc:date", attrVal, (List)agent.getDcDate().get(attrVal)));
            }
        }
        if (agent.getRdaGr2ProfessionOrOccupation() != null) {
            for (String attrVal : agent.getRdaGr2ProfessionOrOccupation().keySet()) {
                for (String string : (List)agent.getRdaGr2ProfessionOrOccupation().get(attrVal)) {
                    agentElement.appendChild(this.getElement(doc, agentElement, "rdaGr2:professionOrOccupation", attrVal, string));
                }
            }
        }
        return agentElement;
    }

    public Node serializeConcept(Document doc, ConceptImpl concept) throws JsonParseException, JsonMappingException, IOException {
        Element conceptElement = doc.createElement("skos:Concept");
        conceptElement.setAttribute("rdf:about", concept.getAbout());
        if (concept.getPrefLabel() != null) {
            for (String attrVal : concept.getPrefLabel().keySet()) {
                conceptElement.appendChild(this.getElements(doc, conceptElement, "skos:prefLabel", "xml:lang", attrVal, (List)concept.getPrefLabel().get(attrVal)));
            }
        }
        if (concept.getAltLabel() != null) {
            for (String attrVal : concept.getAltLabel().keySet()) {
                conceptElement.appendChild(this.getElements(doc, conceptElement, "skos:altLabel", "xml:lang", attrVal, (List)concept.getAltLabel().get(attrVal)));
            }
        }
        if (concept.getHiddenLabel() != null) {
            for (String attrVal : concept.getHiddenLabel().keySet()) {
                conceptElement.appendChild(this.getElements(doc, conceptElement, "skos:hiddenLabel", "xml:lang", attrVal, (List)concept.getHiddenLabel().get(attrVal)));
            }
        }
        if (concept.getNotation() != null) {
            for (String attrVal : concept.getNotation().keySet()) {
                conceptElement.appendChild(this.getElements(doc, conceptElement, "skos:notation", "xml:lang", attrVal, (List)concept.getNotation().get(attrVal)));
            }
        }
        if (concept.getNote() != null) {
            for (String attrVal : concept.getNote().keySet()) {
                conceptElement.appendChild(this.getElements(doc, conceptElement, "skos:note", "xml:lang", attrVal, (List)concept.getNote().get(attrVal)));
            }
        }
        if (concept.getBroader() != null) {
            for (String attrVal : concept.getBroader()) {
                conceptElement.appendChild(this.getElements(doc, conceptElement, "skos:broader", "rdf:resource", attrVal, attrVal));
            }
        }
        if (concept.getBroadMatch() != null) {
            for (String attrVal : concept.getBroadMatch()) {
                conceptElement.appendChild(this.getElements(doc, conceptElement, "skos:broadMatch", "rdf:resource", attrVal, attrVal));
            }
        }
        if (concept.getCloseMatch() != null) {
            for (String attrVal : concept.getCloseMatch()) {
                conceptElement.appendChild(this.getElements(doc, conceptElement, "skos:closeMatch", "rdf:resource", attrVal, attrVal));
            }
        }
        if (concept.getExactMatch() != null) {
            for (String attrVal : concept.getExactMatch()) {
                conceptElement.appendChild(this.getElements(doc, conceptElement, "skos:exactMatch", "rdf:resource", attrVal, attrVal));
            }
        }
        if (concept.getInScheme() != null) {
            for (String attrVal : concept.getInScheme()) {
                conceptElement.appendChild(this.getElements(doc, conceptElement, "skos:inScheme", "rdf:resource", attrVal, attrVal));
            }
        }
        if (concept.getNarrower() != null) {
            for (String attrVal : concept.getNarrower()) {
                conceptElement.appendChild(this.getElements(doc, conceptElement, "skos:narrower", "rdf:resource", attrVal, attrVal));
            }
        }
        if (concept.getNarrowMatch() != null) {
            for (String attrVal : concept.getNarrowMatch()) {
                conceptElement.appendChild(this.getElements(doc, conceptElement, "skos:narrowMatch", "rdf:resource", attrVal, attrVal));
            }
        }
        if (concept.getRelated() != null) {
            for (String attrVal : concept.getRelated()) {
                conceptElement.appendChild(this.getElements(doc, conceptElement, "skos:related", "rdf:resource", attrVal, attrVal));
            }
        }
        if (concept.getRelatedMatch() != null) {
            for (String attrVal : concept.getRelatedMatch()) {
                conceptElement.appendChild(this.getElements(doc, conceptElement, "skos:relatedMatch", "rdf:resource", attrVal, attrVal));
            }
        }
        return conceptElement;
    }

    private Node getElements(Document doc, Element conceptElement, String name, String attribute, String attributeValue, List<String> textValue) {
        Element node = doc.createElement(name);
        if (attribute.equals("xml:lang") && attributeValue.equals("def")) {
            String temp = "";
        } else {
            node.setAttribute(attribute, attributeValue);
        }
        for (String value : textValue) {
            node.appendChild(doc.createTextNode(value));
        }
        return node;
    }

    private Node getElements(Document doc, Element conceptElement, String name, String attribute, String attributeValue, String textValue) {
        Element node = doc.createElement(name);
        node.setAttribute(attribute, textValue);
        return node;
    }

    private Node getElements(Document doc, String name, String attribute, String attributeValue, String textValue) {
        Element node = doc.createElement(name);
        String value = textValue.replace("\n", " ");
        textValue = value.replace("\t", "");
        textValue = textValue.trim().replaceAll(" +", " ");
        if (attribute.equals("xml:lang") && attributeValue.equals("def")) {
            String temp = "";
        } else {
            node.setAttribute(attribute, attributeValue);
        }
        node.appendChild(doc.createTextNode(textValue));
        return node;
    }

    private Node getElements(Document doc, Element conceptElement, String name, String attributeValue, List<String> textValue) {
        Element node = doc.createElement(name);
        UrlValidator urlValidator = new UrlValidator();
        for (String value : textValue) {
            String myValue = value.replace("\t", "");
            value = myValue.replace("\n", "");
            if (urlValidator.isValid(value = value.trim().replaceAll(" +", " "))) {
                node.setAttribute("rdf:resource", value);
                continue;
            }
            if (!attributeValue.trim().equalsIgnoreCase("def")) {
                node.setAttribute("xml:lang", attributeValue);
            }
            node.appendChild(doc.createTextNode(value));
        }
        return node;
    }

    private Node getElement(Document doc, Element conceptElement, String name, String attributeValue, String value) {
        Element node = doc.createElement(name);
        UrlValidator urlValidator = new UrlValidator();
        String myValue = value.replace("\t", "");
        value = myValue.replace("\n", "");
        if (urlValidator.isValid(value = value.trim().replaceAll(" +", " "))) {
            node.setAttribute("rdf:resource", value);
        } else {
            if (!attributeValue.trim().equalsIgnoreCase("def")) {
                node.setAttribute("xml:lang", attributeValue);
            }
            node.appendChild(doc.createTextNode(value));
        }
        return node;
    }
}

