/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.harvester.util;

import eu.europeana.corelib.solr.entity.AgentImpl;
import eu.europeana.enrichment.harvester.api.AgentMap;
import eu.europeana.enrichment.harvester.database.DataManager;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ContentChecker {
    private final DataManager dm = new DataManager();
    private static int wrongDates = 0;
    private static int correctdates = 0;
    private static PrintWriter writer;

    public static void main(String[] args) {
        ContentChecker coce = new ContentChecker();
        try {
            writer = new PrintWriter("Dates_diff.txt", "UTF-8");
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        coce.compareEntities();
        System.out.println("total errors: " + wrongDates);
        writer.close();
    }

    public void compareEntities() {
        int resultsize = 1000;
        int limit = 1000;
        int offset = 0;
        int sameAs = 0;
        int noSameAs = 0;
        while (resultsize == limit) {
            List<AgentMap> agents = this.dm.extractAllAgentsFromLocalStorage(limit, offset);
            resultsize = agents.size();
            for (AgentMap am : agents) {
                if (this.compareData(am.getAgentUri().toASCIIString(), am.getSameAs())) {
                    ++sameAs;
                    continue;
                }
                ++noSameAs;
            }
            if (agents.size() != limit) continue;
            offset += limit;
        }
        System.out.println("sameAs n.: " + sameAs + ", no sameAs n.: " + noSameAs);
    }

    public void createEuropeanaEntities() {
        int resultsize = 1000;
        int limit = 1000;
        int offset = 0;
        int sameAs = 0;
        int noSameAs = 0;
        while (resultsize == limit) {
            List<AgentMap> agents = this.dm.extractAllAgentsFromLocalStorage(limit, offset);
            resultsize = agents.size();
            for (AgentMap am : agents) {
                this.createEntities(am.getAgentUri().toASCIIString(), am.getSameAs());
            }
            if (agents.size() != limit) continue;
            offset += limit;
        }
        System.out.println("sameAs n.: " + sameAs + ", no sameAs n.: " + noSameAs);
    }

    private void compareDates(Map<String, List<String>> dates, Map<String, List<String>> saDates, String id, String saId, String field) {
        String[] formatStrings = new String[]{"yyyy-mm-dd", "yyyy"};
        for (String dobai : dates.keySet()) {
            List<String> aiBD = dates.get(dobai);
            int nod = aiBD.size();
            int nowd = 0;
            for (String bd : aiBD) {
                Date date = null;
                Date sadate = null;
                try {
                    for (String formatString : formatStrings) {
                        try {
                            date = new SimpleDateFormat(formatString).parse(bd);
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    for (String sadobai : saDates.keySet()) {
                        List<String> saaiBD = saDates.get(sadobai);
                        for (String sabd : saaiBD) {
                            for (String formatString : formatStrings) {
                                try {
                                    sadate = new SimpleDateFormat(formatString).parse(sabd);
                                }
                                catch (ParseException parseException) {
                                    // empty catch block
                                }
                            }
                            if (date.compareTo(sadate) == 0) continue;
                            System.out.println("(" + field + ") " + id + "(" + bd + ") - " + saId + "(" + sabd + "), " + ++nowd + " of " + nod);
                            writer.println("(" + field + ") " + id + "(" + bd + ") - " + saId + "(" + sabd + "), " + nowd + " of " + nod);
                            ++wrongDates;
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
        }
    }

    private void createEntities(String id, List<String> sameAs) {
        if (sameAs != null) {
            AgentImpl ai = this.dm.getAgent(id);
            AgentImpl saai = this.dm.getAgent(sameAs.get(0));
            AgentImpl agentImpl = new AgentImpl();
        }
    }

    public boolean compareData(String id, List<String> sameAs) {
        if (sameAs != null && sameAs.size() == 1) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-mm-dd");
            String[] formatStrings = new String[]{"yyyy-mm-dd", "yyyy"};
            AgentImpl ai = this.dm.getAgent(id);
            AgentImpl saai = this.dm.getAgent(sameAs.get(0));
            if (ai != null && saai != null && ai.getRdaGr2DateOfBirth() != null && saai.getRdaGr2DateOfBirth() != null) {
                this.compareDates(ai.getRdaGr2DateOfBirth(), saai.getRdaGr2DateOfBirth(), id, sameAs.get(0), "getRdaGr2DateOfBirth");
            }
            if (ai != null && saai != null && ai.getRdaGr2DateOfDeath() != null && saai.getRdaGr2DateOfDeath() != null) {
                this.compareDates(ai.getRdaGr2DateOfDeath(), saai.getRdaGr2DateOfDeath(), id, sameAs.get(0), "getRdaGr2DateOfDeath");
            }
            return true;
        }
        return false;
    }
}

