/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.harvester.transform.edm.place;

import eu.europeana.corelib.solr.entity.PlaceImpl;
import eu.europeana.enrichment.harvester.transform.XslTransformer;
import eu.europeana.enrichment.harvester.transform.edm.place.PlaceTemplate;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;

public class PlaceTransformer
implements XslTransformer<PlaceImpl> {
    @Override
    public PlaceImpl transform(String xsltPath, String resourceUri, Source doc) {
        StreamSource transformDoc = new StreamSource(new File(xsltPath));
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer(transformDoc);
            StreamResult out = new StreamResult(new StringWriter());
            transformer.setParameter("rdf_about", resourceUri);
            transformer.transform(doc, out);
            return this.normalize(PlaceTemplate.getInstance().transform(out.getWriter().toString(), resourceUri));
        }
        catch (TransformerException | TransformerFactoryConfigurationError e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public PlaceImpl normalize(PlaceImpl place) {
        String about = place.getAbout();
        if (place.getIsPartOf() != null) {
            Map map = place.getIsPartOf();
            HashMap newMap = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                ArrayList<String> values = new ArrayList<String>();
                for (String str : (List)entry.getValue()) {
                    if (StringUtils.equals((String)str, (String)about)) continue;
                    values.add(str);
                }
                newMap.put(entry.getKey(), values);
            }
            place.setIsPartOf(newMap);
        }
        return place;
    }
}

