/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.harvester.transform.edm.concept;

import eu.europeana.corelib.solr.entity.ConceptImpl;
import eu.europeana.enrichment.harvester.transform.XslTransformer;
import eu.europeana.enrichment.harvester.transform.edm.concept.ConceptTemplate;
import eu.europeana.enrichment.harvester.transform.util.NormalizeUtils;
import java.io.File;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ConceptTransformer
implements XslTransformer<ConceptImpl> {
    private static final Logger log = Logger.getLogger(XslTransformer.class.getCanonicalName());

    @Override
    public ConceptImpl transform(String xsltPath, String resourceUri, Source doc) {
        StreamSource transformDoc = new StreamSource(new File(xsltPath));
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer(transformDoc);
            StreamResult out = new StreamResult(new StringWriter());
            transformer.setParameter("rdf_about", resourceUri);
            transformer.transform(doc, out);
            return this.normalize(ConceptTemplate.getInstance().transform(out.getWriter().toString(), resourceUri));
        }
        catch (TransformerException | TransformerFactoryConfigurationError e) {
            log.log(Level.SEVERE, e.getMessage());
            return null;
        }
    }

    @Override
    public ConceptImpl normalize(ConceptImpl concept) {
        concept.setNote(NormalizeUtils.normalizeMap(concept.getNote()));
        concept.setExactMatch(NormalizeUtils.normalizeArray(concept.getExactMatch()));
        concept.setPrefLabel(NormalizeUtils.normalizeMap(concept.getPrefLabel()));
        concept.setBroader(NormalizeUtils.normalizeArray(concept.getBroader()));
        concept.setRelated(NormalizeUtils.normalizeArray(concept.getRelated()));
        return concept;
    }
}

