/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.harvester.transform;

import eu.europeana.corelib.solr.entity.ContextualClassImpl;
import java.io.ByteArrayInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang.StringUtils;

public abstract class Template<S extends ContextualClassImpl> {
    private static final Logger log = Logger.getLogger(Template.class.getCanonicalName());
    private static final String RDF_RESOURCE = "rdf:resource";
    private static final String XML_LANG = "xml:lang";
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final String RDF_NAMESPACE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";

    private void appendValue(S obj, String methodName, Object value) {
        if (value.getClass().isAssignableFrom(String.class)) {
            obj.setAbout((String)value);
        } else {
            Class<Object> type = null;
            Method found = null;
            try {
                Object vals;
                Method getter = obj.getClass().getMethod(StringUtils.replace((String)methodName, (String)"set", (String)"get"), new Class[0]);
                for (Method method : obj.getClass().getMethods()) {
                    if (!StringUtils.equals((String)method.getName(), (String)methodName)) continue;
                    type = method.getParameterTypes()[0];
                    found = method;
                    break;
                }
                if (type.isAssignableFrom(String[].class)) {
                    vals = (String[])getter.invoke(obj, new Object[0]);
                    if (vals == null) {
                        vals = new String[]{((AttributeHolder)value).getAttributeValue()};
                        found.invoke(obj, vals);
                    } else {
                        ArrayList<String> strs = new ArrayList<String>(Arrays.asList(vals));
                        strs.add(((AttributeHolder)value).getAttributeValue());
                        String[] finalArray = strs.toArray(new String[strs.size()]);
                        found.invoke(obj, new Object[]{finalArray});
                    }
                }
                if (type.isAssignableFrom(Float.class)) {
                    found.invoke(obj, Float.valueOf(Float.parseFloat(((AttributeHolder)value).elementValue)));
                }
                if (type.isAssignableFrom(Map.class)) {
                    vals = (Map)getter.invoke(obj, new Object[0]);
                    AttributeHolder attr = (AttributeHolder)value;
                    if (attr.getAttributeName() != null && attr.getAttributeName().equals(RDF_RESOURCE)) {
                        if (vals == null) {
                            vals = new HashMap();
                            ArrayList<String> str = new ArrayList<String>();
                            str.add(attr.attributeValue);
                            vals.put("def", str);
                        } else {
                            List<String> str = new ArrayList<String>();
                            if (vals.containsKey("def")) {
                                str = (List)vals.get("def");
                            }
                            str.add(attr.attributeValue);
                            vals.put("def", str);
                        }
                    } else if (attr.getAttributeName() == null) {
                        if (vals == null) {
                            vals = new HashMap();
                            ArrayList<String> str = new ArrayList<String>();
                            str.add(attr.elementValue);
                            vals.put("def", str);
                        } else {
                            List<String> str = new ArrayList<String>();
                            if (vals.containsKey("def")) {
                                str = (List)vals.get("def");
                            }
                            str.add(attr.elementValue);
                            vals.put("def", str);
                        }
                    } else if (vals == null) {
                        vals = new HashMap();
                        ArrayList<String> str = new ArrayList<String>();
                        str.add(attr.elementValue);
                        vals.put(attr.attributeValue, str);
                    } else {
                        List<String> str = new ArrayList<String>();
                        if (vals.containsKey(attr.attributeValue)) {
                            str = (List)vals.get(attr.attributeValue);
                        }
                        str.add(attr.elementValue);
                        vals.put(attr.attributeValue, str);
                    }
                    found.invoke(obj, vals);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                log.log(Level.SEVERE, e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected S parse(S obj, String resourceUri, String xml, Map<String, String> methodMapping) {
        xml = xml.replace("&#55296;", "");
        xml = xml.replace("&#55362;", "");
        xml = xml.replace("&#55363;", "");
        xml = xml.replace("&#55364;", "");
        xml = xml.replace("&#55378;", "");
        xml = xml.replace("&#55381;", "");
        xml = xml.replace("&#55384;", "");
        xml = xml.replace("&#55391;", "");
        xml = xml.replace("&#55394;", "");
        xml = xml.replace("&#55629;", "");
        xml = xml.replace("&#56256;", "");
        xml = xml.replace("&#56322;", "");
        xml = xml.replace("&#56351;", "");
        xml = xml.replace("&#56384;", "");
        xml = xml.replace("&#56394;", "");
        xml = xml.replace("&#56513;", "");
        xml = xml.replace("&#56648;", "");
        xml = xml.replace("&#56657;", "");
        xml = xml.replace("&#56786;", "");
        xml = xml.replace("&#56855;", "");
        xml = xml.replace("&#57086;", "");
        xml = xml.replace("&#57113;", "");
        xml = xml.replace("&#57121;", "");
        xml = xml.replace("&#57136;", "");
        xml = xml.replace("&#57137;", "");
        xml = xml.replace("&#57138;", "");
        xml = xml.replace("&#57139;", "");
        xml = xml.replace("&#57140;", "");
        xml = xml.replace("&#57142;", "");
        xml = xml.replace("&#57143;", "");
        xml = xml.replace("&#57144;", "");
        xml = xml.replace("&#57145;", "");
        xml = xml.replace("&#57146;", "");
        xml = xml.replace("&#57147;", "");
        xml = xml.replace("&#57148;", "");
        xml = xml.replace("&#57149;", "");
        xml = xml.replace("&#57150;", "");
        xml = xml.replace("&#57151;", "");
        xml = xml.replace("&#57152;", "");
        xml = xml.replace("&#57154;", "");
        xml = xml.replace("&#57155;", "");
        xml = xml.replace("&#57156;", "");
        xml = xml.replace("&#57157;", "");
        xml = xml.replace("&#57158;", "");
        xml = xml.replace("&#57159;", "");
        xml = xml.replace("&#57161;", "");
        xml = xml.replace("&#57271;", "");
        xml = xml.replace("&#57279;", "");
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes(Charset.forName("UTF-8")));
        try {
            XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
            boolean isRoot = true;
            while (eventReader.hasNext()) {
                AttributeHolder attribute;
                StartElement startElement;
                String qElem;
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement() || !methodMapping.containsKey(qElem = (startElement = event.asStartElement()).getName().getPrefix() + ":" + startElement.getName().getLocalPart())) continue;
                if (isRoot) {
                    this.appendValue(obj, methodMapping.get(qElem), resourceUri);
                    isRoot = !isRoot;
                    continue;
                }
                Attribute attr = startElement.getAttributeByName(new QName(RDF_NAMESPACE, "resource"));
                Attribute langAttr = startElement.getAttributeByName(new QName(XML_NAMESPACE, "lang"));
                Attribute about = startElement.getAttributeByName(new QName(RDF_NAMESPACE, "about"));
                if (attr != null) {
                    attribute = new AttributeHolder();
                    attribute.setAttributeName(RDF_RESOURCE);
                    attribute.setAttributeValue(attr.getValue());
                    this.appendValue(obj, methodMapping.get(qElem), attribute);
                    continue;
                }
                if (about != null) continue;
                attribute = new AttributeHolder();
                if (langAttr != null) {
                    attribute.setAttributeName(XML_LANG);
                    attribute.setAttributeValue(langAttr.getValue());
                }
                if ((event = eventReader.nextEvent()).isEndElement()) continue;
                attribute.setElementValue(event.asCharacters().getData());
                this.appendValue(obj, methodMapping.get(qElem), attribute);
            }
            return obj;
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            log.log(Level.SEVERE, e.getMessage() + " \n" + xml);
            return null;
        }
    }

    public abstract S transform(String var1, String var2);

    class AttributeHolder {
        private String attributeName;
        private String attributeValue;
        private String elementValue;

        AttributeHolder() {
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public String getAttributeValue() {
            return this.attributeValue;
        }

        public void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        public String getElementValue() {
            return this.elementValue;
        }

        public void setElementValue(String elementValue) {
            this.elementValue = elementValue;
        }
    }
}

