/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.harvester.geonames;

import eu.europeana.enrichment.harvester.geonames.CustomObjectMapper;
import eu.europeana.enrichment.harvester.transform.edm.place.PlaceTransformer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class Main {
    public static void main(String[] args) {
        try {
            File[] files;
            for (File file : files = new File("/home/ymamakis/git/tools/annocultor_solr3.5/converters/geonames/input_source/SA").listFiles()) {
                if (!file.getName().endsWith(".rdf")) continue;
                System.out.println("Processing " + file.getName());
                long start = new Date().getTime();
                String test = IOUtils.toString((InputStream)new FileInputStream(file));
                String prefix = StringUtils.substringBefore((String)test, (String)"<rdf:D");
                String suffix = "</rdf:RDF>";
                test = "<rdf:D" + StringUtils.substringAfter((String)test, (String)"<rdf:D");
                test = StringUtils.substringBeforeLast((String)test, (String)"tion>") + "tion>";
                String[] countries = test.split("\n\n");
                PlaceTransformer transformer = new PlaceTransformer();
                ArrayList<String> places = new ArrayList<String>();
                CustomObjectMapper mapper = new CustomObjectMapper();
                for (String country : countries) {
                    StreamSource doc = new StreamSource(new ByteArrayInputStream((prefix + country + suffix).getBytes()));
                    String uri = StringUtils.substringBetween((String)country, (String)"rdf:about=\"", (String)"\">");
                    places.add(mapper.writeValueAsString(transformer.transform("/home/ymamakis/git/tools/europeana-enrichment-framework/enrichment/enrichment-framework-knowledgebase/src/main/resources/mapped_geonames_places.xsl", uri, doc)));
                }
                FileUtils.writeLines((File)new File(file.getParentFile() + "/" + StringUtils.replace((String)file.getName(), (String)".rdf", (String)".edm")), places);
                System.out.println("Processed " + file.getName() + " in " + (new Date().getTime() - start) + " ms");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

