/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.harvester.geonames;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import eu.europeana.corelib.solr.entity.PlaceImpl;
import eu.europeana.enrichment.api.internal.MongoTerm;
import eu.europeana.enrichment.api.internal.PlaceTermList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.mongojack.JacksonDBCollection;

public class Indexer {
    private static ObjectMapper mapper = new ObjectMapper();

    public static void main(String[] args) {
        Mongo mongo = null;
        try {
            File[] filesToRead;
            mongo = new Mongo("172.17.0.2", 27017);
            DB db = mongo.getDB("annocultor_db");
            JacksonDBCollection pColl = JacksonDBCollection.wrap((DBCollection)db.getCollection("place"), MongoTerm.class, String.class);
            JacksonDBCollection wrapperColl = JacksonDBCollection.wrap((DBCollection)db.getCollection("TermList"), PlaceTermList.class, String.class);
            wrapperColl.createIndex((DBObject)new BasicDBObject("codeUri", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
            wrapperColl.createIndex((DBObject)new BasicDBObject("owlSameAs", (Object)1), (DBObject)new BasicDBObject("unique", (Object)false));
            pColl.createIndex((DBObject)new BasicDBObject("codeUri", (Object)1), (DBObject)new BasicDBObject("unique", (Object)false));
            pColl.createIndex((DBObject)new BasicDBObject("label", (Object)1), (DBObject)new BasicDBObject("unique", (Object)false));
            pColl.createIndex((DBObject)new BasicDBObject("lang", (Object)1), (DBObject)new BasicDBObject("unique", (Object)false));
            for (File file : filesToRead = new File("/home/ymamakis/git/tools/annocultor_solr3.5/converters/geonames/input_source/").listFiles()) {
                File[] childrenFiles;
                if (file.getName().endsWith("edm")) {
                    Indexer.readFileToDB((JacksonDBCollection<PlaceTermList, String>)wrapperColl, pColl, file);
                    System.out.println("Finished " + file.getName());
                }
                if (!file.isDirectory() || !file.getName().contains("EU")) continue;
                for (File child : childrenFiles = file.listFiles()) {
                    if (!child.getName().endsWith("edm")) continue;
                    Indexer.readFileToDB((JacksonDBCollection<PlaceTermList, String>)wrapperColl, pColl, child);
                    System.out.println("Finished " + file.getName());
                }
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void readFileToDB(JacksonDBCollection<PlaceTermList, String> wrapperColl, JacksonDBCollection pColl, File child) throws IOException {
        List placesToPersist = IOUtils.readLines((InputStream)new FileInputStream(child));
        for (String placeString : placesToPersist) {
            PlaceImpl place = (PlaceImpl)mapper.readValue(placeString.getBytes(), PlaceImpl.class);
            PlaceTermList placeTermList = new PlaceTermList();
            placeTermList.setRepresentation(place);
            placeTermList.setEntityType(PlaceImpl.class.getSimpleName());
            placeTermList.setCodeUri(place.getAbout());
            if (place.getIsPartOf() != null && place.getIsPartOf().get("def") != null) {
                placeTermList.setParent((String)((List)place.getIsPartOf().get("def")).get(0));
            }
            if (place.getOwlSameAs() != null) {
                placeTermList.setOwlSameAs(place.getOwlSameAs());
            }
            wrapperColl.save((Object)placeTermList);
            Map termsToPersist = place.getPrefLabel();
            for (Map.Entry entry : termsToPersist.entrySet()) {
                String key = (String)entry.getKey();
                for (String value : (List)entry.getValue()) {
                    MongoTerm term = new MongoTerm();
                    term.setCodeUri(place.getAbout());
                    term.setLang(StringUtils.isNotEmpty((CharSequence)key) ? key : "def");
                    term.setOriginalLabel(value);
                    term.setLabel(value.toLowerCase());
                    pColl.save((Object)term);
                }
            }
        }
    }
}

