/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.harvester.freebase;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import eu.europeana.enrichment.harvester.database.DataManager;
import eu.europeana.enrichment.harvester.transform.edm.agent.AgentTransformer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FreeBaseCollector {
    private static final Logger log = Logger.getLogger(FreeBaseCollector.class.getName());
    private final DataManager dm = new DataManager();
    private String agentKey = "";
    private int gloffset = 0;

    public static void main(String[] args) {
        FreeBaseCollector dbpc = new FreeBaseCollector();
        dbpc.getAgents();
    }

    public void getAgents() {
        int resultsize = 1000;
        int limit = 1000;
        int offset = 0;
        while (resultsize > 0) {
            List<String> agents = this.dm.extractFreebaseAgentsFromLocalStorage(limit, offset);
            resultsize = agents.size();
            for (String string : agents) {
            }
            if (agents.size() <= 0) continue;
            this.gloffset = offset += limit;
        }
    }

    private void testHarvesting() {
        this.dm.addSameAs("http://dbpedia.org/resource/Giovanni_Fattori", "http://de.dbpedia.org/resource/Giovanni_Fattori");
    }

    private void collectAndMapControlledData(String key) {
        if (key.equalsIgnoreCase("http://rdf.freebase.com/ns/m.0dsryz")) {
            return;
        }
        if (key.equalsIgnoreCase("http://rdf.freebase.com/ns/m.07y4pk")) {
            return;
        }
        if (key.equalsIgnoreCase("http://rdf.freebase.com/ns/m.0d31bv")) {
            return;
        }
        if (key.equalsIgnoreCase("http://rdf.freebase.com/ns/m.0gh62v6")) {
            return;
        }
        if (key.equalsIgnoreCase("http://rdf.freebase.com/ns/m.04zxtgs")) {
            return;
        }
        if (key.equalsIgnoreCase("http://rdf.freebase.com/ns/m.04q6hyw")) {
            return;
        }
        if (key.equalsIgnoreCase("http://rdf.freebase.com/ns/m.03m4w0t")) {
            return;
        }
        if (key.equalsIgnoreCase("http://rdf.freebase.com/ns/m.0g56rkv")) {
            return;
        }
        QueryEngineHTTP endpoint = new QueryEngineHTTP("http://localhost:3030/tdb/query", "describe <" + key + ">");
        log.log(Level.INFO, "describing " + key + " offset: " + this.gloffset);
        this.agentKey = key;
        Model model = ModelFactory.createDefaultModel();
        try {
            model = endpoint.execDescribe();
        }
        catch (Exception he) {
            System.out.println(he);
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RDFWriter writer = model.getWriter("RDF/XML");
        writer.setProperty("allowBadURIs", (Object)"true");
        writer.write(model, (OutputStream)baos, null);
        StreamSource inputDoc = new StreamSource(new ByteArrayInputStream(baos.toByteArray()));
        this.dm.insertAgent(new AgentTransformer().transform("src/main/resources/freebase.xsl", key, inputDoc));
        System.out.println("done");
    }

    private HashMap<String, List<String>> getAgentProperty(String tag, String alternativeTag, Document doc) {
        HashMap<String, List<String>> myM = new HashMap<String, List<String>>();
        String logTag = tag;
        NodeList nodeList = doc.getElementsByTagName(tag);
        if (nodeList.getLength() == 0 && alternativeTag != null) {
            nodeList = doc.getElementsByTagName(alternativeTag);
            logTag = alternativeTag;
        }
        String lang = "def";
        if (nodeList.getLength() > 0) {
            log.info(logTag + " (" + nodeList.getLength() + ")");
        }
        for (int temp = 0; temp < nodeList.getLength(); ++temp) {
            Node nNode = nodeList.item(temp);
            if (nNode.getNodeType() == 1 && nNode.hasChildNodes()) {
                NamedNodeMap nnm = nNode.getAttributes();
                Node langAtt = nnm.getNamedItem("xml:lang");
                if (langAtt != null && langAtt.hasChildNodes()) {
                    lang = langAtt.getFirstChild().getNodeValue();
                }
                if (!myM.containsKey(lang)) {
                    ArrayList<String> date = new ArrayList<String>();
                    date.add(nNode.getFirstChild().getNodeValue());
                    myM.put(lang, date);
                } else {
                    myM.get(lang).add(nNode.getFirstChild().getNodeValue());
                }
                log.log(Level.SEVERE, "  " + lang + ", " + nNode.getFirstChild().getNodeValue());
                continue;
            }
            if (nNode.getNodeType() != 1) continue;
            ArrayList<String> attrName = new ArrayList<String>();
            attrName.add("rdf:resource");
            List<String> attrValues = this.getElementResourceAttribute(nNode, attrName);
            if (attrValues.size() <= 0) continue;
            log.log(Level.INFO, lang + ", " + attrValues.toString());
            if (!myM.containsKey(lang)) {
                myM.put(lang, attrValues);
                continue;
            }
            myM.get(lang).addAll(attrValues);
        }
        return myM;
    }

    private void inferFromDumpDB() {
        String directory = "/home/cesare/freebase/testdump";
        System.out.println("dump dir " + directory);
        Dataset dataset = TDBFactory.createDataset((String)directory);
        Model tdbModel = dataset.getDefaultModel();
        String ns = "http://rdf.freebase.com/ns/";
        Property p = tdbModel.createProperty(ns, "person.profession.specialization_of");
        Property q = tdbModel.createProperty(ns, "person.profession.specialization_of_transitive");
        Reasoner reasoner = ReasonerRegistry.getOWLMicroReasoner();
        InfModel infTDB = ModelFactory.createInfModel((Reasoner)reasoner, (Model)tdbModel);
        infTDB.add((Resource)p, RDFS.subPropertyOf, (RDFNode)q);
        infTDB.add((Resource)q, RDF.type, (RDFNode)OWL.TransitiveProperty);
        infTDB.setDerivationLogging(true);
        Model test = infTDB.getDeductionsModel();
        System.out.println("created... ");
        String queryString = "PREFIX ns:<http://rdf.freebase.com/ns/>  SELECT (count (distinct ?x) as ?count) WHERE {{?x ns:type.object.type ns:visual_art.visual_artist} UNION { ?x ns:type.object.type ns:book.author } UNION { ?x ns:type.object.type ns:music.composer } UNION { ?x ns:people.person.profession ns:m.0kyk } UNION { ?x ns:people.person.profession ns:m.0n1h } UNION { ?x ns:people.person.profession ?role . ?role ns:person.profession.specialization_of_transitive ns:m.0n1h} UNION { ?x ns:people.person.profession ns:m.0mn6 } UNION { ?x ns:people.person.profession ns:m.0b7b55p }} LIMIT 5";
        System.out.println("query... ");
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)infTDB);
        ResultSet results = qexec.execSelect();
        ResultSetFormatter.out((ResultSet)results);
    }

    private void checkDumpDB() {
        String directory = "/home/cesare/freebase/testdump";
        System.out.println("dir: " + directory);
        Dataset dataset = TDBFactory.createDataset((String)directory);
        Model tdbModel = dataset.getDefaultModel();
        String queryString = "PREFIX ns:<http://rdf.freebase.com/ns/>  SELECT * WHERE {?x ns:people.person.profession ns:m.0b7b55p . ?x ns:type.object.name ?subject .}";
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
        ResultSet results = qexec.execSelect();
        ResultSetFormatter.out((ResultSet)results);
    }

    private String[] getAgentResource(String tag, String alternativeTag, List<String> attributes, Document doc) {
        NodeList nodeList = doc.getElementsByTagName(tag);
        ArrayList<String> result = new ArrayList<String>();
        if (nodeList.getLength() == 0 && alternativeTag != null) {
            nodeList = doc.getElementsByTagName(alternativeTag);
        }
        log.log(Level.INFO, tag + "  (" + nodeList.getLength() + ", duplicates will be removed)");
        for (int temp = 0; temp < nodeList.getLength(); ++temp) {
            Node nNode = nodeList.item(temp);
            if (nNode.getNodeType() != 1) continue;
            NamedNodeMap nnm = nNode.getAttributes();
            for (String atts : attributes) {
                Node attValue = nnm.getNamedItem(atts);
                if (attValue == null || !attValue.hasChildNodes() || result.contains(attValue.getFirstChild().getNodeValue())) continue;
                result.add(attValue.getFirstChild().getNodeValue());
                log.log(Level.INFO, attValue.getFirstChild().getNodeValue());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private List<String> getElementResourceAttribute(Node nNode, List<String> attributes) {
        ArrayList<String> result = new ArrayList<String>();
        if (nNode.getNodeType() == 1) {
            NamedNodeMap nnm = nNode.getAttributes();
            for (String atts : attributes) {
                Node attValue = nnm.getNamedItem(atts);
                if (attValue == null || !attValue.hasChildNodes()) continue;
                String attribStr = attValue.getFirstChild().getNodeValue();
                if (!attribStr.trim().equalsIgnoreCase(this.agentKey)) {
                    result.add(attValue.getFirstChild().getNodeValue());
                    continue;
                }
                Node tmpNode = nNode.getParentNode();
                nnm = tmpNode.getAttributes();
                Node parentAttValue = nnm.getNamedItem("rdf:about");
                if (parentAttValue == null || !attValue.hasChildNodes()) continue;
                result.add(parentAttValue.getFirstChild().getNodeValue());
            }
        }
        return result;
    }
}

