/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.harvester.dbpedia;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class DbPediaDumpsCollector {
    public static void main(String[] args) {
        DbPediaDumpsCollector dbpc = new DbPediaDumpsCollector();
        dbpc.harvestDBPediaDumps();
    }

    public void harvestDBPediaDumps() {
        File file = new File("src/main/resources/dbpedia_dump_list.txt");
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("http://data")) continue;
                this.collectControlledDumps(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void collectControlledDumps(String dumpResource) {
        try {
            URL website = new URL(dumpResource);
            ReadableByteChannel rbc = Channels.newChannel(website.openStream());
            FileOutputStream fos = new FileOutputStream("src/main/resources/dbpediadumps/" + dumpResource.substring(dumpResource.lastIndexOf(47)));
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

