/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.harvester.dbpedia;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import eu.europeana.corelib.solr.entity.AgentImpl;
import eu.europeana.enrichment.converters.ContextualEntityToXmlConverter;
import eu.europeana.enrichment.harvester.api.AgentMap;
import eu.europeana.enrichment.harvester.database.DataManager;
import eu.europeana.enrichment.harvester.transform.edm.agent.AgentTransformer;
import eu.europeana.enrichment.harvester.transform.edm.concept.ConceptTransformer;
import eu.europeana.enrichment.harvester.util.MongoDataSerializer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DbPediaCollector {
    private static final Logger log = Logger.getLogger(DbPediaCollector.class.getName());
    private static final String AGENT = "Agent";
    private static final String CONCEPT = "Concept";
    private static String CONCEPT_LIST_PATH = "src/main/resources/dbpedia_concepts_list_15072015.txt";
    private final DataManager dm = new DataManager();
    private String agentKey = "";
    private Model model = ModelFactory.createDefaultModel();
    private QueryEngineHTTP endpoint;
    MongoDataSerializer ds = new MongoDataSerializer();
    DocumentBuilderFactory icFactory = DocumentBuilderFactory.newInstance();
    DocumentBuilder icBuilder;
    private int gloffset = 0;

    public static void main(String[] args) {
        DbPediaCollector dbpc = new DbPediaCollector();
        dbpc.printDbPediaAgents();
    }

    public void harvestDBPedia() {
        int resultsize = 1000;
        int limit = 1000;
        int offset = 178900;
        while (resultsize == limit) {
            List<AgentMap> agents = this.dm.extractAllAgentsFromLocalStorage(limit, offset);
            resultsize = agents.size();
            for (AgentMap am : agents) {
                if (!am.getAgentUri().toASCIIString().contains("dbpedia.org")) continue;
                try {
                    this.collectAndMapControlledData(URLDecoder.decode(am.getAgentUri().toASCIIString(), "UTF-8"), AGENT);
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println("Error " + e);
                }
            }
            if (agents.size() != limit) continue;
            this.gloffset = offset += limit;
            System.out.println("Offset " + offset);
        }
    }

    public void harvestDBPediaConcepts() {
        File file = new File(CONCEPT_LIST_PATH);
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("http://dbpedia")) continue;
                this.collectAndMapControlledData(line, CONCEPT);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void deleteDBPediaConcepts() {
        File file = new File(CONCEPT_LIST_PATH);
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("http://dbpedia")) continue;
                this.dm.deleteConcept(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void getDBPediaConcepts() {
        File file = new File(CONCEPT_LIST_PATH);
        String id = "";
        ContextualEntityToXmlConverter myXMLConverter = new ContextualEntityToXmlConverter();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("http://dbpedia")) continue;
                id = line;
                if (line == null || line.isEmpty()) continue;
            }
        }
        catch (Exception e) {
            System.out.println(id);
            e.printStackTrace();
        }
    }

    public void printLocalDbPediaAgents(String locale) {
        int resultsize = 1000;
        int limit = 1000;
        int offset = 0;
        BufferedWriter writer = null;
        try {
            this.icBuilder = this.icFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("not_in_live_dbpedia.txt"), "utf-8"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        Document doc = this.icBuilder.newDocument();
        Element mainRootElement = this.createMainRootElement(doc);
        while (resultsize > 0) {
            List<String> agents = this.dm.ecxtractLocalizedDbPediaAgentsFromLocalStorage(locale, limit, offset);
            for (String aid : agents) {
                AgentImpl agent = this.dm.getAgent(aid);
                if (agent != null && agent.getAbout() != null) {
                    Node agentElement = this.ds.serializeAgentsAsStored(doc, agent);
                    if (agentElement == null) continue;
                    mainRootElement.appendChild(agentElement);
                    System.out.println(">>>>>>>>>>>>ADDED!!!");
                    continue;
                }
                try {
                    writer.write(aid + "\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                log.warning("Not in the db " + aid);
            }
            resultsize = agents.size();
            if (agents.size() <= 0) continue;
            this.gloffset = offset += limit;
        }
        this.printXmlDocument(doc, "live_" + locale + "_storedagents.xml");
    }

    public void printDbPediaAgents() {
        String id = "";
        int resultsize = 1000;
        int limit = 1000;
        int offset = 0;
        try {
            this.icBuilder = this.icFactory.newDocumentBuilder();
            Document doc = this.icBuilder.newDocument();
            Element mainRootElement = doc.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:RDF");
            mainRootElement.setAttribute("xmlns:skos", "http://www.w3.org/2004/02/skos/core#");
            mainRootElement.setAttribute("xmlns:rdaGr2", "http://RDVocab.info/ElementsGr2/");
            mainRootElement.setAttribute("xmlns:foaf", "http://xmlns.com/foaf/0.1/");
            mainRootElement.setAttribute("xmlns:owl", "http://www.w3.org/2002/07/owl#");
            mainRootElement.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
            mainRootElement.setAttribute("xmlns:edm", "http://www.europeana.eu/schemas/edm/");
            doc.appendChild(mainRootElement);
            while (resultsize > 0) {
                List<AgentMap> agents = this.dm.extractAllAgentsFromLocalStorage(limit, offset);
                for (AgentMap auri : agents) {
                    Node conceptElement;
                    if (!URLDecoder.decode(auri.getAgentUri().toASCIIString(), "UTF-8").startsWith("http://dbpedia.org/resource")) continue;
                    String aid = URLDecoder.decode(auri.getAgentUri().toASCIIString(), "UTF-8");
                    if (aid.equals("http://dbpedia.org/resource/\u00d8rjan_Nilsen")) {
                        System.out.println("eccolo");
                    }
                    if (this.dm.getAgent(aid) == null || (conceptElement = this.ds.serializeAgentsAsStored(doc, this.dm.getAgent(aid))) == null) continue;
                    mainRootElement.appendChild(conceptElement);
                }
                resultsize = agents.size();
                if (agents.size() <= 0) continue;
                this.gloffset = offset += limit;
            }
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(new File("localstoredagents.xml"));
                transformer.transform(source, result);
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            System.out.println(id);
            e.printStackTrace();
        }
    }

    public void printDBPediaConcepts() {
        File file = new File(CONCEPT_LIST_PATH);
        String id = "";
        ContextualEntityToXmlConverter myXMLConverter = new ContextualEntityToXmlConverter();
        MongoDataSerializer ds = new MongoDataSerializer();
        DocumentBuilderFactory icFactory = DocumentBuilderFactory.newInstance();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            DocumentBuilder icBuilder = icFactory.newDocumentBuilder();
            Document doc = icBuilder.newDocument();
            Element mainRootElement = doc.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:RDF");
            mainRootElement.setAttribute("xmlns:skos", "http://www.w3.org/2004/02/skos/core#");
            doc.appendChild(mainRootElement);
            HashSet<String> conceptsSet = new HashSet<String>();
            while ((line = br.readLine()) != null) {
                if (line == null || !line.trim().startsWith("http://dbpedia")) continue;
                conceptsSet.add(line);
            }
            for (String concept : conceptsSet) {
                Node conceptElement;
                if (this.dm.getConcept(concept) == null || (conceptElement = ds.serializeConcept(doc, this.dm.getConcept(concept))) == null) continue;
                mainRootElement.appendChild(conceptElement);
            }
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(new File("storeddbpediaconcepts.xml"));
                transformer.transform(source, result);
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            System.out.println(id);
            e.printStackTrace();
        }
    }

    private String cleanString(String str) {
        str = str.replace("&lt;", "");
        str = str.replace("/&gt;", "");
        str = str.replace("&gt;", "");
        return str;
    }

    private void testHarvesting() {
        this.collectAndMapControlledData("http://dbpedia.org/resource/\u00d8rjan_Nilsen", AGENT);
    }

    public void getLocalAgents(String locale, boolean live) {
        int resultsize = 1000;
        int limit = 1000;
        int offset = 0;
        if (live) {
            locale = "live." + locale;
        }
        while (resultsize > 0) {
            List<String> agents = this.dm.ecxtractLocalizedDbPediaAgentsFromLocalStorage(locale, limit, offset);
            for (String am : agents) {
                this.collectAndMapLocalControlledData(locale, am, AGENT);
            }
            resultsize = agents.size();
            if (agents.size() <= 0) continue;
            this.gloffset = offset += limit;
        }
    }

    private void collectAndMapControlledData(String key, String entity) {
        if (key.contains("\"")) {
            return;
        }
        if (key.endsWith("Charles_Hamilton_(rapper)") || key.endsWith("M\u00e9tisArtists") || key.endsWith("M\u00e9tisPerformanceArtists")) {
            return;
        }
        if (key.endsWith("Johannes_Liechtenauer") || key.endsWith("Hasan_Cihat_\u00d6rter") || key.endsWith("A _(rapper)")) {
            return;
        }
        if (key.endsWith("Thomas_Negovan") || key.endsWith("Szibilla_Marg\u00f3_Bak\u00f3") || key.endsWith("Var\u00e8seSarabandeArtists")) {
            return;
        }
        if (key.endsWith("Paulo_Henrique_(choreographer)") || key.endsWith("Bo\u0161ko_Radi\u0161i\u0107_(RNA)") || key.endsWith("Inti Quila")) {
            return;
        }
        if (key.endsWith("Roman_Dragoun") || key.endsWith("Wu_Ching_(\u5433\u537f)") || key.endsWith("Steve,_Righ?")) {
            return;
        }
        if (key.endsWith("Glen_Burtnik") || key.endsWith("Paulus_Sch\u00e4fer") || key.endsWith("M\u00e9tisInstallationArtists")) {
            return;
        }
        if (key.endsWith("Michael_J._Carrasquillo") || key.endsWith("Paul_Young_(Mike_ _The_Mechanics)") || key.endsWith("DJ_Clue?")) {
            return;
        }
        if (key.endsWith("Paulus_Sch%C3%A4fer") || key.endsWith("Luciano_Azevedo") || key.endsWith("NouveauR\u00e9alismeArtists")) {
            return;
        }
        if (key.endsWith("Dave_Kellett") || key.endsWith("Walter_Bubl\u00e9") || key.endsWith("Dalziel_ _Scullion")) {
            return;
        }
        if (key.endsWith("Steffen_Thomas") || key.endsWith("Richard_Evans_(artist)") || key.endsWith("Abdul_Vaheed_`Kamal'")) {
            return;
        }
        if (key.endsWith("Kaya_Jones") || key.endsWith("K-the-I???") || key.endsWith("B\u00e9la_Nagy_Abodi")) {
            return;
        }
        if (key.endsWith("Daniel_Kerr_(fighter)") || key.endsWith("Peter_Connelly") || key.endsWith("C C_Music_Factory")) {
            return;
        }
        if (key.endsWith("Yevgeny_Zamyatin") || key.endsWith("Richard_Evans") || key.endsWith("Abu_Nu`aym")) {
            return;
        }
        if (key.endsWith("Hasan_Cihat_%C3%96rter") || key.endsWith("Laure_Conan") || key.endsWith("Prikosnov\u00e9nieArtists")) {
            return;
        }
        if (key.endsWith("Paul_Poovathingal") || key.endsWith("Zafer_Aracag\u00f6k") || key.endsWith("Imakuni?")) {
            return;
        }
        if (key.endsWith("Murray_Leinster") || key.endsWith("Jards_Macal%C3%A9")) {
            return;
        }
        if (key.endsWith("Oliver_Onions") || key.endsWith("J%C3%BCrgen_Schmitt__Germany-composer-stub__1")) {
            return;
        }
        if (key.endsWith("Jonathan_Emile") || key.endsWith("Anita_%C3%81lvarez_de_Williams__US-photographer-stub__1")) {
            return;
        }
        if (key.endsWith("Jah_Paul_Jo") || key.endsWith("Kate_Lambert")) {
            return;
        }
        if (key.endsWith("Kevontay_Jackson") || key.endsWith("Judy_Carter")) {
            return;
        }
        if (key.endsWith("Kryz_Reid") || key.endsWith("Sara_Mayhew")) {
            return;
        }
        if (key.endsWith("Adam_Deitch") || key.endsWith("Jim_Klein")) {
            return;
        }
        if (key.endsWith("Davide_Carbone") || key.endsWith("B%C3%A9la_Nagy_Abodi")) {
            return;
        }
        if (key.endsWith("Marci_Geller") || key.endsWith("Kirk_Reeves")) {
            return;
        }
        if (key.endsWith("Lars_Lilholt") || key.endsWith("James_Mylne_(artist)")) {
            return;
        }
        if (key.endsWith("Gurdas_Maan") || key.endsWith("Redfoo")) {
            return;
        }
        if (key.endsWith("Greg_Williamson_(drummer)") || key.endsWith("Chris_Ryall")) {
            return;
        }
        if (key.endsWith("Mr._Fastfinger") || key.endsWith("Richard_Blanco")) {
            return;
        }
        if (key.endsWith("Casey_Dunmore") || key.endsWith("Muyiwa_Olarewaju")) {
            return;
        }
        if (key.endsWith("Thandiswa_Mazwai") || key.endsWith("Olivier_Chastan")) {
            return;
        }
        if (key.endsWith("Carolus-Duran") || key.endsWith("Sam_Young_(DJ)")) {
            return;
        }
        if (key.endsWith("Ian_Maclaren") || key.endsWith("Chris_Kuzneski")) {
            return;
        }
        if (key.endsWith("David_Bazan") || key.endsWith("Jonathan_Leong")) {
            return;
        }
        if (key.endsWith("John_Strange_Winter") || key.endsWith("Christine_Tobin")) {
            return;
        }
        QueryEngineHTTP endpoint = new QueryEngineHTTP("http://localhost:3031/tdbdb/query", "describe <" + key.trim() + ">");
        this.agentKey = key;
        this.model = endpoint.execDescribe();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RDFWriter writer = this.model.getWriter("RDF/XML");
        writer.setProperty("allowBadURIs", (Object)"true");
        writer.write(this.model, (OutputStream)baos, null);
        StreamSource inputDoc = new StreamSource(new ByteArrayInputStream(baos.toByteArray()));
        if (entity.equals(AGENT)) {
            this.dm.insertAgent(new AgentTransformer().transform("src/main/resources/dbpedia2agent.xsl", key, inputDoc));
        }
        if (entity.equals(CONCEPT)) {
            this.dm.insertConcept(new ConceptTransformer().transform("src/main/resources/dbpedia_skos_concepts.xsl", key, inputDoc));
        }
    }

    private void collectAndMapLocalControlledData(String localPrefix, String key, String entity) {
        if (key.endsWith("Charles_Hamilton_(rapper)")) {
            return;
        }
        if (key.endsWith("Johannes_Liechtenauer")) {
            return;
        }
        if (key.endsWith("resource/Francesco_Racanelli")) {
            return;
        }
        String sparqlEndPoint = "http://" + localPrefix + ".dbpedia.org/sparql";
        this.endpoint = new QueryEngineHTTP(sparqlEndPoint, "describe <" + key + ">");
        log.log(Level.INFO, "describing " + key + " offset: " + this.gloffset);
        this.agentKey = key;
        this.model = this.endpoint.execDescribe();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RDFWriter writer = this.model.getWriter("RDF/XML");
        writer.setProperty("allowBadURIs", (Object)"true");
        writer.write(this.model, (OutputStream)baos, null);
        StreamSource inputDoc = new StreamSource(new ByteArrayInputStream(baos.toByteArray()));
        if (entity.equals(AGENT)) {
            this.dm.insertAgent(new AgentTransformer().transform("src/main/resources/dbpedia.xsl", key, inputDoc));
        }
        if (entity.equals(CONCEPT)) {
            this.dm.insertConcept(new ConceptTransformer().transform("src/main/resources/dbpedia_skos_concepts.xsl", key, inputDoc));
        }
    }

    private HashMap<String, List<String>> getAgentProperty(String tag, String alternativeTag, Document doc) {
        HashMap<String, List<String>> myM = new HashMap<String, List<String>>();
        String logTag = tag;
        NodeList nodeList = doc.getElementsByTagName(tag);
        if (nodeList.getLength() == 0 && alternativeTag != null) {
            nodeList = doc.getElementsByTagName(alternativeTag);
            logTag = alternativeTag;
        }
        String lang = "def";
        if (nodeList.getLength() > 0) {
            log.info(logTag + " (" + nodeList.getLength() + ")");
        }
        for (int temp = 0; temp < nodeList.getLength(); ++temp) {
            Node nNode = nodeList.item(temp);
            if (nNode.getNodeType() == 1 && nNode.hasChildNodes()) {
                NamedNodeMap nnm = nNode.getAttributes();
                Node langAtt = nnm.getNamedItem("xml:lang");
                if (langAtt != null && langAtt.hasChildNodes()) {
                    lang = langAtt.getFirstChild().getNodeValue();
                }
                if (!myM.containsKey(lang)) {
                    ArrayList<String> date = new ArrayList<String>();
                    date.add(nNode.getFirstChild().getNodeValue());
                    myM.put(lang, date);
                } else {
                    myM.get(lang).add(nNode.getFirstChild().getNodeValue());
                }
                log.log(Level.SEVERE, "  " + lang + ", " + nNode.getFirstChild().getNodeValue());
                continue;
            }
            if (nNode.getNodeType() != 1) continue;
            ArrayList<String> attrName = new ArrayList<String>();
            attrName.add("rdf:resource");
            List<String> attrValues = this.getElementResourceAttribute(nNode, attrName);
            if (attrValues.size() <= 0) continue;
            log.log(Level.INFO, lang + ", " + attrValues.toString());
            if (!myM.containsKey(lang)) {
                myM.put(lang, attrValues);
                continue;
            }
            myM.get(lang).addAll(attrValues);
        }
        return myM;
    }

    private String[] getAgentResource(String tag, String alternativeTag, List<String> attributes, Document doc) {
        NodeList nodeList = doc.getElementsByTagName(tag);
        ArrayList<String> result = new ArrayList<String>();
        if (nodeList.getLength() == 0 && alternativeTag != null) {
            nodeList = doc.getElementsByTagName(alternativeTag);
        }
        log.log(Level.INFO, tag + "  (" + nodeList.getLength() + ", duplicates will be removed)");
        for (int temp = 0; temp < nodeList.getLength(); ++temp) {
            Node nNode = nodeList.item(temp);
            if (nNode.getNodeType() != 1) continue;
            NamedNodeMap nnm = nNode.getAttributes();
            for (String atts : attributes) {
                Node attValue = nnm.getNamedItem(atts);
                if (attValue == null || !attValue.hasChildNodes() || result.contains(attValue.getFirstChild().getNodeValue())) continue;
                result.add(attValue.getFirstChild().getNodeValue());
                log.log(Level.INFO, attValue.getFirstChild().getNodeValue());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private List<String> getElementResourceAttribute(Node nNode, List<String> attributes) {
        ArrayList<String> result = new ArrayList<String>();
        if (nNode.getNodeType() == 1) {
            NamedNodeMap nnm = nNode.getAttributes();
            for (String atts : attributes) {
                Node attValue = nnm.getNamedItem(atts);
                if (attValue == null || !attValue.hasChildNodes()) continue;
                String attribStr = attValue.getFirstChild().getNodeValue();
                if (!attribStr.trim().equalsIgnoreCase(this.agentKey)) {
                    result.add(attValue.getFirstChild().getNodeValue());
                    continue;
                }
                Node tmpNode = nNode.getParentNode();
                nnm = tmpNode.getAttributes();
                Node parentAttValue = nnm.getNamedItem("rdf:about");
                if (parentAttValue == null || !attValue.hasChildNodes()) continue;
                result.add(parentAttValue.getFirstChild().getNodeValue());
            }
        }
        return result;
    }

    private Element createMainRootElement(Document doc) {
        Element mainRootElement = doc.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:RDF");
        mainRootElement.setAttribute("xmlns:skos", "http://www.w3.org/2002/02/skos/core#");
        mainRootElement.setAttribute("xmlns:rdaGr2", "http://RDVocab.info/ElementsGr2/");
        mainRootElement.setAttribute("xmlns:foaf", "http://xmlns.com/foaf/0.1/");
        mainRootElement.setAttribute("xmlns:owl", "http://www.w3.org/2002/07/owl#");
        mainRootElement.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        mainRootElement.setAttribute("xmlns:edm", "http://www.europeana.eu/schemas/edm/");
        doc.appendChild(mainRootElement);
        return mainRootElement;
    }

    private void printXmlDocument(Document doc, String name) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(name));
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

