/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.harvester.database;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.Morphia;
import com.google.code.morphia.query.Query;
import com.google.code.morphia.query.UpdateOperations;
import com.google.code.morphia.query.UpdateResults;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.util.JSON;
import eu.europeana.corelib.solr.entity.AgentImpl;
import eu.europeana.corelib.solr.entity.ConceptImpl;
import eu.europeana.enrichment.api.internal.AgentTermList;
import eu.europeana.enrichment.api.internal.ConceptTermList;
import eu.europeana.enrichment.api.internal.MongoTerm;
import eu.europeana.enrichment.api.internal.PlaceTermList;
import eu.europeana.enrichment.api.internal.TimespanTermList;
import eu.europeana.enrichment.harvester.api.AgentMap;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jibx.runtime.JiBXException;
import org.mongojack.DBQuery;
import org.mongojack.DBRef;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class DataManager {
    private static final Logger log = Logger.getLogger(DataManager.class.getName());
    private static final String TERMLIST = "TermList";
    private static final String CONCEPTSTERMLIST = "TermList";
    private static final String CODEURI = "codeUri";
    private static JacksonDBCollection<AgentTermList, String> aColl;
    private static JacksonDBCollection<ConceptTermList, String> cColl;
    private static JacksonDBCollection<PlaceTermList, String> pColl;
    private static JacksonDBCollection<TimespanTermList, String> tColl;
    private static JacksonDBCollection<ConceptTermList, String> conceptsColl;
    private static DB db;
    private Datastore ds;
    private Datastore dsTL;
    private DBCollection coll;
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 27017;

    public DataManager() {
        this(DEFAULT_HOST, 27017);
    }

    public DataManager(String host, int port) {
        try {
            FileHandler fh = new FileHandler("test1_harvester.log");
            fh.setFormatter(new SimpleFormatter());
            log.addHandler(fh);
            this.dbExists(host, port);
            Mongo mongodb = new Mongo(host, port);
            this.ds = new Morphia().createDatastore(mongodb, "agentmap");
            this.ds.ensureIndexes();
            this.dsTL = new Morphia().createDatastore(mongodb, "annocultor_db");
            this.coll = db.getCollection("TermList");
        }
        catch (MongoException | IOException | SecurityException e) {
            log.log(Level.SEVERE, e.getMessage());
        }
    }

    public final boolean dbExists(String host, int port) {
        try {
            if (db == null) {
                Mongo mongo = new Mongo(host, port);
                db = mongo.getDB("annocultor_db");
                if (db.collectionExists("TermList")) {
                    cColl = JacksonDBCollection.wrap((DBCollection)db.getCollection("TermList"), ConceptTermList.class, String.class);
                    cColl.ensureIndex(CODEURI);
                    conceptsColl = JacksonDBCollection.wrap((DBCollection)db.getCollection("TermList"), ConceptTermList.class, String.class);
                    conceptsColl.ensureIndex(CODEURI);
                    aColl = JacksonDBCollection.wrap((DBCollection)db.getCollection("TermList"), AgentTermList.class, String.class);
                    aColl.ensureIndex(CODEURI);
                    tColl = JacksonDBCollection.wrap((DBCollection)db.getCollection("TermList"), TimespanTermList.class, String.class);
                    tColl.ensureIndex(CODEURI);
                    pColl = JacksonDBCollection.wrap((DBCollection)db.getCollection("TermList"), PlaceTermList.class, String.class);
                    pColl.ensureIndex(CODEURI);
                    return true;
                }
                cColl = JacksonDBCollection.wrap((DBCollection)db.getCollection("TermList"), ConceptTermList.class, String.class);
                cColl.ensureIndex(CODEURI);
                conceptsColl = JacksonDBCollection.wrap((DBCollection)db.getCollection("TermList"), ConceptTermList.class, String.class);
                conceptsColl.ensureIndex(CODEURI);
                aColl = JacksonDBCollection.wrap((DBCollection)db.getCollection("TermList"), AgentTermList.class, String.class);
                aColl.ensureIndex(CODEURI);
                tColl = JacksonDBCollection.wrap((DBCollection)db.getCollection("TermList"), TimespanTermList.class, String.class);
                tColl.ensureIndex(CODEURI);
                pColl = JacksonDBCollection.wrap((DBCollection)db.getCollection("TermList"), PlaceTermList.class, String.class);
                pColl.ensureIndex(CODEURI);
                return false;
            }
            return true;
        }
        catch (MongoException | UnknownHostException e) {
            log.log(Level.SEVERE, e.getMessage());
            return false;
        }
    }

    public void insertAgent(AgentImpl agent) {
        try {
            if (this.queryToFindAgentDescription(agent.getAbout())) {
                this.agentToAgentTermList(agent, true);
            }
        }
        catch (IOException | JiBXException e) {
            log.log(Level.SEVERE, e.getMessage());
        }
    }

    public void insertConcept(ConceptImpl concept) {
        try {
            if (concept.getAbout() != null && this.queryToFindConceptDescription(concept.getAbout().trim())) {
                this.conceptToConceptTermList(concept, true);
            } else {
                System.out.println(concept.getAbout() + ", not inserted!");
            }
        }
        catch (IOException | JiBXException e) {
            log.log(Level.SEVERE, e.getMessage());
        }
    }

    public void deleteConcept(String id) {
        try {
            if (!this.queryToFindConceptDescription(id.trim())) {
                this.removeTermList(id.trim());
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage());
        }
    }

    public void updateAgent(AgentImpl agent) {
        try {
            this.agentToAgentTermList(agent, false);
        }
        catch (IOException | JiBXException e) {
            log.log(Level.SEVERE, e.getMessage());
        }
    }

    public List<AgentMap> extractAllAgentsFromLocalStorage(int limit, int offset) {
        Query q = this.ds.createQuery(AgentMap.class);
        q.limit(limit).offset(offset);
        return q.asList();
    }

    public List<String> ecxtractLocalizedDbPediaAgentsFromLocalStorage(String local, int limit, int offset) {
        ArrayList<String> dbpLocalAgent = new ArrayList<String>();
        String stringPattern = local + ".dbpedia.org/";
        Pattern localizedUrl = Pattern.compile("/.*" + stringPattern + ".*/", 2);
        BasicDBObject query = new BasicDBObject("representation.owlSameAs", (Object)localizedUrl);
        DBCursor cursor = null;
        cursor = this.coll.find((DBObject)query).limit(limit).skip(offset);
        System.out.println(cursor.size() + ", " + offset);
        while (cursor.hasNext()) {
            BasicDBObject representation = (BasicDBObject)cursor.next().get("representation");
            BasicDBList owlsameas = (BasicDBList)representation.get("owlSameAs");
            String aboutAgent = (String)representation.get("about");
            for (String freebase : owlsameas) {
                if (!freebase.contains(stringPattern)) continue;
                dbpLocalAgent.add(freebase);
            }
        }
        return dbpLocalAgent;
    }

    public List<String> extractFreebaseAgentsFromLocalStorage(int limit, int offset) {
        ArrayList<String> fbAgent = new ArrayList<String>();
        Pattern freebaseUrl = Pattern.compile("/.*freebase.*/", 2);
        BasicDBObject query = new BasicDBObject("representation.owlSameAs", (Object)freebaseUrl);
        DBCursor cursor = null;
        cursor = this.coll.find((DBObject)query).limit(limit).skip(offset);
        while (cursor.hasNext()) {
            BasicDBObject representation = (BasicDBObject)cursor.next().get("representation");
            BasicDBList owlsameas = (BasicDBList)representation.get("owlSameAs");
            String aboutAgent = (String)representation.get("about");
            for (String freebase : owlsameas) {
                if (!freebase.contains("freebase")) continue;
                fbAgent.add(freebase);
            }
        }
        return fbAgent;
    }

    public boolean insertAgentMap(AgentMap agentMap) {
        if (this.queryToFindAgent(agentMap.getId()).countAll() > 0L) {
            return false;
        }
        log.log(Level.INFO, String.format("Saving map for: %s", agentMap.getAgentUri()));
        this.ds.save((Object)agentMap);
        return true;
    }

    private Query<AgentMap> queryToFindAgent(String id) {
        return (Query)this.ds.createQuery(AgentMap.class).field("id").equal((Object)id);
    }

    private boolean queryToFindAgentDescription(String id) {
        BasicDBObject query = new BasicDBObject(CODEURI, (Object)id);
        DBCursor cursor = null;
        cursor = this.coll.find((DBObject)query);
        Boolean res = cursor.count() == 0;
        cursor.close();
        return res;
    }

    private boolean queryToFindConceptDescription(String id) {
        BasicDBObject query = new BasicDBObject(CODEURI, (Object)id);
        DBCursor cursor = null;
        cursor = this.coll.find((DBObject)query);
        Boolean res = cursor.count() == 0;
        cursor.close();
        return res;
    }

    private void removeTermList(String id) {
        BasicDBObject query = new BasicDBObject(CODEURI, (Object)id);
        this.coll.remove((DBObject)query);
        db.getCollection("TermList").remove((DBObject)query);
    }

    public AgentImpl getAgent(String id) {
        System.out.println("****************************************************************************** " + id);
        try {
            BasicDBObject query = new BasicDBObject(CODEURI, (Object)id);
            if (aColl.find((DBObject)query).hasNext()) {
                AgentTermList aTL = (AgentTermList)aColl.find((DBObject)query).next();
                AgentImpl rAi = aTL.getRepresentation();
                return rAi;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public ConceptImpl getConcept(String id) {
        BasicDBObject query = new BasicDBObject(CODEURI, (Object)id);
        if (cColl.find((DBObject)query).hasNext()) {
            ConceptTermList aTL = (ConceptTermList)cColl.find((DBObject)query).next();
            ConceptImpl rAi = aTL.getRepresentation();
            return rAi;
        }
        return null;
    }

    public void harvested(String id) {
        Date now = new Date();
        UpdateOperations ops = this.ds.createUpdateOperations(AgentMap.class).set("harvestedDate", (Object)now);
        this.ds.update(this.queryToFindAgent(id), ops);
    }

    public void unsetSameAs(String id) {
        UpdateOperations ops = this.ds.createUpdateOperations(AgentMap.class).unset("sameAs");
        this.ds.update(this.queryToFindAgent(id), ops);
        System.out.println("Unset: " + id);
    }

    public void addSameAs(String id, String sameAs) {
        Query<AgentMap> qam = this.queryToFindAgent(id);
        UpdateOperations saops = this.ds.createUpdateOperations(AgentMap.class).add("sameAs", (Object)sameAs, false);
        UpdateResults ur = this.ds.updateFirst(this.queryToFindAgent(id), saops);
        if (ur.getUpdatedCount() == 0) {
            System.out.println("*********** OPS: " + id + " - " + sameAs + ", " + ur.getUpdatedCount());
        } else {
            System.out.println("set: " + sameAs);
        }
    }

    public void insertDocument(String jsonObject, String collectionName) {
        try {
            log.log(Level.INFO, "JSON parse ...");
            DBCollection collection = db.getCollection("MyCollection");
            DBObject dbObject = (DBObject)JSON.parse((String)jsonObject);
            collection.insert(new DBObject[]{dbObject});
        }
        catch (MongoException e) {
            log.log(Level.SEVERE, e.getMessage());
        }
    }

    private void agentToAgentTermList(AgentImpl agent, Boolean newAgent) throws IOException, JiBXException {
        AgentTermList termList = new AgentTermList();
        if (agent.getPrefLabel() == null || agent.getPrefLabel().entrySet().size() == 0) {
            System.out.println("********* agent prefl not inserted " + agent.getAbout() + " *********");
            return;
        }
        termList.setCodeUri(agent.getAbout());
        ArrayList<DBRef> pList = new ArrayList<DBRef>();
        for (Map.Entry prefLabel : agent.getPrefLabel().entrySet()) {
            for (String label : (List)prefLabel.getValue()) {
                MongoTerm pTerm = new MongoTerm();
                pTerm.setCodeUri(agent.getAbout());
                pTerm.setLabel(StringUtils.substringBefore((String)label.toLowerCase(), (String)"(").trim());
                String lang = (String)prefLabel.getKey();
                pTerm.setOriginalLabel(label);
                pTerm.setLang(lang);
                JacksonDBCollection pColl = JacksonDBCollection.wrap((DBCollection)db.getCollection("people"), MongoTerm.class, String.class);
                pColl.ensureIndex(CODEURI);
                pColl.ensureIndex("label");
                WriteResult res = pColl.insert((Object)pTerm);
                DBRef pTermRef = new DBRef((Object)((MongoTerm)res.getSavedObject()).getId(), "people");
                pList.add(pTermRef);
            }
        }
        termList.setTerms(pList);
        termList.setRepresentation(agent);
        termList.setEntityType(AgentImpl.class.getSimpleName());
        if (newAgent.booleanValue()) {
            aColl.insert((Object)termList);
        } else {
            DBQuery.Query atl = DBQuery.all((String)CODEURI, (Object[])new Object[]{agent.getAbout()});
            aColl.update(atl, (Object)termList);
        }
    }

    private void conceptToConceptTermList(ConceptImpl concept, Boolean newConcept) throws IOException, JiBXException {
        ConceptTermList termList = new ConceptTermList();
        if (concept.getPrefLabel() == null || concept.getPrefLabel().entrySet().size() == 0) {
            return;
        }
        termList.setCodeUri(concept.getAbout());
        ArrayList<DBRef> pList = new ArrayList<DBRef>();
        for (Map.Entry prefLabel : concept.getPrefLabel().entrySet()) {
            for (String label : (List)prefLabel.getValue()) {
                MongoTerm pTerm = new MongoTerm();
                pTerm.setCodeUri(concept.getAbout());
                pTerm.setLabel(label.toLowerCase());
                String lang = (String)prefLabel.getKey();
                pTerm.setOriginalLabel(label);
                pTerm.setLang(lang);
                JacksonDBCollection pColl = JacksonDBCollection.wrap((DBCollection)db.getCollection("concepts"), MongoTerm.class, String.class);
                pColl.ensureIndex(CODEURI);
                pColl.ensureIndex("label");
                WriteResult res = pColl.insert((Object)pTerm);
                DBRef pTermRef = new DBRef((Object)((MongoTerm)res.getSavedObject()).getId(), "concepts");
                pList.add(pTermRef);
            }
        }
        termList.setTerms(pList);
        termList.setRepresentation(concept);
        termList.setEntityType(ConceptImpl.class.getSimpleName());
        if (newConcept.booleanValue()) {
            cColl.insert((Object)termList);
        } else {
            DBQuery.Query all = DBQuery.all((String)CODEURI, (Object[])new Object[]{concept.getAbout()});
            cColl.update(all, (Object)termList);
        }
    }
}

