/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.downloads;

import eu.europeana.downloads.TurtleResponseParser;
import eu.europeana.downloads.ZipFileStatus;
import eu.europeana.oaipmh.model.Record;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZipUtility {
    private static final Logger LOG = LogManager.getLogger(ZipUtility.class);

    private ZipUtility() {
    }

    public static void writeInZip(ZipOutputStream zout, OutputStreamWriter writer, Record recordVal, String fileFormat) {
        try {
            zout.putNextEntry(new ZipEntry(ZipUtility.getEntryName((Record)recordVal, (String)fileFormat)));
            writer.write(ZipUtility.dataToWriteInZip((String)recordVal.getMetadata().getMetadata(), (String)fileFormat));
            writer.flush();
            zout.closeEntry();
        }
        catch (IOException e) {
            LOG.error("Error writing the zip entry", (Throwable)e);
        }
    }

    private static String dataToWriteInZip(String metadata, String fileFormat) {
        if (StringUtils.equals((CharSequence)fileFormat, (CharSequence)"TTL")) {
            return TurtleResponseParser.generateTurtle((String)metadata);
        }
        return metadata;
    }

    private static String getEntryName(Record recordVal, String fileExtension) {
        String id = recordVal.getHeader().getIdentifier();
        if (StringUtils.equals((CharSequence)fileExtension, (CharSequence)"TTL")) {
            return StringUtils.substringAfterLast((String)id, (String)"/") + ".ttl";
        }
        return StringUtils.substringAfterLast((String)id, (String)"/") + ".xml";
    }

    public static String getDirectoryName(String identifier) {
        String id = StringUtils.remove((String)identifier, (String)"http://data.europeana.eu/item/");
        return id.split("/")[0];
    }

    public static void createMD5SumFile(String filename) {
        ZipUtility.createMD5SumFile((String)filename, (String)filename);
    }

    public static void createMD5SumFile(String sourceFolder, String destinationFolder) {
        try (BufferedWriter out = new BufferedWriter(new FileWriter(destinationFolder + ".md5sum"));){
            String checksum = ZipUtility.getMD5Sum((String)sourceFolder);
            out.write(checksum + "\n");
        }
        catch (IOException e) {
            LOG.error("Error creating MD5Sum file", (Throwable)e);
        }
    }

    private static String getMD5Sum(String file) {
        String checksum = null;
        try (FileInputStream is = new FileInputStream(new File(file));){
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = ((InputStream)is).read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            checksum = bigInt.toString(16);
        }
        catch (IOException e) {
            LOG.error("Unable to process file for MD5", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Error while generating MD5", (Throwable)e);
        }
        return checksum;
    }

    public static long getNumberOfEntriesInZip(String path, String zipName) {
        long l;
        ZipFile zipFile = new ZipFile(path + "/" + zipName);
        try {
            l = zipFile.size();
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("Error reading the zip file {}", (Object)zipName, (Object)e);
                return 0L;
            }
        }
        zipFile.close();
        return l;
    }

    public static ZipFileStatus generateFileStatus(String fileName, String lastHarvestDate, Date currentHarvestStartTime) {
        File file = new File(fileName);
        Path filePath = file.toPath();
        BasicFileAttributes attributes = ZipUtility.getBasicFileAttributes((Path)filePath);
        if (attributes != null && attributes.creationTime() != null) {
            long milliseconds = attributes.creationTime().to(TimeUnit.MILLISECONDS);
            if (milliseconds > Long.MIN_VALUE && milliseconds < Long.MAX_VALUE) {
                Date creationDate = new Date(attributes.creationTime().to(TimeUnit.MILLISECONDS));
                Date modifiedDate = new Date(attributes.lastModifiedTime().to(TimeUnit.MILLISECONDS));
                return ZipUtility.getFileStatusValues((Date)creationDate, (Date)modifiedDate, (Date)ZipUtility.getDate((String)lastHarvestDate), (Date)currentHarvestStartTime);
            }
            LOG.error("Unable to calculate file download status for {}", (Object)fileName);
        }
        LOG.error("Unable to get details for file {}", (Object)fileName);
        return ZipFileStatus.NA;
    }

    private static Date getDate(String dateString) {
        Date dateValue = null;
        if (StringUtils.isNotEmpty((CharSequence)dateString)) {
            DateTimeFormatter formatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
            OffsetDateTime offsetDateTime = OffsetDateTime.parse(dateString, formatter);
            dateValue = Date.from(offsetDateTime.toInstant());
        }
        return dateValue;
    }

    private static BasicFileAttributes getBasicFileAttributes(Path filePath) {
        BasicFileAttributes attributes = null;
        try {
            attributes = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException exception) {
            LOG.error("Error occurred while getting file details: {} ", (Object)exception.getMessage());
        }
        return attributes;
    }

    private static ZipFileStatus getFileStatusValues(Date creationDate, Date modifiedDate, Date lastHarvestedOn, Date currentHarvestStartTime) {
        if (lastHarvestedOn == null && creationDate.after(currentHarvestStartTime)) {
            return ZipFileStatus.NEW;
        }
        if (lastHarvestedOn != null) {
            if (modifiedDate.before(lastHarvestedOn) || modifiedDate.equals(lastHarvestedOn)) {
                return ZipFileStatus.UNCHANGED;
            }
            if (creationDate.after(currentHarvestStartTime) || creationDate.equals(currentHarvestStartTime)) {
                return ZipFileStatus.REHARVESTED;
            }
        }
        return ZipFileStatus.CHANGED;
    }
}

