/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.downloads;

import eu.europeana.downloads.DownloadsStatus;
import eu.europeana.downloads.SetsUtility;
import eu.europeana.downloads.StatusReportConfig;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class StatusReportService {
    private static final Logger LOG = LogManager.getLogger(StatusReportService.class);
    private final StatusReportConfig config;

    public StatusReportService(StatusReportConfig config) {
        this.config = config;
    }

    public void publishStatusReportToSlack(String message) {
        LOG.info("Sending Slack Message : " + message);
        try {
            String slackWebhookApiAutomation = this.config.getSlackWebhook();
            if (StringUtils.isBlank((CharSequence)slackWebhookApiAutomation)) {
                LOG.error("Slack webhook not configured, status report will not be published over Slack.");
                return;
            }
            HttpPost httpPost = new HttpPost(slackWebhookApiAutomation);
            StringEntity entity = new StringEntity(message);
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("Content-type", "application/json");
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                LOG.info("Received status " + response.getStatusLine().getStatusCode() + " while calling slack!");
                if (response.getStatusLine().getStatusCode() == 200) {
                    LOG.info(" Successfully sent slack message !");
                }
            }
        }
        catch (IOException e) {
            LOG.error("Exception occurred while sending slack message !! " + e.getMessage());
        }
    }

    public String uploadReportInCsv(String fileInput, String fileName) {
        try (FileWriter csvWriter = new FileWriter(fileName);){
            csvWriter.append(fileInput);
        }
        catch (IOException e) {
            LOG.error("Exception occured during file Creation. {}", (Object)e.getMessage());
        }
        LOG.info("Report file {} ", (Object)fileName);
        return fileName;
    }

    private static String getReportPath(String directoryLocation, String fileName) {
        return directoryLocation + "/" + fileName;
    }

    private static String getReportFileName() {
        String fileNameSuffix = new SimpleDateFormat("yyyy_MM_dd").format(new Date());
        return "status_" + fileNameSuffix + ".csv";
    }

    public void publishStatusReport(DownloadsStatus status, String subject, String directoryLocation, String downloadServerURL) {
        StringBuilder fileInput = new StringBuilder();
        StringBuilder jsonInput = new StringBuilder();
        String reportFileName = StatusReportService.getReportFileName();
        String reportFileUrl = downloadServerURL + "/" + reportFileName;
        SetsUtility.generateReportsInput((DownloadsStatus)status, (String)subject, (StringBuilder)fileInput, (StringBuilder)jsonInput, (String)reportFileUrl);
        this.uploadReportInCsv(fileInput.toString(), StatusReportService.getReportPath((String)directoryLocation, (String)reportFileName));
        this.publishStatusReportToSlack(jsonInput.toString());
    }
}

