/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.downloads;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Duration;
import org.joda.time.Period;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProgressLogger {
    private static final Logger LOG = LogManager.getLogger(ProgressLogger.class);
    private String setName;
    private long startTime;
    private long totalItems;
    private int logAfterSeconds;
    private long lastLogTime;

    public ProgressLogger(String setName, long totalItems, int logAfterSeconds) {
        this.setName = setName;
        this.lastLogTime = this.startTime = System.currentTimeMillis();
        this.totalItems = totalItems;
        this.logAfterSeconds = logAfterSeconds;
        LOG.debug("Create logger for {}", (Object)setName);
    }

    public void setTotalItems(long totalItems) {
        this.totalItems = totalItems;
    }

    public void logProgress(long itemsDone) {
        LOG.debug("Check progress for {} ", (Object)this.setName);
        Duration d = new Duration(this.lastLogTime, System.currentTimeMillis());
        if (this.logAfterSeconds > 0 && d.getMillis() / 1000L > (long)this.logAfterSeconds) {
            if (this.totalItems > 0L) {
                double itemsPerMS = (double)itemsDone * 1.0 / (double)(System.currentTimeMillis() - this.startTime);
                if (itemsPerMS * 1000.0 > 1.5) {
                    LOG.info("Set {} - Retrieved {} items of {} ({} records/sec). Time remaining is {}", (Object)this.setName, (Object)itemsDone, (Object)this.totalItems, (Object)Math.round(itemsPerMS * 1000.0), (Object)ProgressLogger.getDurationText((long)Math.round((double)(this.totalItems - itemsDone) / itemsPerMS)));
                } else {
                    LOG.info("Set {} - Retrieved {} items of {} ({} records/min). Time remaining is {}", (Object)this.setName, (Object)itemsDone, (Object)this.totalItems, (Object)Math.round(itemsPerMS * 1000.0 * 60.0), (Object)ProgressLogger.getDurationText((long)Math.round((double)(this.totalItems - itemsDone) / itemsPerMS)));
                }
            } else {
                LOG.info("Set {} - Retrieved {} items", (Object)this.setName, (Object)itemsDone);
            }
            this.lastLogTime = System.currentTimeMillis();
        }
    }

    public static String getDurationText(long durationInMs) {
        Period period = new Period(durationInMs);
        String result = period.getDays() >= 1 ? String.format("%d days, %d hours and %d minutes", period.getDays(), period.getHours(), period.getMinutes()) : (period.getHours() >= 1 ? String.format("%d hours and %d minutes", period.getHours(), period.getMinutes()) : (period.getMinutes() >= 1 ? String.format("%d minutes and %d seconds", period.getMinutes(), period.getSeconds()) : String.format("%d.%d seconds", period.getSeconds(), period.getMillis())));
        return result;
    }
}

