/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.downloads;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

@Service
public class MailService {
    private static final Logger LOG = LogManager.getLogger(MailService.class);
    @Autowired
    private JavaMailSender mailSender;

    private void sendSimpleMessage(String from, String[] cc, String[] to, String subject, String messageBody) {
        LOG.debug("Sending email ...");
        try {
            SimpleMailMessage message = new SimpleMailMessage();
            message.setFrom(from);
            message.setCc(cc);
            message.setTo(to);
            message.setSubject(subject);
            message.setText(messageBody);
            this.mailSender.send(message);
        }
        catch (MailException e) {
            LOG.error("A problem prevented sending a confirmation {} email to {}", (Object)subject, (Object)to, (Object)e);
        }
    }

    public void sendSimpleMessageUsingTemplate(String subject, SimpleMailMessage template, String ... templateArgs) {
        String messageBody = String.format(template.getText(), templateArgs);
        this.sendSimpleMessage(template.getFrom(), template.getCc(), template.getTo(), subject, messageBody);
    }
}

