/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.downloads;

import eu.europeana.downloads.ListRecordsQuery;
import eu.europeana.downloads.ListRecordsResult;
import eu.europeana.downloads.OAIPMHServiceClient;
import eu.europeana.downloads.ProgressLogger;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResourceAccessException;

public class ListSetsExecutor
implements Callable<ListRecordsResult> {
    private static final Logger LOG = LogManager.getLogger(ListSetsExecutor.class);
    private static final int MAX_ERRORS_PER_THREAD = 5;
    private static final int MAX_RETRIES_PER_THREAD = 2;
    private static ProgressLogger logger = null;
    private static long loggerThreadId;
    private int logProgressInterval;
    private List<String> sets;
    private String directoryLocation;
    private String metadataPrefix;
    private OAIPMHServiceClient oaipmhServer;

    public ListSetsExecutor(List<String> sets, String metadataPrefix, String directoryLocation, OAIPMHServiceClient oaipmhServer, int logProgressInterval) {
        this.sets = sets;
        this.metadataPrefix = metadataPrefix;
        this.directoryLocation = directoryLocation;
        this.oaipmhServer = oaipmhServer;
        this.logProgressInterval = logProgressInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRecordsResult call() throws Exception {
        int errors = 0;
        long counter = 0L;
        long start = System.currentTimeMillis();
        StringBuilder setsDownloaded = new StringBuilder();
        ListSetsExecutor listSetsExecutor = this;
        synchronized (listSetsExecutor) {
            if (logger == null) {
                logger = new ProgressLogger("List sets", (long)this.sets.size(), this.logProgressInterval);
                loggerThreadId = Thread.currentThread().getId();
                LOG.debug("Created new progress logger for thread {} - {} items, logging interval {} ms", (Object)loggerThreadId, (Object)this.sets.size(), (Object)this.logProgressInterval);
            }
        }
        HashMap<String, String> failedRecordCountPerSet = new HashMap<String, String>();
        for (String set : this.sets) {
            ListRecordsQuery listRecordsQuery = new ListRecordsQuery(this.metadataPrefix, set, this.directoryLocation, this.logProgressInterval);
            try {
                listRecordsQuery.execute(this.oaipmhServer);
                setsDownloaded.append(set).append(",");
            }
            catch (HttpServerErrorException | ResourceAccessException e) {
                LOG.error("Error retrieving set {} {}", (Object)set, (Object)e);
                Thread.sleep(2000L);
                boolean retrySuccess = this.retryTask(set);
                if (!retrySuccess) {
                    ++errors;
                }
            }
            catch (Exception e) {
                LOG.error("Error retrieving set {} {}", (Object)set, (Object)e);
                ++errors;
            }
            if (errors > 5) {
                LOG.error("Terminating ListRecords thread {} because too many errors occurred", (Object)Thread.currentThread().getId());
                break;
            }
            if (Thread.currentThread().getId() == loggerThreadId) {
                logger.logProgress(++counter);
            }
            long failedRecordCount = Long.valueOf(listRecordsQuery.recordsTobeDownloaded) - (long)listRecordsQuery.recordsDownloaded.intValue();
            failedRecordCountPerSet.put(set, String.valueOf(failedRecordCount));
        }
        return new ListRecordsResult((float)(System.currentTimeMillis() - start) / 1000.0f, setsDownloaded.toString(), errors, failedRecordCountPerSet);
    }

    private boolean retryTask(String set) {
        boolean success = false;
        for (int i = 1; i <= 2; ++i) {
            if (success) continue;
            try {
                LOG.info("Retrying the set {} {} times ", (Object)set, (Object)i);
                new ListRecordsQuery(this.metadataPrefix, set, this.directoryLocation, this.logProgressInterval).execute(this.oaipmhServer);
                success = true;
                continue;
            }
            catch (HttpServerErrorException | ResourceAccessException ex) {
                if (i != 2) continue;
                LOG.error("Error retrieving set {} after {} retries {}", (Object)set, (Object)i, (Object)ex);
                continue;
            }
            catch (Exception ex) {
                LOG.error("Error retrieving set {} after {} retries {}", (Object)set, (Object)i, (Object)ex);
                break;
            }
        }
        return success;
    }
}

