/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.downloads;

import eu.europeana.downloads.BaseQuery;
import eu.europeana.downloads.CSVFile;
import eu.europeana.downloads.DownloadsStatus;
import eu.europeana.downloads.ListRecordsResult;
import eu.europeana.downloads.ListSetsExecutor;
import eu.europeana.downloads.ListSetsQuery;
import eu.europeana.downloads.MailService;
import eu.europeana.downloads.OAIPMHQuery;
import eu.europeana.downloads.OAIPMHServiceClient;
import eu.europeana.downloads.ProgressLogger;
import eu.europeana.downloads.SetsUtility;
import eu.europeana.downloads.StatusReportService;
import eu.europeana.downloads.ZipFileStatus;
import eu.europeana.downloads.ZipUtility;
import eu.europeana.oaipmh.model.ListRecords;
import eu.europeana.oaipmh.model.Record;
import eu.europeana.oaipmh.model.response.ListRecordsResponse;
import eu.europeana.oaipmh.service.exception.OaiPmhException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.ZipOutputStream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ListRecordsQuery
extends BaseQuery
implements OAIPMHQuery {
    private static final Logger LOG = LogManager.getLogger(ListRecordsQuery.class);
    @Value(value="${metadata-prefix}")
    private String metadataPrefix;
    @Value(value="${harvest-from}")
    private String from;
    @Value(value="${harvest-sets}")
    private String set;
    @Value(value="${log-progress-interval}")
    private Integer logProgressInterval;
    @Value(value="${sets-folder}")
    private String directoryLocation;
    @Value(value="${harvest-threads}")
    private int threads;
    @Value(value="${server-url}")
    private String downloadServerURL;
    private String lastHarvestDate;
    private Date currentHarvestStartTime;
    private List<String> sets = new ArrayList();
    private ExecutorService threadPool;
    @Autowired
    private MailService emailService;
    @Autowired
    private SimpleMailMessage downloadsReportMail;
    @Autowired
    private StatusReportService statusReportService;
    public String recordsTobeDownloaded = "0";
    public Integer recordsDownloaded = 0;

    public ListRecordsQuery() {
    }

    public ListRecordsQuery(String metadataPrefix, String set, String directoryLocation, int logProgressInterval) {
        this.metadataPrefix = metadataPrefix;
        this.set = set;
        this.directoryLocation = directoryLocation;
        this.logProgressInterval = logProgressInterval;
    }

    @PostConstruct
    public final void initSets() {
        this.lastHarvestDate = SetsUtility.getLastHarvestDate((String)(this.directoryLocation + "/lastHarvestDate.txt"), (String)this.set).trim();
        if (!this.set.isEmpty() && !StringUtils.equals((CharSequence)this.set, (CharSequence)"ALL")) {
            this.sets.addAll(Arrays.asList(this.set.split(",")));
        }
        this.currentHarvestStartTime = new Date();
    }

    private void initThreadPool(int noOfSets, boolean selectiveUpdate) {
        if (this.threads < 1) {
            this.threads = 1;
        }
        if (selectiveUpdate && noOfSets < this.threads) {
            LOG.info("No Of Sets to be harvested is less than the configured threads. Sets size : {}. Threads : {} ", (Object)noOfSets, (Object)this.threads);
            this.threads = noOfSets;
            if (noOfSets < 1) {
                this.threads = 1;
            }
            LOG.info("Optimised the thread count to {} ", (Object)this.threads);
        }
        this.threadPool = Executors.newFixedThreadPool(this.threads);
    }

    public String getVerbName() {
        return "ListRecords";
    }

    public void execute(OAIPMHServiceClient oaipmhServer) throws OaiPmhException {
        if (this.sets.size() != 1 && this.threads > 1) {
            DownloadsStatus status = this.executeMultithreadListRecords(oaipmhServer, this.sets, this.lastHarvestDate, this.currentHarvestStartTime);
            this.sendEmail(status, false);
        } else {
            this.executeListRecords(oaipmhServer, this.set);
        }
    }

    private void sendEmail(DownloadsStatus status, boolean retryMail) {
        LOG.info("Sending email ");
        String subject = retryMail ? "Failed Sets Retry Status Report " : "Downloads Run Status Report ";
        String setsHarvested = retryMail ? status.getRetriedSetsStatus() : String.valueOf(status.getSetsHarvested());
        this.emailService.sendSimpleMessageUsingTemplate(subject, this.downloadsReportMail, new String[]{String.valueOf(status.getNoOfSets()), String.valueOf(status.getStartTime()), status.getTimeElapsed(), String.valueOf(setsHarvested), SetsUtility.getTabularData((DownloadsStatus)status)});
        this.statusReportService.publishStatusReport(status, subject, this.directoryLocation, this.downloadServerURL);
    }

    private DownloadsStatus executeMultithreadListRecords(OAIPMHServiceClient oaipmhServer, List<String> sets, String lastHarvestDate, Date currentHarvestStartTime) {
        long counter = 0L;
        long start = System.currentTimeMillis();
        boolean selectiveUpdate = false;
        ProgressLogger logger = new ProgressLogger("Multiple sets", -1L, this.logProgressInterval.intValue());
        List setsFromListSets = new ArrayList<String>();
        Iterator<String> iterator = sets.iterator();
        while (iterator.hasNext()) {
            setsFromListSets.add(iterator.next());
        }
        List setsToBeDeleted = Collections.EMPTY_LIST;
        if (setsFromListSets.isEmpty()) {
            setsToBeDeleted = this.getSetsToBeDeleted(oaipmhServer);
            setsFromListSets = this.getSetsFromListSet(oaipmhServer, lastHarvestDate, setsToBeDeleted);
            selectiveUpdate = true;
        }
        LOG.info("{} Sets to be harvested : {} ", (Object)setsFromListSets.size(), setsFromListSets);
        this.initThreadPool(setsFromListSets.size(), selectiveUpdate);
        DownloadsStatus status = new DownloadsStatus(setsFromListSets.size(), 0, new Date(start));
        if (!setsFromListSets.isEmpty()) {
            logger.setTotalItems((long)setsFromListSets.size());
            List results = null;
            ArrayList<ListSetsExecutor> tasks = new ArrayList<ListSetsExecutor>();
            int perThread = setsFromListSets.size() / this.threads;
            for (int i = 0; i < this.threads; ++i) {
                int fromIndex = i * perThread;
                int toIndex = (i + 1) * perThread;
                if (i == this.threads - 1) {
                    toIndex = setsFromListSets.size();
                }
                tasks.add(new ListSetsExecutor(setsFromListSets.subList(fromIndex, toIndex), this.metadataPrefix, this.directoryLocation, oaipmhServer, this.logProgressInterval.intValue()));
            }
            try {
                results = this.threadPool.invokeAll(tasks);
                ArrayList<String> setsDownloaded = new ArrayList<String>();
                HashMap failedrecordPerDownloadedSet = new HashMap();
                for (Future result : results) {
                    ListRecordsResult listRecordsResult = (ListRecordsResult)result.get();
                    LOG.info("Executor finished with {} errors in {} sec.", (Object)listRecordsResult.getErrors(), (Object)Float.valueOf(listRecordsResult.getTime()));
                    counter += (long)perThread;
                    if (StringUtils.isNotEmpty((CharSequence)listRecordsResult.getSetsDownloaded())) {
                        setsDownloaded.addAll(Arrays.asList(listRecordsResult.getSetsDownloaded().split("\\s*,\\s*")));
                    }
                    failedrecordPerDownloadedSet.putAll(listRecordsResult.getFailedRecordCountPerSet());
                    logger.logProgress(counter);
                }
                status.setSetsRecordCountMap(this.getRecordsCount(setsDownloaded));
                status.setSetsHarvested(setsDownloaded.size());
                ListRecordsQuery.getFailedSets(setsFromListSets, setsDownloaded, (String)this.directoryLocation);
                this.failSafeCheck(status.getNoOfSets(), status.getSetsHarvested(), setsFromListSets.size());
                Map fileStatusMap = this.getFileStatusMap(setsDownloaded, lastHarvestDate, currentHarvestStartTime, failedrecordPerDownloadedSet);
                this.updateFileStatusMapForDeletedSets(fileStatusMap, setsToBeDeleted);
                this.updateFileStatusMapForTheFailedSets(fileStatusMap, setsFromListSets);
                status.setsFileStatusMap(fileStatusMap);
                status.setFailedRecordsCountMap(failedrecordPerDownloadedSet);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.error("Interrupted.", (Throwable)e);
            }
            catch (ExecutionException e) {
                LOG.error("Problem with task thread execution.", (Throwable)e);
            }
        }
        if (sets.isEmpty()) {
            LOG.info("Creating/Updating the {} file ", (Object)"lastHarvestDate.txt");
            SetsUtility.writeNewHarvestDate((String)this.directoryLocation, (long)start);
            LOG.info("Last Harvest date set to : " + SetsUtility.getLastHarvestDate((String)(this.directoryLocation + "/lastHarvestDate.txt"), (String)this.set).trim());
        }
        this.clean();
        String timeElapsed = ProgressLogger.getDurationText((long)(System.currentTimeMillis() - start));
        status.setTimeElapsed(timeElapsed);
        LOG.info("ListRecords for all {} sets executed in {}. Harvested {} sets.", (Object)status.getNoOfSets(), (Object)timeElapsed, (Object)status.getSetsHarvested());
        return status;
    }

    private void updateFileStatusMapForTheFailedSets(Map<String, ZipFileStatus> fileStatusMap, List<String> setsFromListSets) {
        for (String failedSetId : setsFromListSets) {
            if (fileStatusMap.get(failedSetId) != null) continue;
            fileStatusMap.put(failedSetId, ZipFileStatus.NA);
        }
    }

    private void updateFileStatusMapForDeletedSets(Map<String, ZipFileStatus> fileStatusMap, List<String> setsDeleted) {
        for (String deletedSetId : setsDeleted) {
            fileStatusMap.put(deletedSetId, ZipFileStatus.DELETED);
        }
    }

    private Map<String, Long> getRecordsCount(List<String> setsDownloaded) {
        HashMap<String, Long> setsRecordsCountMap = new HashMap<String, Long>();
        for (String dataset : setsDownloaded) {
            long records = ZipUtility.getNumberOfEntriesInZip((String)SetsUtility.getFolderName((String)this.directoryLocation, (String)"XML"), (String)(dataset + ".zip"));
            setsRecordsCountMap.put(dataset, records);
        }
        return setsRecordsCountMap;
    }

    private void failSafeCheck(int totalsSets, int setsHarvested, int failedsets) {
        if (setsHarvested + failedsets != totalsSets) {
            LOG.error("Something went wrong. Sets size mismatch. Total Sets to be harvested {}, Successful harvested sets : {}, Failed Sets : {}", (Object)totalsSets, (Object)setsHarvested, (Object)failedsets);
        }
    }

    private List<String> getSetsFromListSet(OAIPMHServiceClient oaipmhServer, String lastHarvestDate, List<String> setsToBeDeleted) {
        List setsFromListSets;
        ListSetsQuery setsQuery = new ListSetsQuery(this.logProgressInterval.intValue());
        if (lastHarvestDate.isEmpty()) {
            setsFromListSets = setsQuery.getSets(oaipmhServer, null, null);
            LOG.info("There is no lastHarvestDate. ALL {} sets ready for harvest.", (Object)setsFromListSets.size());
        } else {
            if (!setsToBeDeleted.isEmpty()) {
                LOG.info("{} De-published datasets : {} ", (Object)setsToBeDeleted.size(), setsToBeDeleted);
                SetsUtility.deleteDataset(setsToBeDeleted, (String)this.directoryLocation, (String)"XML");
                SetsUtility.deleteDataset(setsToBeDeleted, (String)this.directoryLocation, (String)"TTL");
            } else {
                LOG.info("There are no De-published datasets");
            }
            LOG.info("Executing ListSet to get Updated/Newly-Created datasets since {}", (Object)lastHarvestDate);
            setsFromListSets = setsQuery.getSets(oaipmhServer, lastHarvestDate, null);
            LOG.info("Updated or newly created datasets count is {} ", (Object)setsFromListSets.size());
        }
        return setsFromListSets;
    }

    private List<String> getSetsToBeDeleted(OAIPMHServiceClient oaipmhServer) {
        return SetsUtility.getSetsToBeDeleted((OAIPMHServiceClient)oaipmhServer, (String)SetsUtility.getFolderName((String)this.directoryLocation, (String)"XML"), (int)this.logProgressInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeListRecords(OAIPMHServiceClient oaipmhServer, String setIdentifier) {
        String ttlZipName;
        String xmlZipName;
        long start;
        long counter;
        block31: {
            counter = 0L;
            this.recordsDownloaded = 0;
            start = System.currentTimeMillis();
            ProgressLogger logger = new ProgressLogger(setIdentifier, -1L, this.logProgressInterval.intValue());
            String request = this.getRequest(oaipmhServer.getOaipmhServer(), setIdentifier);
            ListRecordsResponse response = oaipmhServer.getListRecordRequest(request);
            ListRecords responseObject = response.getListRecords();
            xmlZipName = SetsUtility.getZipsFolder((String)this.directoryLocation, (String)"XML", (String)setIdentifier);
            ttlZipName = SetsUtility.getZipsFolder((String)this.directoryLocation, (String)"TTL", (String)setIdentifier);
            try (ZipOutputStream xmlZout = new ZipOutputStream(new FileOutputStream(new File(xmlZipName)));
                 ZipOutputStream ttlZout = new ZipOutputStream(new FileOutputStream(new File(ttlZipName)));
                 OutputStreamWriter writer = new OutputStreamWriter(xmlZout);
                 OutputStreamWriter writer1 = new OutputStreamWriter(ttlZout);){
                Integer n;
                if (responseObject == null) break block31;
                counter += (long)responseObject.getRecords().size();
                if (responseObject.getResumptionToken() != null) {
                    logger.setTotalItems(responseObject.getResumptionToken().getCompleteListSize());
                    this.recordsTobeDownloaded = String.valueOf(responseObject.getResumptionToken().getCompleteListSize());
                } else {
                    logger.setTotalItems((long)responseObject.getRecords().size());
                    this.recordsTobeDownloaded = String.valueOf(responseObject.getRecords().size());
                }
                for (Record record : responseObject.getRecords()) {
                    ZipUtility.writeInZip((ZipOutputStream)xmlZout, (OutputStreamWriter)writer, (Record)record, (String)"XML");
                    ZipUtility.writeInZip((ZipOutputStream)ttlZout, (OutputStreamWriter)writer1, (Record)record, (String)"TTL");
                    n = this.recordsDownloaded;
                    this.recordsDownloaded = this.recordsDownloaded + 1;
                }
                while (responseObject.getResumptionToken() != null) {
                    request = this.getResumptionRequest(oaipmhServer.getOaipmhServer(), responseObject.getResumptionToken().getValue());
                    response = oaipmhServer.getListRecordRequest(request);
                    responseObject = response.getListRecords();
                    for (Record record : responseObject.getRecords()) {
                        ZipUtility.writeInZip((ZipOutputStream)xmlZout, (OutputStreamWriter)writer, (Record)record, (String)"XML");
                        ZipUtility.writeInZip((ZipOutputStream)ttlZout, (OutputStreamWriter)writer1, (Record)record, (String)"TTL");
                        n = this.recordsDownloaded;
                        this.recordsDownloaded = this.recordsDownloaded + 1;
                    }
                    if (responseObject == null) {
                        break;
                    }
                    logger.logProgress(counter += (long)responseObject.getRecords().size());
                }
            }
            catch (IOException e) {
                LOG.error("Error creating outputStreams ", (Throwable)e);
            }
            finally {
                LOG.info("Dataset:" + this.set + " Total records: " + this.recordsTobeDownloaded + " Downloaded:" + this.recordsDownloaded + " Failed records:" + (Long.valueOf(this.recordsTobeDownloaded) - (long)this.recordsDownloaded.intValue()));
            }
        }
        ZipUtility.createMD5SumFile((String)xmlZipName);
        ZipUtility.createMD5SumFile((String)ttlZipName);
        LOG.info("ListRecords for set {} executed in {}. Harvested {} records.", (Object)setIdentifier, (Object)ProgressLogger.getDurationText((long)(System.currentTimeMillis() - start)), (Object)counter);
    }

    private String getResumptionRequest(String oaipmhServer, String resumptionToken) {
        return this.getBaseRequest(oaipmhServer, this.getVerbName()) + String.format("&resumptionToken=%s", resumptionToken);
    }

    private String getRequest(String oaipmhServer, String setIdentifier) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseRequest(oaipmhServer, this.getVerbName()));
        sb.append(String.format("&metadataPrefix=%s", this.metadataPrefix));
        if (this.from != null && !this.from.isEmpty()) {
            sb.append(String.format("&from=%s", this.from));
        }
        if (this.set != null && !this.set.isEmpty() && !StringUtils.equals((CharSequence)this.set, (CharSequence)"ALL")) {
            sb.append(String.format("&set=%s", setIdentifier));
        }
        return sb.toString();
    }

    private static void getFailedSets(List<String> sets, List<String> setsDownloaded, String directoryLocation) {
        sets.removeAll(setsDownloaded);
        CSVFile.writeInCsv(sets, (String)directoryLocation);
        LOG.info("Failed sets file values : " + CSVFile.readCSVFile((String)CSVFile.getCsvFilePath((String)directoryLocation)));
    }

    private Map<String, ZipFileStatus> getFileStatusMap(List<String> setsDownloaded, String lastHarvestDate, Date currentHarvestStartTime, Map<String, String> failedrecordPerSet) {
        String fileName;
        HashMap<String, ZipFileStatus> statusMap = new HashMap<String, ZipFileStatus>();
        for (String string : setsDownloaded) {
            fileName = SetsUtility.getFolderName((String)this.directoryLocation, (String)"XML") + "/" + string + ".zip";
            statusMap.put(string, ZipUtility.generateFileStatus((String)fileName, (String)lastHarvestDate, (Date)currentHarvestStartTime));
        }
        for (Map.Entry entry : failedrecordPerSet.entrySet()) {
            if (statusMap.get(entry.getKey()) != null) continue;
            fileName = SetsUtility.getFolderName((String)this.directoryLocation, (String)"XML") + "/" + (String)entry.getKey() + ".zip";
            statusMap.put((String)entry.getKey(), ZipUtility.generateFileStatus((String)fileName, (String)lastHarvestDate, (Date)currentHarvestStartTime));
        }
        return statusMap;
    }

    @PreDestroy
    private void clean() {
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
    }

    public String getDownloadServerURL() {
        return this.downloadServerURL;
    }
}

