/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.downloads;

import eu.europeana.downloads.BaseQuery;
import eu.europeana.downloads.ListIdentifierExecutor;
import eu.europeana.downloads.ListRecordsResult;
import eu.europeana.downloads.ListSetsQuery;
import eu.europeana.downloads.LogFile;
import eu.europeana.downloads.OAIPMHQuery;
import eu.europeana.downloads.OAIPMHServiceClient;
import eu.europeana.downloads.ProgressLogger;
import eu.europeana.oaipmh.model.Header;
import eu.europeana.oaipmh.model.ListIdentifiers;
import eu.europeana.oaipmh.model.response.ListIdentifiersResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Deprecated(since="15-July-2020")
@Component
public class ListIdentifiersQuery
extends BaseQuery
implements OAIPMHQuery {
    private static final Logger LOG = LogManager.getLogger(ListIdentifiersQuery.class);
    @Value(value="${metadata-prefix}")
    private String metadataPrefix;
    @Value(value="${harvest-from}")
    private String from;
    @Value(value="${harvest-sets}")
    private String set;
    @Value(value="${log-progress-interval}")
    private Integer logProgressInterval;
    @Value(value="${harvest-threads}")
    private int threads;
    @Value(value="${sets-folder}")
    private String directoryLocation;
    private ExecutorService threadPool;
    private List<String> sets = new ArrayList();

    public ListIdentifiersQuery() {
    }

    public ListIdentifiersQuery(String metadataPrefix, String from, String set, int logProgressInterval) {
        this.metadataPrefix = metadataPrefix;
        this.from = from;
        this.set = set;
        this.logProgressInterval = logProgressInterval;
    }

    @PostConstruct
    public void initSets() {
        if (this.set != null && !this.set.isEmpty() && !StringUtils.equals((CharSequence)this.set, (CharSequence)"ALL")) {
            this.sets.addAll(Arrays.asList(this.set.split(",")));
        }
    }

    private void initThreadPool() {
        if (this.threads < 1 || this.sets.size() == 1) {
            this.threads = 1;
        }
        this.threadPool = Executors.newFixedThreadPool(this.threads);
    }

    public String getVerbName() {
        return "ListIdentifiers";
    }

    public void execute(OAIPMHServiceClient oaipmhServer) {
        if (this.sets != null && this.sets.size() != 1 && this.threads > 1) {
            this.executeMultithreadListRecords(oaipmhServer, this.sets);
        } else {
            this.executeSingleThreadListRecord(oaipmhServer, this.set);
        }
    }

    public List<String> getIdentifiers(OAIPMHServiceClient oaipmhServer, String setName) {
        ArrayList<String> identifiers = new ArrayList<String>();
        this.execute(oaipmhServer, setName, identifiers);
        return identifiers;
    }

    private void executeSingleThreadListRecord(OAIPMHServiceClient oaipmhServer, String setIdentifier) {
        this.initThreadPool();
        long start = System.currentTimeMillis();
        ProgressLogger logger = new ProgressLogger("Single set", 1L, this.logProgressInterval.intValue());
        LOG.info(" {} Set to be executed by {} threads", (Object)setIdentifier, (Object)this.threads);
        List results = null;
        ArrayList<ListIdentifierExecutor> tasks = new ArrayList<ListIdentifierExecutor>();
        tasks.add(new ListIdentifierExecutor(this.sets, this.from, this.metadataPrefix, this.directoryLocation, oaipmhServer, this.logProgressInterval.intValue()));
        try {
            results = this.threadPool.invokeAll(tasks);
            for (Future result : results) {
                ListRecordsResult listRecordsResult = (ListRecordsResult)result.get();
                LOG.info("Executor finished with {} errors in {} sec.", (Object)listRecordsResult.getErrors(), (Object)Float.valueOf(listRecordsResult.getTime()));
                logger.logProgress(1L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Interrupted.", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.error("Problem with task thread execution.", (Throwable)e);
        }
        this.clean();
        LOG.info("ListIdentifier for set {} executed in {}. Harvested {} sets. ", (Object)setIdentifier, (Object)ProgressLogger.getDurationText((long)(System.currentTimeMillis() - start)), (Object)this.sets.size());
    }

    private void executeMultithreadListRecords(OAIPMHServiceClient oaipmhServer, List<String> sets) {
        this.initThreadPool();
        List setsFromListSets = sets;
        long counter = 0L;
        long start = System.currentTimeMillis();
        ProgressLogger logger = new ProgressLogger("Multiple sets", -1L, this.logProgressInterval.intValue());
        if (sets.isEmpty()) {
            ListSetsQuery setsQuery = new ListSetsQuery(this.logProgressInterval.intValue());
            setsFromListSets = setsQuery.getSets(oaipmhServer, null, null);
        }
        LOG.info(" {} Sets to be executed by {} threads", (Object)setsFromListSets.size(), (Object)this.threads);
        List results = null;
        ArrayList<ListIdentifierExecutor> tasks = new ArrayList<ListIdentifierExecutor>();
        int perThread = setsFromListSets.size() / this.threads;
        for (int i = 0; i < this.threads; ++i) {
            int fromIndex = i * perThread;
            int toIndex = (i + 1) * perThread;
            if (i == this.threads - 1) {
                toIndex = setsFromListSets.size();
            }
            tasks.add(new ListIdentifierExecutor(setsFromListSets.subList(fromIndex, toIndex), this.from, this.metadataPrefix, this.directoryLocation, oaipmhServer, this.logProgressInterval.intValue()));
        }
        try {
            results = this.threadPool.invokeAll(tasks);
            for (Future result : results) {
                ListRecordsResult listRecordsResult = (ListRecordsResult)result.get();
                LOG.info("Executor finished with {} errors in {} sec.", (Object)listRecordsResult.getErrors(), (Object)Float.valueOf(listRecordsResult.getTime()));
                logger.logProgress(counter += (long)perThread);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Interrupted.", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.error("Problem with task thread execution.", (Throwable)e);
        }
        this.clean();
        LOG.info("ListIdentifier for all sets executed in {}. Harvested {} sets ", (Object)ProgressLogger.getDurationText((long)(System.currentTimeMillis() - start)), (Object)sets.size());
    }

    private void execute(OAIPMHServiceClient oaipmhServer, String setName, List<String> identifiers) {
        long counter = 0L;
        long start = System.currentTimeMillis();
        ProgressLogger logger = new ProgressLogger(setName, -1L, this.logProgressInterval.intValue());
        String request = this.getRequest(oaipmhServer.getOaipmhServer(), setName);
        ListIdentifiersResponse response = (ListIdentifiersResponse)oaipmhServer.makeRequest(request, ListIdentifiersResponse.class);
        ListIdentifiers responseObject = response.getListIdentifiers();
        if (responseObject != null) {
            counter += (long)responseObject.getHeaders().size();
            if (responseObject.getResumptionToken() != null) {
                logger.setTotalItems(responseObject.getResumptionToken().getCompleteListSize());
            } else {
                logger.setTotalItems((long)responseObject.getHeaders().size());
            }
            this.collectIdentifiers(responseObject.getHeaders(), identifiers);
            while (responseObject.getResumptionToken() != null && (responseObject = (response = (ListIdentifiersResponse)oaipmhServer.makeRequest(request = this.getResumptionRequest(oaipmhServer.getOaipmhServer(), responseObject.getResumptionToken().getValue()), ListIdentifiersResponse.class)).getListIdentifiers()) != null) {
                logger.logProgress(counter += (long)responseObject.getHeaders().size());
                this.collectIdentifiers(responseObject.getHeaders(), identifiers);
            }
        }
        LOG.info("ListIdentifiers for set {} executed in {}. Retrieved {} identifiers", (Object)setName, (Object)ProgressLogger.getDurationText((long)(System.currentTimeMillis() - start)), (Object)counter);
    }

    private void writeDataToLogFile(ListIdentifiers responseObject) {
        ListIterator it = responseObject.getHeaders().listIterator();
        while (it.hasNext()) {
            Header header = (Header)it.next();
            LogFile.OUT.info("{} {}", header.getSetSpec().get(0), (Object)header.getIdentifier());
        }
    }

    private void collectIdentifiers(List<Header> headers, List<String> identifiers) {
        if (identifiers != null) {
            for (Header header : headers) {
                identifiers.add(header.getIdentifier());
            }
        }
    }

    private String getResumptionRequest(String oaipmhServer, String resumptionToken) {
        return this.getBaseRequest(oaipmhServer, this.getVerbName()) + String.format("&resumptionToken=%s", resumptionToken);
    }

    private String getRequest(String oaipmhServer, String set) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseRequest(oaipmhServer, this.getVerbName()));
        sb.append(String.format("&metadataPrefix=%s", this.metadataPrefix));
        if (this.from != null && !this.from.isEmpty()) {
            sb.append(String.format("&from=%s", this.from));
        }
        if (set != null) {
            sb.append(String.format("&set=%s", set));
        }
        return sb.toString();
    }

    @PreDestroy
    private void clean() {
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
    }
}

