/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.downloads;

import eu.europeana.downloads.GetRecordQuery;
import eu.europeana.downloads.ListIdentifiersQuery;
import eu.europeana.downloads.ListRecordsResult;
import eu.europeana.downloads.OAIPMHServiceClient;
import eu.europeana.downloads.ProgressLogger;
import eu.europeana.downloads.ZipUtility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated(since="15-July-2020")
public class ListIdentifierExecutor
implements Callable<ListRecordsResult> {
    private static final Logger LOG = LogManager.getLogger(ListIdentifierExecutor.class);
    private static final int MAX_ERRORS_PER_THREAD = 5;
    private static ProgressLogger logger = null;
    private static long loggerThreadId;
    private String metadataPrefix;
    private String from;
    private List<String> sets;
    private OAIPMHServiceClient oaipmhServer;
    private String directoryLocation;
    private int logProgressInterval;

    public ListIdentifierExecutor(List<String> sets, String from, String metadataPrefix, String directoryLocation, OAIPMHServiceClient oaipmhServer, int logProgressInterval) {
        this.sets = sets;
        this.from = from;
        this.metadataPrefix = metadataPrefix;
        this.directoryLocation = directoryLocation;
        this.oaipmhServer = oaipmhServer;
        this.logProgressInterval = logProgressInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRecordsResult call() {
        int errors = 0;
        long counter = 0L;
        long start = System.currentTimeMillis();
        ListIdentifierExecutor listIdentifierExecutor = this;
        synchronized (listIdentifierExecutor) {
            if (logger == null) {
                logger = new ProgressLogger("ListIdentifiers Sets", (long)this.sets.size(), this.logProgressInterval);
                loggerThreadId = Thread.currentThread().getId();
                LOG.debug("Created new progress logger for thread {} - {} items, logging interval {} ms", (Object)loggerThreadId, (Object)this.sets.size(), (Object)this.logProgressInterval);
            }
        }
        for (String set : this.sets) {
            try {
                ListIdentifiersQuery identifiersQuery = new ListIdentifiersQuery(this.metadataPrefix, this.from, set, this.logProgressInterval);
                identifiersQuery.initSets();
                List identifiers = identifiersQuery.getIdentifiers(this.oaipmhServer, set);
                errors += this.harvestIdentifiers(identifiers, set);
            }
            catch (Exception e) {
                LOG.error("Error collecting identifiers for set {}", (Object)set, (Object)e);
                ++errors;
            }
            if (errors > 5) {
                LOG.error("Terminating getIdentifiers thread {} because too many errors occurred", (Object)Thread.currentThread().getId());
                break;
            }
            if (Thread.currentThread().getId() != loggerThreadId) continue;
            logger.logProgress(++counter);
        }
        return new ListRecordsResult((float)(System.currentTimeMillis() - start) / 1000.0f, String.join((CharSequence)", ", this.sets), errors, null);
    }

    private int harvestIdentifiers(List<String> identifiers, String setIdentifier) {
        int errors = 0;
        long start = System.currentTimeMillis();
        String zipName = this.directoryLocation + "/" + setIdentifier + ".zip";
        try (ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(new File(zipName)));
             OutputStreamWriter writer = new OutputStreamWriter(zout);){
            for (String identifier : identifiers) {
                try {
                    new GetRecordQuery(this.metadataPrefix, identifier, zout, writer).execute(this.oaipmhServer);
                }
                catch (Exception e) {
                    LOG.error("Error retrieving identifier {} for set {} ", (Object)identifier, (Object)setIdentifier, (Object)e);
                    if (++errors <= 5) continue;
                    LOG.error("Terminating GetRecord thread {} because too many errors occurred", (Object)Thread.currentThread().getId());
                    break;
                }
            }
            LOG.info("ListIdentifiers for set " + setIdentifier + " executed in " + ProgressLogger.getDurationText((long)(System.currentTimeMillis() - start)) + ". Harvested " + identifiers.size() + " identifiers.");
        }
        catch (IOException e) {
            LOG.error("Error creating zip file ", (Throwable)e);
            ++errors;
        }
        ZipUtility.createMD5SumFile((String)zipName);
        return errors;
    }
}

