/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.downloads;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CSVFile {
    private static final Logger LOG = LogManager.getLogger(CSVFile.class);

    private CSVFile() {
    }

    public static void writeInCsv(List<String> sets, String directoryLocation) {
        String fileName = directoryLocation + "/FailedSetsReport.csv";
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), StandardCharsets.UTF_8));){
            String header = "Failed Sets";
            bw.write(header);
            bw.newLine();
            for (String set : sets) {
                bw.write(set);
                bw.newLine();
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unsupported encoding format", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOG.error("Error creating the file ", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Error creating csv file", (Throwable)e);
        }
    }

    private static String getDate() {
        Date today = Calendar.getInstance().getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
        return formatter.format(today);
    }

    public static String getCsvFilePath(String directoryLocation) {
        return directoryLocation + "/FailedSetsReport.csv";
    }

    public static List<String> readCSVFile(String path) {
        ArrayList<String> failedSets = new ArrayList<String>();
        try (BufferedReader csvReader = new BufferedReader(new FileReader(path));){
            String nextLine;
            while ((nextLine = csvReader.readLine()) != null) {
                if (StringUtils.equals((CharSequence)nextLine, (CharSequence)"Failed Sets")) continue;
                failedSets.add(nextLine);
            }
        }
        catch (FileNotFoundException e) {
            LOG.error("{} file doesn't exist. Failed sets report not generated", (Object)"FailedSetsReport");
        }
        catch (IOException e) {
            LOG.error("Error reading the {} file", (Object)"FailedSetsReport", (Object)e);
        }
        return failedSets;
    }
}

