/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.downloads;

import eu.europeana.downloads.TurtleResponseParser;
import eu.europeana.oaipmh.model.Record;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZipUtility {
    private static final Logger LOG = LogManager.getLogger(ZipUtility.class);

    private ZipUtility() {
    }

    public static void writeInZip(ZipOutputStream zout, OutputStreamWriter writer, Record record, String fileFormat) {
        try {
            zout.putNextEntry(new ZipEntry(ZipUtility.getEntryName((Record)record, (String)fileFormat)));
            writer.write(ZipUtility.dataToWriteInZip((String)record.getMetadata().getMetadata(), (String)fileFormat));
            writer.flush();
            zout.closeEntry();
        }
        catch (IOException e) {
            LOG.error("Error writing the zip entry", (Throwable)e);
        }
    }

    private static String dataToWriteInZip(String metadata, String fileFormat) {
        if (StringUtils.equals((CharSequence)fileFormat, (CharSequence)"TTL")) {
            return TurtleResponseParser.generateTurtle((String)metadata);
        }
        return metadata;
    }

    private static String getEntryName(Record record, String fileExtension) {
        String id = record.getHeader().getIdentifier();
        if (StringUtils.equals((CharSequence)fileExtension, (CharSequence)"TTL")) {
            return StringUtils.substringAfterLast((String)id, (String)"/") + ".ttl";
        }
        return StringUtils.substringAfterLast((String)id, (String)"/") + ".xml";
    }

    public static String getDirectoryName(String identifier) {
        String id = StringUtils.remove((String)identifier, (String)"http://data.europeana.eu/item/");
        return id.split("/")[0];
    }

    public static void createMD5SumFile(String filename) {
        ZipUtility.createMD5SumFile((String)filename, (String)filename);
    }

    public static void createMD5SumFile(String sourceFolder, String destinationFolder) {
        try (BufferedWriter out = new BufferedWriter(new FileWriter(destinationFolder + ".md5sum"));){
            String checksum = ZipUtility.getMD5Sum((String)sourceFolder);
            out.write(checksum + "\n");
        }
        catch (IOException e) {
            LOG.error("Error creating MD5Sum file", (Throwable)e);
        }
    }

    private static String getMD5Sum(String file) {
        String checksum = null;
        try (FileInputStream is = new FileInputStream(new File(file));){
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = ((InputStream)is).read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            checksum = bigInt.toString(16);
        }
        catch (IOException e) {
            LOG.error("Unable to process file for MD5", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Error while generating MD5", (Throwable)e);
        }
        return checksum;
    }

    public static long getNumberOfEntriesInZip(String path, String zipName) {
        long l;
        ZipFile zipFile = new ZipFile(path + "/" + zipName);
        try {
            l = zipFile.size();
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("Error reading the zip file {}", (Object)zipName, (Object)e);
                return 0L;
            }
        }
        zipFile.close();
        return l;
    }
}

