/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.downloads;

import eu.europeana.oaipmh.model.GetRecord;
import eu.europeana.oaipmh.model.Header;
import eu.europeana.oaipmh.model.ListRecords;
import eu.europeana.oaipmh.model.RDFMetadata;
import eu.europeana.oaipmh.model.Record;
import eu.europeana.oaipmh.model.ResumptionToken;
import eu.europeana.oaipmh.model.response.GetRecordResponse;
import eu.europeana.oaipmh.model.response.ListRecordsResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class XMLResponseParser {
    private static final Logger LOG = LogManager.getLogger(XMLResponseParser.class);

    private XMLResponseParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GetRecordResponse parseGetRecordResponse(String responseAsString) {
        GetRecordResponse recordResponse = new GetRecordResponse();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        XMLEventReader eventReader = null;
        try (ByteArrayInputStream targetStream = new ByteArrayInputStream(responseAsString.getBytes());){
            eventReader = factory.createXMLEventReader(targetStream);
            GetRecord getRecord = new GetRecord();
            Record record = new Record();
            while (eventReader.hasNext()) {
                XMLEvent xmlEvent = eventReader.nextEvent();
                if (!xmlEvent.isStartElement()) continue;
                StartElement startElement = xmlEvent.asStartElement();
                XMLResponseParser.getTagsAndParse((XMLEventReader)eventReader, (StartElement)startElement, (Record)record, (String)responseAsString);
            }
            getRecord.setRecord(record);
            recordResponse.setGetRecord(getRecord);
        }
        catch (XMLStreamException e) {
            LOG.debug("Error parsing GetRecordResponse {} ", (Throwable)e);
        }
        catch (ParseException e) {
            LOG.debug("Error parsing Datestamp {} ", (Throwable)e);
        }
        catch (IOException e) {
            LOG.debug("Error creating the input stream {} ", (Throwable)e);
        }
        finally {
            if (eventReader != null) {
                try {
                    eventReader.close();
                }
                catch (XMLStreamException e) {}
            }
        }
        return recordResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ListRecordsResponse parseListRecordResponse(String responseAsString) {
        ListRecordsResponse recordResponse = new ListRecordsResponse();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        XMLEventReader eventReader = null;
        try (ByteArrayInputStream targetStream = new ByteArrayInputStream(responseAsString.getBytes());){
            eventReader = factory.createXMLEventReader(targetStream);
            ListRecords listRecords = new ListRecords();
            ArrayList<Record> recordList = new ArrayList<Record>();
            Record record = null;
            ResumptionToken resumptionToken = null;
            while (eventReader.hasNext()) {
                XMLEvent xmlEvent = eventReader.nextEvent();
                if (xmlEvent.isStartElement()) {
                    StartElement startElement = xmlEvent.asStartElement();
                    if ("record".equalsIgnoreCase(startElement.getName().getLocalPart())) {
                        record = new Record();
                    }
                    XMLResponseParser.getTagsAndParse((XMLEventReader)eventReader, (StartElement)startElement, (Record)record, (String)responseAsString);
                    if ("resumptionToken".equalsIgnoreCase(startElement.getName().getLocalPart())) {
                        resumptionToken = new ResumptionToken();
                        XMLResponseParser.parseResumptionToken((StartElement)startElement, (ResumptionToken)resumptionToken);
                        resumptionToken.setValue(eventReader.getElementText());
                    }
                }
                if (!xmlEvent.isEndElement() || !StringUtils.equalsIgnoreCase((CharSequence)xmlEvent.asEndElement().getName().getLocalPart(), (CharSequence)"record")) continue;
                recordList.add(record);
            }
            listRecords.setRecords(recordList);
            listRecords.setResumptionToken(resumptionToken);
            recordResponse.setListRecords(listRecords);
        }
        catch (XMLStreamException e) {
            LOG.debug("Error parsing ListRecordResponse {} ", (Throwable)e);
        }
        catch (ParseException e) {
            LOG.debug("Error parsing Datestamp {} ", (Throwable)e);
        }
        catch (IOException e) {
            LOG.debug("Error creating the input stream {} ", (Throwable)e);
        }
        finally {
            if (eventReader != null) {
                try {
                    eventReader.close();
                }
                catch (XMLStreamException e) {}
            }
        }
        return recordResponse;
    }

    private static void getTagsAndParse(XMLEventReader eventReader, StartElement startElement, Record record, String response) throws XMLStreamException, ParseException {
        switch (startElement.getName().getLocalPart()) {
            case "header": {
                XMLResponseParser.parseHeaderResource((XMLEventReader)eventReader, (Record)record);
                break;
            }
            case "metadata": {
                XMLResponseParser.paraseMetadataString((String)response, (String)record.getHeader().getIdentifier(), (Record)record);
                break;
            }
        }
    }

    private static void parseHeaderResource(XMLEventReader xmlEventReader, Record record) throws XMLStreamException, ParseException {
        Header header = new Header();
        record.setHeader(header);
        while (xmlEventReader.hasNext()) {
            XMLEvent e = xmlEventReader.nextEvent();
            if (e.isStartElement()) {
                StartElement se = e.asStartElement();
                switch (se.getName().getLocalPart()) {
                    case "identifier": {
                        header.setIdentifier(xmlEventReader.getElementText());
                        break;
                    }
                    case "datestamp": {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                        Date parsedDate = simpleDateFormat.parse(xmlEventReader.getElementText());
                        header.setDatestamp(parsedDate);
                        break;
                    }
                    case "setSpec": {
                        header.setSetSpec(xmlEventReader.getElementText());
                        break;
                    }
                }
            }
            if (!e.isEndElement() || !StringUtils.equalsIgnoreCase((CharSequence)e.asEndElement().getName().getLocalPart(), (CharSequence)"header")) continue;
            break;
        }
    }

    private static void paraseMetadataString(String response, String identifier, Record record) {
        RDFMetadata metadata = new RDFMetadata();
        record.setMetadata(metadata);
        StringBuilder metadataValue = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        if (StringUtils.contains((CharSequence)response, (CharSequence)identifier)) {
            int recordStartIndex = StringUtils.indexOf((CharSequence)response, (CharSequence)("<identifier>" + identifier + "</identifier>"));
            int metadataStartIndex = StringUtils.indexOf((CharSequence)response, (CharSequence)"<metadata>", (int)recordStartIndex);
            int metadataEndIndex = StringUtils.indexOf((CharSequence)response, (CharSequence)"</metadata>", (int)metadataStartIndex);
            String value = StringUtils.substring((String)response, (int)(metadataStartIndex + 10), (int)metadataEndIndex);
            metadataValue.append(value);
        }
        metadata.setMetadata(metadataValue.toString());
    }

    private static void parseResumptionToken(StartElement startElement, ResumptionToken resumptionToken) throws ParseException {
        Iterator<Attribute> iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            QName name = attribute.getName();
            if ("completeListSize".equalsIgnoreCase(name.getLocalPart())) {
                resumptionToken.setCompleteListSize((long)Integer.valueOf(attribute.getValue()).intValue());
            }
            if ("expirationDate".equalsIgnoreCase(name.getLocalPart())) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                Date parsedDate = simpleDateFormat.parse(attribute.getValue());
                resumptionToken.setExpirationDate(parsedDate);
            }
            if (!"cursor".equalsIgnoreCase(name.getLocalPart())) continue;
            resumptionToken.setCursor((long)Integer.valueOf(attribute.getValue()).intValue());
        }
    }
}

