/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.downloads;

import eu.europeana.downloads.CSVFile;
import eu.europeana.downloads.DownloadsStatus;
import eu.europeana.downloads.ListSetsQuery;
import eu.europeana.downloads.OAIPMHServiceClient;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class SetsUtility {
    private static final Logger LOG = LogManager.getLogger(SetsUtility.class);

    private SetsUtility() {
    }

    public static String getLastHarvestDate(String path, String set) {
        try {
            return Files.readString(Paths.get(path, new String[0]));
        }
        catch (NoSuchFileException e) {
            String msg = set.isEmpty() || set.equals("ALL") ? "ALL" : set;
            LOG.error("{} file doesn't exist. Harvesting sets : {} ", (Object)"lastHarvestDate.txt", (Object)msg);
        }
        catch (IOException e) {
            LOG.error("Error reading the lastHarvestDate file", (Throwable)e);
        }
        return "";
    }

    public static void writeNewHarvestDate(String directoryLocation, long startTime) {
        try (PrintWriter writer = new PrintWriter(directoryLocation + "/lastHarvestDate.txt", StandardCharsets.UTF_8);){
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            writer.write(formatter.format(new Date(startTime)));
        }
        catch (IOException e) {
            LOG.error("Error writing the {} file ", (Object)"lastHarvestDate.txt", (Object)e);
        }
    }

    public static List<String> getLastHarvestedSets(String directoryLocation) {
        List<String> result = new ArrayList<String>();
        try (Stream<Path> walk = Files.walk(Paths.get(directoryLocation, new String[0]), new FileVisitOption[0]);){
            result = walk.map(x -> StringUtils.substring((String)x.toString(), (int)(directoryLocation.length() + 1))).filter(f -> f.endsWith(".md5sum")).collect(Collectors.toList());
            result = result.stream().map(s -> s.replaceAll(".zip.md5sum", "")).collect(Collectors.toList());
        }
        catch (IOException e) {
            LOG.error("Error getting the details of last harvested sets ", (Throwable)e);
        }
        return result;
    }

    public static List<String> getSetsToBeDeleted(OAIPMHServiceClient oaipmhServer, String directoryLocation, int logProgressInterval) {
        LOG.info("Executing ListSet for De-published Datasets ");
        ListSetsQuery setsQuery = new ListSetsQuery(logProgressInterval);
        List lastHarvestedSets = SetsUtility.getLastHarvestedSets((String)directoryLocation);
        List currentSetsList = setsQuery.getSets(oaipmhServer, null, null);
        lastHarvestedSets.removeAll(currentSetsList);
        return lastHarvestedSets;
    }

    public static void deleteDataset(List<String> setsToBeDeleted, String directoryLocation, String fileFormat) {
        for (String set : setsToBeDeleted) {
            try {
                LOG.info("Deleting md5 file {}{} in {} ", (Object)set, (Object)".zip.md5sum", (Object)fileFormat);
                String fileName = SetsUtility.getFolderName((String)directoryLocation, (String)fileFormat) + "/" + set + ".zip.md5sum";
                Path md5sumFile = Paths.get(fileName, new String[0]);
                Files.delete(md5sumFile);
            }
            catch (IOException e) {
                LOG.error("Error deleting md5 file {} in {} ", (Object)set, (Object)fileFormat);
            }
        }
    }

    public static String getDate() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Date today = Calendar.getInstance().getTime();
        return formatter.format(today);
    }

    public static void createFolders(String directoryLocation) {
        File ttlDirectory = new File(directoryLocation, "TTL");
        File xmlDirectory = new File(directoryLocation, "XML");
        if (!ttlDirectory.exists()) {
            ttlDirectory.mkdir();
        }
        if (!xmlDirectory.exists()) {
            xmlDirectory.mkdir();
        }
    }

    public static String getFolderName(String directoryLocation, String fileFormat) {
        if (StringUtils.equals((CharSequence)fileFormat, (CharSequence)"TTL")) {
            return directoryLocation + "/TTL";
        }
        return directoryLocation + "/XML";
    }

    public static String getZipsFolder(String directoryLocation, String fileFormat, String setIdentifier) {
        String zipPath = SetsUtility.getFolderName((String)directoryLocation, (String)fileFormat);
        return zipPath + "/" + setIdentifier + ".zip";
    }

    public static String getRetriedSetsStatus(List<String> retriedSets, String directoryLocation) {
        StringBuilder status = new StringBuilder();
        List failedSets = CSVFile.readCSVFile((String)CSVFile.getCsvFilePath((String)directoryLocation));
        status.append("\n");
        if (failedSets.isEmpty()) {
            LOG.info("All the {} failed sets are harvested successfully", (Object)retriedSets.size());
            status.append(retriedSets);
            status.append(": ");
            status.append("Success");
        } else {
            LOG.info("All the {} failed sets are NOT harvested", (Object)retriedSets.size());
            retriedSets.removeAll(failedSets);
            if (!retriedSets.isEmpty()) {
                status.append(retriedSets);
                status.append(": ");
                status.append("Success");
                status.append("\n");
            }
            status.append(failedSets);
            status.append(": ");
            status.append("Failed");
            LOG.info("{} Sets successfully harvested : {} ", (Object)retriedSets.size(), retriedSets);
            LOG.info("{} Failed sets now : {} ", (Object)failedSets.size(), (Object)failedSets);
        }
        return status.toString();
    }

    public static String getTabularData(DownloadsStatus status) {
        StringBuilder tableData = new StringBuilder();
        if (!status.getSetsRecordCountMap().isEmpty()) {
            tableData.append("--------------------------------------------\n");
            tableData.append(String.format("%-15s%-15s%-15s\n", "Set_Id", "  |", "No_of_Records"));
            tableData.append("--------------------------------------------\n");
            long totalRecords = 0L;
            for (Map.Entry entry : status.getSetsRecordCountMap().entrySet()) {
                tableData.append(String.format("%-15s%-15s%-15s\n", entry.getKey(), "  |", entry.getValue()));
                totalRecords += ((Long)entry.getValue()).longValue();
            }
            tableData.append("--------------------------------------------\n");
            tableData.append(String.format("%-15s%-15s%-15s\n", "Total", "  |", " "));
            tableData.append("--------------------------------------------\n");
            tableData.append(String.format("%-15s%-15s%-15s\n", status.getSetsHarvested(), "  |", totalRecords));
            tableData.append("--------------------------------------------\n");
        }
        return tableData.toString();
    }
}

