/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.downloads;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import eu.europeana.downloads.CSVFile;
import eu.europeana.downloads.CheckSumGenerator;
import eu.europeana.downloads.ListIdentifiersQuery;
import eu.europeana.downloads.ListRecordsQuery;
import eu.europeana.downloads.ListSetsQuery;
import eu.europeana.downloads.OAIPMHQuery;
import eu.europeana.downloads.SetsUtility;
import eu.europeana.downloads.XMLResponseParser;
import eu.europeana.oaipmh.model.RDFMetadata;
import eu.europeana.oaipmh.model.response.GetRecordResponse;
import eu.europeana.oaipmh.model.response.ListIdentifiersResponse;
import eu.europeana.oaipmh.model.response.ListRecordsResponse;
import eu.europeana.oaipmh.model.response.ListSetsResponse;
import eu.europeana.oaipmh.model.response.OAIResponse;
import eu.europeana.oaipmh.model.serialize.GetRecordResponseDeserializer;
import eu.europeana.oaipmh.model.serialize.ListIdentifiersResponseDeserializer;
import eu.europeana.oaipmh.model.serialize.ListRecordsResponseDeserializer;
import eu.europeana.oaipmh.model.serialize.ListSetsResponseDeserializer;
import eu.europeana.oaipmh.model.serialize.RDFMetadataDeserializer;
import eu.europeana.oaipmh.service.exception.OaiPmhException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.XML;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class OAIPMHServiceClient {
    private static final Logger LOG = LogManager.getLogger(OAIPMHServiceClient.class);
    @Value(value="${oaipmh-server}")
    private String oaipmhServer;
    @Value(value="${harvest-method}")
    private String harvestMethod;
    @Value(value="${sets-folder}")
    private String directoryLocation;
    @Value(value="${execute-failed-sets}")
    private boolean executeFailedSets;
    private RestTemplate restTemplate = new RestTemplate();
    private ObjectMapper mapper;
    @Autowired
    private ListIdentifiersQuery listIdentifiersQuery;
    @Autowired
    private ListRecordsQuery listRecordsQuery;
    @Autowired
    private ListSetsQuery listSetsQuery;
    @Autowired
    private CheckSumGenerator checkSumGenerator;
    private Map<String, OAIPMHQuery> queries = new HashMap();

    @PostConstruct
    public void init() {
        this.queries.put("ListIdentifiers", this.listIdentifiersQuery);
        this.queries.put("ListRecords", this.listRecordsQuery);
        this.queries.put("ListSets", this.listSetsQuery);
        this.queries.put("CheckSum", this.checkSumGenerator);
        this.mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(ListIdentifiersResponse.class, (JsonDeserializer)new ListIdentifiersResponseDeserializer());
        module.addDeserializer(GetRecordResponse.class, (JsonDeserializer)new GetRecordResponseDeserializer());
        module.addDeserializer(RDFMetadata.class, (JsonDeserializer)new RDFMetadataDeserializer());
        module.addDeserializer(ListRecordsResponse.class, (JsonDeserializer)new ListRecordsResponseDeserializer());
        module.addDeserializer(ListSetsResponse.class, (JsonDeserializer)new ListSetsResponseDeserializer());
        this.mapper.registerModule((Module)module);
        LOG.info("Using OAI-PMH server at {}", (Object)this.oaipmhServer);
    }

    public String getOaipmhServer() {
        return this.oaipmhServer;
    }

    public void execute(String verb) throws OaiPmhException {
        OAIPMHQuery verbToExecute = (OAIPMHQuery)this.queries.get(verb);
        if (verbToExecute == null) {
            return;
        }
        SetsUtility.createFolders((String)this.directoryLocation);
        if (!StringUtils.equals((CharSequence)"CheckSum", (CharSequence)verbToExecute.getVerbName()) && this.executeFailedSets) {
            LOG.info("Failed sets flow will be executed : verb {}, executeFailedSets {}", (Object)this.oaipmhServer);
            List failedSets = CSVFile.readCSVFile((String)CSVFile.getCsvFilePath((String)this.directoryLocation));
            if (!failedSets.isEmpty()) {
                LOG.info("Found {} failed sets from previous run - {}", (Object)failedSets.size(), (Object)failedSets);
                verbToExecute.execute(this, failedSets);
            } else {
                LOG.info("No failed sets exist for this harvest.");
            }
        }
        verbToExecute.execute(this, null);
    }

    public OAIResponse makeRequest(String request, Class<? extends OAIResponse> responseClass) {
        OAIResponse response = null;
        String responseAsString = (String)this.restTemplate.getForObject(request, String.class, new Object[0]);
        String json = XML.toJSONObject((String)responseAsString).toString();
        try {
            response = (OAIResponse)this.mapper.readValue(json, responseClass);
        }
        catch (IOException e) {
            LOG.error("Exception when deserializing response.", (Throwable)e);
        }
        return response;
    }

    public String getHarvestMethod() {
        return this.harvestMethod;
    }

    public GetRecordResponse getGetRecordRequest(String request) {
        String responseAsString = (String)this.restTemplate.getForObject(request, String.class, new Object[0]);
        return XMLResponseParser.parseGetRecordResponse((String)responseAsString);
    }

    public ListRecordsResponse getListRecordRequest(String request) {
        String responseAsString = (String)this.restTemplate.getForObject(request, String.class, new Object[0]);
        return XMLResponseParser.parseListRecordResponse((String)responseAsString);
    }
}

