/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.downloads;

import eu.europeana.downloads.BaseQuery;
import eu.europeana.downloads.OAIPMHQuery;
import eu.europeana.downloads.OAIPMHServiceClient;
import eu.europeana.downloads.ProgressLogger;
import eu.europeana.oaipmh.model.ListSets;
import eu.europeana.oaipmh.model.Set;
import eu.europeana.oaipmh.model.response.ListSetsResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ListSetsQuery
extends BaseQuery
implements OAIPMHQuery {
    private static final Logger LOG = LogManager.getLogger(ListSetsQuery.class);
    @Value(value="${log-progress-interval}")
    private Integer logProgressInterval;

    public ListSetsQuery() {
    }

    public ListSetsQuery(int logProgressInterval) {
        this.logProgressInterval = logProgressInterval;
    }

    public String getVerbName() {
        return "ListSets";
    }

    public void execute(OAIPMHServiceClient oaipmhServer, List<String> sets) {
        this.execute(oaipmhServer, null, null, null);
    }

    public List<String> getSets(OAIPMHServiceClient oaipmhServer, String from, String until) {
        ArrayList<String> setsFromListSets = new ArrayList<String>();
        this.execute(oaipmhServer, setsFromListSets, from, until);
        return setsFromListSets;
    }

    private void execute(OAIPMHServiceClient oaipmhServer, List<String> setsFromListSet, String from, String until) {
        long counter = 0L;
        long start = System.currentTimeMillis();
        ProgressLogger logger = new ProgressLogger("All sets", -1L, this.logProgressInterval.intValue());
        String request = this.getRequest(oaipmhServer.getOaipmhServer(), from, until);
        ListSetsResponse response = (ListSetsResponse)oaipmhServer.makeRequest(request, ListSetsResponse.class);
        ListSets responseObject = response.getListSets();
        if (responseObject != null) {
            counter += (long)responseObject.getSets().size();
            if (responseObject.getResumptionToken() != null) {
                logger.setTotalItems(responseObject.getResumptionToken().getCompleteListSize());
            } else {
                logger.setTotalItems((long)responseObject.getSets().size());
            }
            this.collectSets(responseObject.getSets(), setsFromListSet);
            while (responseObject.getResumptionToken() != null && (responseObject = (response = (ListSetsResponse)oaipmhServer.makeRequest(request = this.getResumptionRequest(oaipmhServer.getOaipmhServer(), responseObject.getResumptionToken().getValue()), ListSetsResponse.class)).getListSets()) != null) {
                logger.logProgress(counter += (long)responseObject.getSets().size());
                this.collectSets(responseObject.getSets(), setsFromListSet);
            }
        }
        LOG.info("ListSet  executed in " + ProgressLogger.getDurationText((long)(System.currentTimeMillis() - start)) + ". Harvested " + counter + " sets.");
    }

    private void collectSets(List<Set> sets, List<String> setsFromListSet) {
        if (setsFromListSet != null) {
            for (Set set : sets) {
                setsFromListSet.add(set.getSetSpec());
            }
        }
    }

    private String getResumptionRequest(String oaipmhServer, String resumptionToken) {
        return this.getBaseRequest(oaipmhServer, this.getVerbName()) + String.format("&resumptionToken=%s", resumptionToken);
    }

    private String getRequest(String oaipmhServer, String from, String until) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseRequest(oaipmhServer, this.getVerbName()));
        if (from != null && !from.isEmpty()) {
            sb.append(String.format("&from=%s", from));
        }
        if (until != null && !until.isEmpty()) {
            sb.append(String.format("&until=%s", until));
        }
        return sb.toString();
    }
}

