/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.downloads;

import eu.europeana.downloads.BaseQuery;
import eu.europeana.downloads.OAIPMHQuery;
import eu.europeana.downloads.OAIPMHServiceClient;
import eu.europeana.downloads.ZipUtility;
import eu.europeana.oaipmh.model.GetRecord;
import eu.europeana.oaipmh.model.Header;
import eu.europeana.oaipmh.model.RDFMetadata;
import eu.europeana.oaipmh.model.Record;
import eu.europeana.oaipmh.model.response.GetRecordResponse;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Deprecated(since="15-July-2020")
@Component
public class GetRecordQuery
extends BaseQuery
implements OAIPMHQuery {
    private static final Logger LOG = LogManager.getLogger(GetRecordQuery.class);
    private String metadataPrefix;
    private String fileFormat;
    private String identifier;
    private ZipOutputStream zipOutputStream;
    private OutputStreamWriter writer;

    public GetRecordQuery() {
    }

    public GetRecordQuery(String metadataPrefix, String identifier, ZipOutputStream zipOutputStream, OutputStreamWriter writer) {
        this.metadataPrefix = metadataPrefix;
        this.identifier = identifier;
        this.zipOutputStream = zipOutputStream;
        this.writer = writer;
    }

    public String getVerbName() {
        return "GetRecord";
    }

    public void execute(OAIPMHServiceClient oaipmhServer, List<String> sets) {
        this.execute(oaipmhServer, this.identifier, this.zipOutputStream, this.writer);
    }

    private void execute(OAIPMHServiceClient oaipmhServer, String currentIdentifier, ZipOutputStream zout, OutputStreamWriter writer) {
        long start = System.currentTimeMillis();
        String request = this.getRequest(oaipmhServer.getOaipmhServer(), currentIdentifier);
        GetRecordResponse response = oaipmhServer.getGetRecordRequest(request);
        GetRecord responseObject = response.getGetRecord();
        if (responseObject != null) {
            RDFMetadata metadata;
            Record record = responseObject.getRecord();
            if (record == null) {
                LOG.error("No record in GetRecordResponse for identifier {}", (Object)currentIdentifier);
                return;
            }
            Header header = record.getHeader();
            if (header != null && currentIdentifier.equals(header.getIdentifier()) && ((metadata = record.getMetadata()) == null || metadata.getMetadata() == null || metadata.getMetadata().isEmpty())) {
                LOG.error("Empty metadata for identifier {}", (Object)currentIdentifier);
            }
            ZipUtility.writeInZip((ZipOutputStream)zout, (OutputStreamWriter)writer, (Record)record, (String)this.fileFormat);
        }
        LOG.info("GetRecord for identifier {} executed in {} ms", (Object)currentIdentifier, (Object)(System.currentTimeMillis() - start));
    }

    private String getRequest(String oaipmhServer, String identifier) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseRequest(oaipmhServer, this.getVerbName()));
        sb.append(String.format("&metadataPrefix=%s", this.metadataPrefix));
        if (identifier != null && !identifier.isEmpty()) {
            sb.append(String.format("&identifier=%s", identifier));
        }
        return sb.toString();
    }
}

